<?php
/**
 * Plugin Name: Core Add Page Templates
 * Plugin URI: https://core.trac.wordpress.org/ticket/13265
 * Description: Uses the proposed page_templates filter to inject a new template.
 * Version: 0.1
 * Author: Travis Smith and Devin Price
 * Author URI: http://wpsmith.net
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2, as published by the Free Software Foundation.  You may NOT assume
 * that you can use any other version of the GPL.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

define( 'CAPT_DIR', dirname( __FILE__ ) );

/**
 * Filter Templates
 * Validation/Sanitization of templates would be required by function.
 *
 * @param array $templates Array of templates.
 * @return array $templates Modified Array of templates.
 */
function capt_page_templates( $templates ) {
	$templates['template-test.php'] = __( 'Filtered Page Template', 'prefix' );
	return $templates;
}
add_filter( 'page_templates', 'capt_page_templates' );

/**
 * Template Page Inclusion/Redirect
 *
 * @param string $template Template name.
 * @return string $template Modified template name.
 */
function capt_template_include( $template ) {

	if ( is_page_template('template-test.php') )
		$template = CAPT_DIR . '/template-test.php';

	return $template;
}
add_action( 'template_include', 'capt_template_include' );