<?php
/**
 * Plugin Name: Code Tester
 * Plugin URI: https://wpsmith.net
 * Description: This contains all your site's core functionality so that it is theme independent.
 * Version: 0.1.1
 * Author: Travis Smith
 * Author URI: http://wpsmith.net
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU 
 * General Public License version 2, as published by the Free Software Foundation.  You may NOT assume 
 * that you can use any other version of the GPL.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
 
define( 'WPS_DIR', dirname( __FILE__ ) );

add_filter( 'page_templates', 'wps_page_templates' );
/**
 * Filter Templates
 * Validation/Sanitization of templates would be required by function.
 *
 * @param array $templates Array of templates.
 * @return array $templates Modified Array of templates.
 */
function wps_page_templates( $templates ) {
	$templates['test.php'] = 'Test';
	
	return $templates;
}

add_action( 'template_include', 'wps_template_include' ); //template_include
/**
 * Template Page Inclusion/Redirect
 *
 * @param string $template Template name.
 * @return string $template Modified template name.
 */
function wps_template_include( $template ) {
	
	if ( is_page_template( 'test.php' ) ) 
		$new_template = WPS_DIR . '\test.php'; 
	
	if ( isset( $new_template ) && wp_template_exists( $new_template ) )
		return $new_template;
		
	return $template;
}

/**
 * Determine whether file exists and is a template.
 *
 * @param string $full_path Full path of the file.
 * @return boolean|string False if not a template, Template Name if so.
 */
function wp_template_exists( $full_path ) {
	if ( file_exists( $full_path ) )
		preg_match( '|Template Name:(.*)$|mi', file_get_contents( $full_path ), $header );
	else
		return false;
		
	return _cleanup_header_comment( $header[1] );
}
