<?php
/**
 * Plugin Name: Core Remove Page Templates
 * Plugin URI: https://core.trac.wordpress.org/ticket/13265
 * Description: This filters the page templates in TwentyFourteen.
 * Version: 0.1
 * Author: Devin Price
 * Author URI: http://profiles.wordpress.org/downstairsdev/profile
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2, as published by the Free Software Foundation.  You may NOT assume
 * that you can use any other version of the GPL.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

/**
 * Filter Templates Page Templates
 *
 * @param array $templates Array of templates.
 * @return array $templates Modified Array of templates.
 */
function crpt_page_templates( $templates ) {

	// Unsets a template from TwentyFourteen
	unset( $templates['page-templates/contributors.php'] );

	// Unsets a template that doesn't exist, no error
	unset( $templates['page-templates/ignore.php'] );

	return $templates;
}

add_filter( 'page_templates', 'crpt_page_templates' );