# Rust & Actix Web - Build a CRUD API with SQLX and MySQL

In this article, we will explore how to use Rust, Actix Web, SQLX, and MySQL to build a CRUD (Create, Read, Update, Delete) API. We will start by setting up a MySQL database, defining our data model, and creating the necessary database tables. Next, we will use SQLX to interact with the database and Actix Web to build the API endpoints.

![Rust & Actix Web - Build a CRUD API with SQLX and MySQL](https://codevoweb.com/wp-content/uploads/2023/03/Rust-and-Actix-Web-Build-a-CRUD-API-with-SQLX-and-MySQL.webp)

## Topics Covered

- Run the Actix-Web MySQL CRUD API Project
- Run the Actix-Web API with a Frontend App
- Setup the Rust Project with Cargo
- Setup MySQL with Docker
- Run Database Migrations with SQLX
- Create the SQLX Database Model
- Create the Request Validation Structs
- Implement the CRUD Functionalities
    - Actix-Web Route Handler to Fetch All Records
    - Actix-Web Route Handler to Create a Record
    - Actix-Web Route Handler to Get a Record
    - Actix-Web Route Handler to Edit a Record
    - Actix-Web Route Handler to Delete a Record
    - Merge the Route Functions
- Register the Routes and Add CORS
- Test the Actix-Web MySQL CRUD API
    - Perform the CREATE Operation of CRUD
    - Perform the UPDATE Operation of CRUD
    - Perform the READ Operation of CRUD
    - Perform the DELETE Operation of CRUD

Read the entire article here: [https://codevoweb.com/rust-actix-web-build-crud-api-with-sqlx-and-mysql/](https://codevoweb.com/rust-actix-web-build-crud-api-with-sqlx-and-mysql/)

