# Build a FullStack tRPC CRUD App with TypeScript

In this guide, you'll create a full-stack note application that follows the CRUD (Create, Read, Update, and Delete) architecture with tRPC and use Prisma ORM to store data in an SQLite database. We'll build the tRPC API with Node.js and the UI with React.js. 

![Build a FullStack tRPC CRUD App with TypeScript](https://codevoweb.com/wp-content/uploads/2022/10/Build-a-FullStack-tRPC-CRUD-App-with-TypeScript.webp)

## Topics Covered

- Run the tRPC App Locally
- Setup the tRPC Project
- Create the tRPC API with Node.js
    - Add Prisma ORM and SQLite
    - Create Zod Validation Schemas
    - Create the tRPC Procedures
    - Setup the Express and tRPC Servers
- Create the tRPC Client with React.js
    - Setup the tRPC Client
    - Setup Tailwind CSS
    - Create Reusable Components
    - Create Note Component
    - Update Note Component
    - Delete Note Component
    - Get all Notes Component

Read the entire article here: [https://codevoweb.com/build-a-fullstack-trpc-crud-app-with-typescript/](https://codevoweb.com/build-a-fullstack-trpc-crud-app-with-typescript/)

