# Implement Authentication with Supabase in Next.js 14

In this article, you'll learn how to integrate Supabase with Next.js 14 for email and password authentication, as well as Google and GitHub OAuth. The tutorial covers protecting pages to ensure only authenticated users can access them, fetching the user's session in a React Server Component, and automatically refreshing cookies in the background when the user's session expires.

![Implement Authentication with Supabase in Next.js 14](https://codevoweb.com/wp-content/uploads/2024/02/Implement-Authentication-with-Supabase-in-Next.js-14.webp)

## Topics Covered

- Running the Supabase and Next.js 14 Authentication App
- Demo of the tRPC Application
- Set up the Next.js 14 Project
- Install the Necessary Dependencies
- Create a Project on Supabase
- Create a Supabase Server Client
- Create the Validation Schemas
- Create Server Actions to Handle SignUp and Login
- Get the Authenticated User's Session
- Create a Header Component with Logout Functionality
- Register an Account with Supabase in Next.js 14
  - Create the Registration Form
  - Create the Registration Page
- Login with Supabase in Next.js 14
  - Create the Login Form
  - Create the Login Page
- Create the Home Page and a Protected Page
- Set up OAuth with Supabase in Next.js 14
  - Generate the OAuth Credentials on GitHub
  - Generate the OAuth Credentials on Google
  - Create a Supabase Browser Client
  - Create an API endpoint for handling
  - Implement OAuth in the Login Form
- Create a Next.js Middleware to Refresh Cookies
- Conclusion

Read the entire article here: [https://codevoweb.com/implement-authentication-with-supabase-in-nextjs-14/](https://codevoweb.com/implement-authentication-with-supabase-in-nextjs-14/)

# Setup Google and GitHub OAuth with Supabase in Next.js 14

This tutorial guides you through the process of integrating Google and GitHub OAuth into your Next.js 14 project using Supabase. If you've ever struggled with managing multiple passwords for different websites, you understand the importance of simplifying the sign-in process. 

![Setup Google and GitHub OAuth with Supabase in Next.js 14](https://codevoweb.com/wp-content/uploads/2024/02/Setup-Google-and-GitHub-OAuth-with-Supabase-in-Next.js-14.webp)

## Topics Covered

- How to Run the Next.js Application on Your Machine
- Demo of the Google and GitHub OAuth Flow
- Create a Project on Supabase
- Configure the Google and GitHub OAuth Providers on Supabase
  - Generate the OAuth Credentials on GitHub
  - Generate the OAuth Credentials on Google
- Create a Supabase Browser Client
- Implement Google and GitHub OAuth
- Create a Route to Exchange the OAuth Code for a Session
- Create Middleware to Refresh Expired Cookies
- Conclusion

Read the entire article here: [https://codevoweb.com/setup-google-github-oauth-with-supabase-in-nextjs-14/](https://codevoweb.com/setup-google-github-oauth-with-supabase-in-nextjs-14/)
