# 🚨 トラブルシューティング

## プロジェクトが読み込めない・起動できない場合

### A. 【最優先】OneDriveによるIIS Express エラー（2025年現在の主要原因）

**🎯 症状**
- ソリューション(.sln)を開くとプロジェクトが「アンロード済み」として灰色表示される
- プロジェクトを直接開くとエラー発生：
  - ファイル名: redirection.config
  - エラー: 構成ファイルを読み取れません

**🔍 原因**  
OneDriveがDocumentsフォルダーを管理している場合、IIS Expressの設定ファイルが「オンラインのみ」状態になり、ローカルで利用できなくなることがある。Windows Update後に発生しやすい問題です。

> ⚠️ **重要**: .NET 5以降でもVisual Studioのデバッグ実行時はIIS Expressが使用されるため、同様の問題が発生します。

**✅ 解決方法（推奨⭐）**
1. エクスプローラーを開く
2. 以下のパスを確認：
   - `C:\Users\[ユーザー名]\OneDrive\Documents\IISExpress`
   - `C:\Users\[ユーザー名]\Documents\IISExpress`
3. `C:\Users\[ユーザー名]\OneDrive\Documents\IISExpress`フォルダーを右クリック
4. 「このデバイス上に常に保持する」を選択
5. パソコンを再起動
