/*!
 * jQuery JavaScript Library v3.5.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2020-05-04T22:49Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
  };


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.5.1",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( _i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.5
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2020-03-14
 */
( function( window ) {
var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ( {} ).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	pushNative = arr.push,
	push = arr.push,
	slice = arr.slice,

	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[ i ] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
		"ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5]
		// or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +
		whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +
		"*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rhtml = /HTML$/i,
	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		return nonHex ?

			// Strip the backslash prefix from a non-hex escape sequence
			nonHex :

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" +
				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android<4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;

			// Can't trust NodeList.length
			while ( ( target[ j++ ] = els[ i++ ] ) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&

				// Support: IE 8 only
				// Exclude object elements
				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					if ( newContext !== context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = nid.replace( rcssescape, fcssescape );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split( "|" ),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[ i ] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( ( cur = cur.nextSibling ) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return ( name === "input" || name === "button" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
					inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	var namespace = elem.namespaceURI,
		docElem = ( elem.ownerDocument || elem ).documentElement;

	// Support: IE <=8
	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
	// https://bugs.jquery.com/ticket/4833
	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
	// Safari 4 - 5 only, Opera <=11.6 - 12.x only
	// IE/Edge & older browsers don't support the :scope pseudo-class.
	// Support: Safari 6.0 only
	// Safari 6.0 supports :scope but it's an alias of :root there.
	support.scope = assert( function( el ) {
		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );
		return typeof el.querySelectorAll !== "undefined" &&
			!el.querySelectorAll( ":scope fieldset div" ).length;
	} );

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert( function( el ) {
		el.className = "i";
		return !el.getAttribute( "className" );
	} );

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert( function( el ) {
		el.appendChild( document.createComment( "" ) );
		return !el.getElementsByTagName( "*" ).length;
	} );

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter[ "ID" ] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter[ "ID" ] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find[ "TAG" ] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,

				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( ( elem = results[ i++ ] ) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Firefox <=3.6 - 5 only
			// Old Firefox doesn't throw on a badly-escaped identifier.
			el.querySelectorAll( "\\\f" );
			rbuggyQSA.push( "[\\r\\n\\f]" );
		} );

		assert( function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll( "[name=d]" ).length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: Opera 10 - 11 only
			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll( "*,:x" );
			rbuggyQSA.push( ",.*:" );
		} );
	}

	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector ) ) ) ) {

		assert( function( el ) {

			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		} );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			) );
		} :
		function( a, b ) {
			if ( b ) {
				while ( ( b = b.parentNode ) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a == document || a.ownerDocument == preferredDoc &&
				contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b == document || b.ownerDocument == preferredDoc &&
				contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {

		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			return a == document ? -1 :
				b == document ? 1 :
				/* eslint-enable eqeqeq */
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( ( cur = cur.parentNode ) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( ( cur = cur.parentNode ) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[ i ] === bp[ i ] ) {
			i++;
		}

		return i ?

			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[ i ], bp[ i ] ) :

			// Otherwise nodes in our document sort first
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			ap[ i ] == preferredDoc ? -1 :
			bp[ i ] == preferredDoc ? 1 :
			/* eslint-enable eqeqeq */
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( support.matchesSelector && documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

				// As well, disconnected nodes are said to be in a document
				// fragment in IE 9
				elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			( val = elem.getAttributeNode( name ) ) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {

		// If no nodeType, this is expected to be an array
		while ( ( node = elem[ i++ ] ) ) {

			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {

		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {

			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}

	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||
				match[ 5 ] || "" ).replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					Sizzle.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				Sizzle.error( match[ 0 ] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace +
					")" + className + "(" + whitespace + "|$)" ) ) && classCache(
						className, function( elem ) {
							return pattern.test(
								typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
							);
				} );
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				/* eslint-disable max-len */

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
				/* eslint-enable max-len */

			};
		},

		"CHILD": function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || ( node[ expando ] = {} );

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								( outerCache[ node.uniqueID ] = {} );

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {

								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || ( node[ expando ] = {} );

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									( outerCache[ node.uniqueID ] = {} );

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												( outerCache[ node.uniqueID ] = {} );

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		"not": markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element (issue #299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		"has": markFunction( function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		} ),

		"contains": markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement &&
				( !document.hasFocus || document.hasFocus() ) &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return ( nodeName === "input" && !!elem.checked ) ||
				( nodeName === "option" && !!elem.selected );
		},

		"selected": function( elem ) {

			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {

			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos[ "empty" ]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		"last": createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		"even": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"odd": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ?
				argument + length :
				argument > length ?
					length :
					argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rcombinators.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrim, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] ||
							( outerCache[ elem.uniqueID ] = {} );

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = uniqueCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts(
				selector || "*",
				context.nodeType ? [ context ] : context,
				[]
			),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?

				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

					// If the preceding token was a descendant combinator, insert an implicit any-element `*`
					tokens
						.slice( 0, i - 1 )
						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		dirruns += contextBackup == null ? 1 : Math.randomi/ eslint-disable-next-line eqeqeq
	if	outerCastContext ) context ). document || b.ntext ). b.terCastCo;		}

		/// Add elements tosswog elements tchers ) rectly
	o results, 
	// Support: IE 1<9,afari w
	// SuTolete thde",Li parperties (jQIE"" ngth;
";afari w: <nuer t>)atching ofements by mo
				sr ( ; i < = oun && toelem = elem[  i ] ) {
 null;

++ ) {
		ifif ( b =lement && Exem ) {
			rej = 0,

					// Dopport: IE 11+, Edge 17 - 18+
				/// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		dirrruns += contextBackup == null ? 1 : Math.randomi// eslint-disable-next-line eqeqeq
	if	ouf ( !fintext ). elem.tynerDocument || document ) {
		se		setMacument( elem );
	}





l ) =documentIsHTML ?					}
				}
hile ( ( eltcher = Exements tchers )[++ ) ) ) {
							s ( matcher( elem, context, | document.hxml ) ) {
							retults.poph( elem );
				if	break;
													}
					po ( outermost ) {

							rruns +=dirruns &ique =					}
				}
		domi/ esTrk tomatched = ements fro seedtiltereds	ifif ( b =lt = {

					// GeTy dowi ? ve eige sorough pol ansitblinmatcherIns				if ( ( elem = maatchers[& Exem ) {
{

							tchedCount =--					}
						// Gength: ethe leray ofr elevy ghements matched[ r non-t				if ( ( ed ) {
			if	unmatched =oph( elem );
				if					}
			}

		/// Ge`i`s not whe leunter  elem.gts frvitio attve t,nd argdng to an re`tchedCount =`	/// Gekes see lentern.on-sgative i.
			tchedCount == coi
			// Avoly poedtilteredsn rematched = ements f		// AvNOTE""Ts isc be adip =d )  the n add neerematched = ements fif .e.,e`tchedCount =`	/// Geual tse`i`)uniqss we *kdidt bevitio _y-e_ ements fiithe lerve toop ascause at have a	/// Genelement (itchers );d arnoeed.le	/// GeIncrent (g and nitial ely-ring" 0",
e`i`s == nse`i`o resuinta sibing" 0ly caithe 
			// arse-iwhatichowi ? sult ==ta si"0,
e`tchedCount =`hat elff /s from un`i`ot no a nls			// :emeric xly cozero.		if ( ou=lt =  Ex< = outchedCount =={
			if	j 0;
			fohile ( ( eltcher = ExtMatchers.l[++ ) ) ) {
							tcher( elmatched, matMatched =context, xml );
				}
		
		if ( ( ed ) {
						// GeRetegerte thement (itcherssn reelimatorehe next for corting t				if ( ( tchedCount ==> ) ||			if	unile ( i-- ) {
							idx( !fi(nmatched[ i ] )  soFMatched =i ] ) ) {
							se	FMatched =i ] ) postpall( Exsults );
	}
											}
						}
						// GeDiscd &&dex oface( holr ) lues (e get maly caactu matcher
s				iftMatched = []ndense( matMatched = 
				}

				// Mod eltcherssn results, 
	//ush.apply( results, matMatched = 
					// Supt fss wese(itcherssnsucceing toltipleConsuccessfulitchers );spleulorehrting t				i ( outermost )  !stad && []tMatched =ength > 0,
&
						(( tchedCount ==+etMatchers.length > ) 1 ) {
							(zzle.uniqueSort =Exsults );
	}
						}

		/// GeOvy dent tcnleulorn de elglob tse moneed bytcherIns				 ( outermost ) {

					rruns +=dirruns &ique =					}terCastContext ) context )ckup =;		}

		///turn eluatched;
}
};
}
return el=lt = 				rkFunction( fuperMatcher = )
		suppoMatcher =}

fumpile(  Sizzle.tompile(  Sinction( selector, patch fa/*eInrn.t mae inly ?
*/ {
	var i =		sele tchers ) [],
				ements tchers ) [],
				ched = tompile( rche[ selector + " " ];

	if ( ca!ched ) {
		
// Get nete thaunction fo elcursivelyunction fthat elc be adud to comck agch encment
		fu ( !matcher {
			matcher tokenize( unlector ) ?		}
	}
 = matcherength;
				ile ( i-- ) {
					ched = totcherFromTokens( ( tcheri ] );
					 ( cached )expando ] ) {
				retMatchers.leph( elched ) {			} else {
				puementMatchers.leph( elched ) {			} e
}

		// Adche the tompile( dunction
			/ched = tompile( rche[ 					lector, p		matchers.omGroupMatchers( elementMatchers, setMatchers ) {
);
			// AdSe eilector ) d traenize(aon
			/ched =.lector = ""lector;
	gr	return conaed;
}


/**
 * UtAoopwevel colectorn forction toSt elrks beth elzzle.t'sompile( d* Utilector ) nction ft* @param {ArSing" |nction( }ilector ) Ailector )  ) drece-mpile( d* Utilector ) nction fot tereth elzzle.tompile( * @param {Arement &}ontext
		 @param {Array|E} [sults )]	 @param {Array|E} [ad &] Ailer  elem.gts fr matchergainst c*/
gelector Sizzle.selector Sinction( selector, pantext, xmsults, matM ) {
			r i =	okens, typens,type,
	inal
				mpile( du=ypeof ellector = " " "nction( "& []tMctor, p		mtcher totad && []kenize( ununlector ) tompile( =.lector =  soFMctor ) ?
)}
retults = []tults =  [];
		
/ esTr	o rematimazoperatorns in the n adisaly cae so)Mctor ) ithe leli ancearnoeed.l
/ es(e lentern.o elatichoguam extssnusantext, )
f ( ( tchedength > = 1 ) {

				 GeReduceontext, | the neading anmponeu selected ) i);d  I				kens = totcheri ] = match[ 0 ].slice( 0,  {			} ( typens.length,
 1 2& toelken wa=okens[ 0 ].t.toLe === " "ID&&
				entext.nodeType ? = 9 || difumentIsHTML ?
 Expr.filative[ tokens[ j 1.type ] ) {
					entext.n ( dipr.find[ "TAID&&]elken watches )0 ].t			pueplace( runescape, funescape ).tcontext, |)  [];
 )0 ];
		} f ( !fintext ).{
				return ( sults;
}
	/// GePcurpile( dutchers );wi ? spl ? vy ifyncestorryso thed p up drvel c		} else {
 ( cacpile( du{
				rectext ) context )arentNode;
				}
		///lector = ""lector;
lice( 0,kens.slift();
alue;
ength );
		}

		// FilehergaatM ) edtil retight-toeveftatching o}
 = matcherpr[ "CHxt fsntext )].test( malector ) ?
	 : capens.length,
				ile ( i-- ) {
					ken wa=okens[ 0 i;

			// WeAbt fo we hav anyombinator, 	} f ( !fpr.filative[ totype in=okens[ype ] ) ) {
				reeak;
					}	} f ( !f(inal
 Expr.filt[ "Tpe ] ) ) {
					// Suptch"),xpando g anmpext ) l reading ansling ) mbinators
			vaf ( !f(itM ) =inal
					i ken watches )0 ].teplace( runescape, funescape ).tc				i rsling )est( makens[ 0 ].type ],&& ( st( ntext( elntext )arentNode;
 ||
								ntext
				el) ) {

						e If thtM )  expty is non-okens )
suinta,e hac beturn elear
					rekens.slipce( i, j );
				re/lector = ""le =ength >  toSelector( tokens )
						i =( !filector ) {
			re//ush.apply( results, matM = 
				}
return ( sults;
}
			}
						//eak;
									}
		}
	}

	re Combile(  cearec( u thaunteredg ) nction fo=( e so not yeproventl
/ esProvente`tched`o avoid trturenize(aon
	o we hamodier.dhe selector parve t
	cacpile( du b.ntile( selector.rpatch fa) {(
seed[ 				mpext,
				ocumentIsHTML ?				sults,
				!ntext, | dorsling )est( malector ) {
 ( st( ntext( elntext )arentNode;
 ||
	ontext
			
			turn results;
}


// AdOne-mes  aign tnts f	/ Adrt =tartbility
pported.rtinStle fr=xpando ]lipce el ).rest =Exst =Orr ) {.joinel ).r== eleando ]
// Adpport: IEChmGre 14-35+/ Addays haaige trdupce(as (2 the nargu't yessed to coe tompil 1 : Munction
		pported.dettorDupce(as (2tot!hasDupce(as 
// AdItial eazopainst the elfault
	ifumentIs
tMacument( e)
// Adpport: IEWebkit<537.32 -afari wo6.0.3/ChmGre 25 (fix indeEChmGre 27)
 Defethed = des (tnteundatg ) followed *ch enherwi*
pported.rtinfethed = =aaige =Exnction( elem {

			/Shortd return bo1,ot noturn bs 4 (flowedg ))return elem.mpil 1ecument( sitional(ocument.haeateBuement &el er.ldtMa) ) && ;
		);

		 Support: IE<8
		 GePcuvt (itribute v/operty ma"termepolorn d"
 http:/s://msdwaticrosoft.mpi/en-us/libry d/ms536429%28VS.85%29.aspx
=( !fiaige =Exnction( elem {

	uem.innetML ?
" "<a ef |='#'></a>";return elem.rstChild; etAttribute( "tyef |).r== el"#"		);
 {

	uaddHdlin "type" |ef ||height|wid",
	unction( elem, come, opisL no{
		if ( ( !isL no{
		ifeturn elem.notAttribute( "tme, opne.toLowerCase() === "inpe" ) 1 : Ma2;
		}
	}

;
}

// Eapport: IE 1<9
 Use infault
	Vue is nface( e elgAttribute( ""lue;
")
=( !fipported.tributes (2 !seaige =Exnction( elem {

	uem.innetML ?
" "<put, />";reem.rstChild; esAttribute( "tylue;
",l ).r;return elem.rstChild; etAttribute( "tylue;
".r== el""		);
 {

	uaddHdlin "tylue;
",lnction( elem, _come, opisL no{
		if ( ( !isL no elem.nodeName.toLowerCase() === nonput" &&{
		ifeturn elem.nofault
	Vue i		}
	}

;
}

// Eapport: IE 1<9
 Use intAttribute( de;
  cofehergblean pshen sttAttribute !=ls
		=( !fiaige =Exnction( elem {

	uturn elem.tAttribute( "tysabled":  == null |		);
 {

	uaddHdlin "tblean ps	unction( elem, come, opisL no{
		ifr i lue;	if ( ( !isL no{
		ifeturn elem.n[ame ==]== true;
 1 ne.toLowerCase() ==					m( lue elem.getAttribute( de;
(ame );
 {
 ( lue.ecialer.dh					malue.lue mu					mall;
			r	}

;
}

//turn Sizzle( 
		
;
(indow.l;

		

uery g.nal
 Exzzle( 
	uery g.pres Sizzle.selectors
	
		 SuDrese(as d	uery g.pres"CH:] = Exuery g.presseudos;
Exuery g.iqueSort = Exuery g.uque = ( zzle.uniqueSort =Exuery g.xt ) cozzle.untText( Exuery g.isL ncum cozzle.unisL nExuery g.ntains": Sizzle.tompains":
	uery g.pape )lector ===izzle.topape )
		


r dir = conction( elem, cor,
	 unpl  {
			r i tched = se,
				ue;nte th= unpl  = oudefined" 
	while ( soelem = elem[ dir ] ) )  elem.nodeType ==! 9 ||{
		if ( ( em.nodeType === 1 ) {

		i =( !fue;nte th eluery gelem );
nis( unpl  {
{
				reeak;
					}	} ftched =oph( elem );
				}}
	return markted;
}


/*
r simping )s conction( elnelem ) > 			r i tched = se,

	for ( ; i ni n nulextSibling ) {
				 ( nododeType === 1 && ++n=! 9 em ) {
			retched =oph( eln;
		}
	}

	return elrkted;
}


/*
r sirxt fsntext ) Exuery g.presstchedext fsntext )
		

nction fodeName.telem, name );


		  turn elem.nodeName && elem.nodeName.toLowerCase() === node.toLowerCase();
		


/r sirog eleTag ( di/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;

		

 AdIlex nt (ie identificue nction fality l relter tocearnot
nction fondonowelementMas	ual tier.t,ot ye{
	if ( poisnction( fual tier.t {
{
				turn eluery g.gplaelementMas	unction( elem, coio{
		ifeturn el!!al tier.tall( Exem, coielem ) > ! 9 t y		} el
	}

	so Eapg elencment
		f ( poal tier.tadeType =={
				turn eluery g.gplaelementMas	unction( elem, o{
		ifeturn elelem = e 9 al tier.t {
! 9 t y		} el
	}

	so Earay|Elike  elem.gts frQuery gargument )s	uray|E)
f ( ( peof elal tier.t ! "string" &&{
				turn eluery g.gplaelementMas	unction( elem, o{
		ifeturn eleldexOf( all( Exal tier.t,oem ) > -1;
 {
! 9 t y		} el
	}

	so EaFtered serectly
	ol reth chmple ) cearmplex pslectors
	
	turn eluery g.lter( elal tier.t,oem )tMas	ut ye{}

//uery g.lter(  conction( eleres,lems, prt ye{
	ifr elem,  elem[  i 0;

	if ( cat ye{
	if	pres Si":t y(+ lapres + ")"	}

	so ( ( em.nsength > = 1 )  elem.nodeType === 1 );

				turn eluery g.nal
atches )lector( toem, copres ) [ coem,  : co;
			
	return eluery g.nal
atches )eleres,luery g.gplaelemens	unction( elem, o{
		ifturn elem.nodeNape === 1 );}

;
;
};

fuuery g.nn.prtend{
			nal
:inction( selector, o{
		ifr i ixmsu
				[n = tokhilength,
		le/lecf tokhil;		if ( sepeof ellector = ! "string" &&{
				eturn truhileph( Sthek(luery gellector, o{.lter( elnction() {
			re	r ( i in0; ) < len; i++ ) {
		if	i =( !fuery g.ntains":ellecfi ], reis is) {
							sturn true;
											}
			} el);
		}

		mat = ( uhileph( Sthek(l[] 
					r ( i in0; ) < len; i++ ) {
		if	uery g.nal
selector.rpalecfi ], ret = 
		}

		mat =n trn = 1 ?
	 uery g.iqueSort =(et = 
 cot;
		}},		naer( :inction( selector, o{
		ifturn truhileph( Sthek(lndonoweluhilselector,   [];
,alse ) {
)		}},		t y:inction( selector, o{
		ifturn truhileph( Sthek(lndonoweluhilselector,   [];
,aue ),

)		}},		is:inction( selector, o{
		ifturn tr!!ndonowe				khils			// In this is thpositional m/lative oplector, panck agmber tship ithe leturn t ) edt		// Inso $("p:rst": 
nis("p:st": ) w't beturn true;
ol reaocumith thewo "p
		//	peof ellector = " " "ring" && elrxt fsntext )est( malector ) ?
				}
uery gellector, o{u					mlector,   [];
,				lse )
);
ength,
			}	);

		/ AdItial eazopa uery g objtor		/ AdA ctMara? sufed e el coe toot":luery gecument.h)/r sirt":uery ga	so Earhmple ) wayo comck agl reML ?
ring" s
/ Prioritize by#id ov(  <tag>o avoid trXSS via cation.hash;
 (#9521)so Eapict-ceML ?
curpgnional (#11290:ust alart = th th<)		/Shortrtcuthmple ) #id se ler corpd.l
/rquickEres Si/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/a	soitia Exuery g.nn.itia Exnction( selector, pantext, xmso ye{
	if	r i tched,lem;
			// FiHANDLE: $(""), $(ll;
), $(defined" ), $(lse ))
i =( !filector ) {
			return truhil		}

		// FiMethodnitia {
accept);d  alrn.t teirt":uery g
// Inso mirte thc bepport fouery g.sub (gh-2101)so	so ye=mso ye dort":uery g			// FiHdlin eML ?
ring" s
/f ( sepeof ellector = = "string" &&{
				e ( ( edctor =0 ] === di"<&&
				eledctor =0 lector;
lngth - 1 ];
== di">&&
				eledctor =ength,
 1= 3 {
					// SuAige trat seting" srat setiaranceard agth th<>dd neML ?
d selp ==e letug psmck a			//tcher to[ull, tolector, pall ? 

			//else {
				putcher torquickEresxec( soFector ) ?		}


		/// Getcher htmls nokes  res on-ontext, | s ecialer.dhr co#
				s ( match )  toeltch[ 0 1 )  sointext ).{
{
					// SuHANDLE: $(html) -> $(aay|E)
f		s ( match )0 1 ) {
							ctext ) context )nstrucest eluery g ?ontext )0 ] ==context,

					// DoOpon toSeunes script); thee;
ol reck-prmpil t					e If ent nnal m
	ol the firor whbsorougw	o werseOnML ?
 not yeprented					euery g.mergeeluhilseuery g.rseOnML ?					i 	tch )0 1 )						i ntext ). elntext.nodeType ? [ ntext.nonerDocument || b.ntext ).:ocument.hx					i ee;
					i);

			//// SuHANDLE: $(html,arpers					inp( marog eleTagest( match )0 1 ) {
 eluery gnisPlns"Objtor( ntext ).{
{
						i r ( i tch ) in ntext ).{
							i / esProrties (j elntext ).e casel( duasgmbthod(2 thsitblinm					i / ( poisnction( fuuhil[ tch ) ) ) {
							se	uhil[ tch ) )(ontext )0 tch ) ) )
							// A ...d seherwise ust arbsttributes (						//else {
				pu	se	uhil.trib( tched,lntext )0 tch ) ) )
						//e
				//e
				/						//turn truhil					// SuHANDLE: $(#
						ielse {
				pu	em,  elcument.hagetement &ByIdmatch )0 2 ) )
							 ( ( em.n.{
							i  If ejtorhe element (irectly
	oto poe eluery g objtor				se	uhil[ ] = elem;
					ma	khilength,
 1;
			fo//e
				/turn truhil		}



		/// GeHANDLE: $(eres,l$(...))		//else {
 ( !fintext ). b.ntext ).jqry g {
				return ( ( ntext ). dort":o{.ltl
selector.r;

			// ReHANDLE: $(eres,lntext, )
f// Re(aticho nost paequivalt (ieo: $(ntext, ).ltl
seres)		//else {
				return ( khilensumuctio( tontext ).noltl
selector.r;

		}

		// FiHANDLE: $(DOMement &)
//else {
 ( !fedctor =edeType =={
					uhil[ ] = ellector;
	gra	khilength,
 1;
			foturn truhil					 FiHANDLE: $(nction( )			 Fiortrtcuthr ( cument ) ready
//else {
 ( !fisnction( fuFMctor ) ?
)
			return trrt":.ready = oudefined" 
				}
rt":.readyselector ) :

			/// Elec( u thmediately foif ready
 not yeprented					lector )!fuery g 
		}

		mat =n truery g.mes ray|Eselector, pais is)			}
		 SuGe ope inva froction toSteluery g ototype = l reaat inpuruceal on
		va frototype = Exuery g.nn
// AdItial eazopctMara? sufed e e
rt":uery g Exuery g(ocument ) {
/*
r sirrentNosevio Si/^(?:rentNos|evio(?:Unpl |A;
))/a	so EaMbthod(2guam extsdo prevoduceoaniqueCast aren striaing trom unaniqueCast a
	guam extsdique = ( 			rildren
	true, r
i ntextNostrue, r
i nt: 3;ue, r
i evio3;ue, 		}
		uery g.nn.prtend{
			sh;:inction( serget":e{
	if	r i rget":s Exuery g(orget":pais is)				[n ( uget":sength;

			iturn ( khilelter( elnction() {
			rer i = 0;
			for ( ; i < len
++ ) {
		ifif ( b uery g.ntains":eluhilseuget":si ] ) ) {
							turn true;
									}
		}
	
)		}},	
	osest a:inction( selector, s, ntext ).{
		rer i cu p		ma= 0,
		le[n ( uhilength,
		le/tched = se,
					rget":s Expeof ellector =s ! "string" && eluery gellector =s 
			// AdsitionalPsllector =s nevy  tched,lnce ele n a'not  _lectorn f_ontext
				 ( !ridxt fsntext )est( malector )is) {
					r ( ; i < len
++ ) {
		ififr ( ; cu  ( uhil0 i;

 cu   elnu= ! "sntext,

 cu  ( cu arentNode ) {
				//// Sudays halp ==cument ) fragnts
							 ( cacurodeType < 6 11& toelkget":s 						eluget":sedexOf; cu  > -1;
 :						i  Ifn't cossedon-seem.gts fr mazzle.t					i nurodeType < = 1 )  e						//uery g.nal
atches )lector( tocu palector )is) {
{
							i tched =oph( elcu  >					ma	eak;
					}
				}
				re
}

		//turn truhileph( Sthek(ltched =ongth > 1 ?
	 uery g.iqueSort =(etched = 
 cotched = 
		}},	
	 Defetmissnope insitionalj el element isth tithe let a
	dexOffunction( elem ) {

			/ AvNorgument ),eturn trdex ofiparset
		fu ( !maem, o{
		ifeturn eleluhil[ ] =  ( shil[ ] =arentNode ) {
? khileltrs);
aevioA;
(length > :1;
		}, 			/ AvIex ofipalector
		// ( sepeof elem = e 9 tring" &&{
				eturn trdexOf( all( Exuery gelem );
,luhil[ ] = 
		}

		// FiLocorehe nesitionalj ele elfasir = ements 
	eturn trdexOf( all( Exkhils			// In thi) recee ospa uery g objtor,he finat ?
ement isisdud t
pu	em, .jqry g ?lem[ di] ==coem[ 
);
			},	
	ad
:inction( selector, , ntext ).{
		return truhileph( Sthek(
	//uery g.iqueSort =(
		//uery g.mergeeluhilaget(),luery gellector =, ntext ).{
)		//)
);
			},	
	ad
ckup:inction( selector, o{
		ifturn truhilead
unlector ) tnull ? 1gra	khileevioObjtor caphileevioObjtorelter( ellector, o{
);
			}	);

		nction setling )tocu par ] {
		iile ( soelcu  ( cu dir ] ) )  elnurodeType < ! 1 );

		return conur}

//uery g.ch e{
			rentNofunction( elem ) {
			vr i rentNo elem.gerentNode;
				turn parset && Exrset &odeType < ! 1 )?
	 rset &&:ull;
			},		rentNosfunction( elem ) {
			vturn par ]toem, coarentNode",

)		}},		rentNosUnpl function( elem ), _i	 unpl  {
			vturn par ]toem, coarentNode",
	 unpl  {		}},		tt: 3;nction( elem ) {
			vturn patling )toem, coaxtSibling )

)		}},		rvio3;nction( elem ) {
			vturn patling )toem, coaevious ebling )

)		}},		xtSiA;
function( elem ) {
			vturn par ]toem, coaxtSibling )

)		}},		rvioA;
function( elem ) {
			vturn par ]toem, coaevious ebling )

)		}},		xtSiUnpl function( elem ), _i	 unpl  {
			vturn par ]toem, coaxtSibling )
	 unpl  {		}},		evioUnpl function( elem ), _i	 unpl  {
			vturn par ]toem, coarvious ebling )
	 unpl  {		}},		mping )s3;nction( elem ) {
			vturn patling )ssoelem =arentNode )  do );
.rstChild; ,oem ) >		}},		ildren
	trnction( elem ) {
			vturn patling )ssoem =arstChild;  >		}},		itextNostrnction( elem ) {
			v ( ( em.noitextNocument || doll ? 

				/ Dopport: IE 11+, 			/ Do<objtor>lem.gts frth tht  `ta o`ttribute vaha);d  objtor				 Ge`itextNocument |`rth tha `ll ?` ototype =		//	getPtoty( em.noitextNocument ||{
{
						turn elem.noitextNocument |		}

		// Fipport: IE 119 1 ]1aly c, iOS 7aly c, Andrd trBrows(  <=4.3nly
				 esTrearhe elmp ]le thement (i a deregul oldnis nfbrows( she 
			/ esn't bepport fo fr		v ( ( deName.telem, na"mp ]le t"s) {
					em,  elem[ oitextNo| elem;
				
		mat =n truery g.mergeel;
,aem[ oild; Nes (t
			}	)	unction( elme, opfn {
			uery g.nn[ame ==]==unction( elunpl ,elector, o{
		ifr i tched = seuery g.mepeluhilsefn	 unpl  {				v ( ( de.toice( 0,-5 {
! 9 "Unpl &&{
				elector = ""unpl 				
		ma ( !fedctor =  ( seof ellector = = "string" &&{
				etched = seuery g.lter( ellector, ,otched = 
		}	
		ma ( !fkhilength,
 1 ) {
						 GeReme todupce(as (
			 ( ca!guam extsdique =[ame ==]={
			if	jery g.iqueSort =(etched = 
		}


		/// GeRevy se orr ) r proentNos*
d servio-r )ivive o(
			 ( carrentNosevioest( mame );
 {
				putcher =orevy se({			} e
}

		//turn truhileph( Sthek(ltched =s)			}
	);

	r sirxothtmlilet= ( di/[^\x20\t\r\n\f]+/g;

		

 Adntevt anSing" -r pmterndptions in S maObjtor-r pmterndptnefunction seeateBuOpon tssotions in{
	ifr elobjtor ( 	}
		uery g.ch e{
tions iatches(irxothtmlilet= )  [];
,alction( _ma,alla) {
				objtor[alla) ]==uue;
			}.r;return elobjtor}

//  * UtCateBunyoml( ck toli anung thise flowedg ) ram {etmis:* U* U	tions i:;d  oponalPslli an ellce
	-seram rndptions inSt elrl ? cnginvahow* U	a	kheoml( ck toli anbeve as  ) drme matdio:onalPsltions  objtor	 U* U Bylfault
	iyoml( ck toli anrl ? aor like  elevt (iml( ck toli ancearm be a* U irst":  ltipleConmes t.	 U* U Pitblinmations i:* U* U	tnce:	a	rl ? sures  kheoml( ck toli anm bely cabfinatndptnc( slike  efendrtnd)* U* U	memery:	a	rl ? ep therk to elevious ellues (ea agth ? cl anceyoml( ck toad
 d* U			}
afr to  leli anha);beeninatndptight awayoth the lentet an"memered
	"* U			}
lues (e.like  efendrtnd)* U* U	iqueSo:	a	rl ? sures  yoml( ck tom bely cabfiad
 dptnc( st  dupce(as  ithe leli a)* U* U	stopOnFse ):	termerup(iml( g" sren styoml( ck toturn bs lse )
 U* U//uery g.Cl( ck ts conction( eltions in{
	ire Combevt antions inom unSing" -r pmterndp maObjtor-r pmterndp ( xt f.l
/ es( hacck agiconaed;inat ?{
)tions inExpeof eltions inE "string" &&1graeateBuOpon tssotions in{
				uery g.prtend{
	)	utions in{				r el EaFla)  keet wh ( li an iscurntNo
	oling
		diling
	
		// ThLt denatnllues  r prn-ser pgettle frli a(
		memery
		// ThFla)  keet wh ( li ans a dlready
natnd	dilin,

				 ThFla)  kepcuvt (iling
		dilock,

				 ThActu maml( ck toli a	dili anse,
					 Theryue  elec( u n dena onl retepteBle frli a(
		qryue se,
					 ThIex of elnurntNo
	oling
	aml( ck to(modier.dhbyiad
/reme toas xt f.l)	diling
	Iex of= -1
				 ThFireoml( ck ts	dilin, conction( e{
						 GeEnl rc( og ele-ling
		diilock,
 colock,
  b.tions iatnc(
			// Reec( u thml( ck tsol rea anseo g anec( u n d
				p Rereeciang troing
	Iex ofovy dent(ea agrunplme cnginv(
			natndp=oling
	a=rue;
					r ( ; i qryueength;

 ling
	Iex of= -1 {
				putemery = qryueeift();
				toile ( so++ling
	Iex of<rli aength > ) 						// GeRunoml( ck toaearmck agl reear
	 tmissnion
			ma		 ( cali a[ ling
	Iex ofapply( nutemerydi] =,utemerydi1 ) {
E "slse )  e						/tions iastopOnFse ).{
							i  IfJumpn ree argndhr cg the fina onso ead
sn'est betu-lint					i ling
	Iex of= li aength >					ma	temery = lse;
				}
					}
			}

		/// GeF cg the fina on we're june; oth thit
			 ( ca!tions iatemery {
				putemery = lse;
				}
		///ling
	a=rlse;

		//e Coman p up  we're june; oling
	al regoo				s ( malock,
 {
					// SuKp th elety isli an we have a na onl refutes  yddoml( 			vaf ( !ftemery {
				puili anse,
					// Suherwise, throisalbjtor  s ecied					else {
				pu	li anse;
	fo	}
				re
}


				 ThActu maCl( ck ts objtor			lecf to						 Ged elyoml( ck to ) drcloweion fo elml( ck tso poe elli a	di	ad
:inction( s{
		ifif ( b li an{

						e If th have a temery om unanpa run
	,e hasrtd relin, afr togdng t		ma		 ( catemery  !stling
	a{
						i ring
	Iex of= li aength > 1 ]					ma	qryueesh( matemery {				}
						}
	elnction() ad
unarg) {
						ouuery g.ch e{
arg),alction( _ma,aarg {
							se ( !fisnction( fuarg {
{
							se	 ( ca!tions iaiqueCas !selecfash;fuarg {
{
							se		li aesh( maarg {
						///e
				///else {
 ( !farg  !sargength >  toSepe <fuarg {
! "string" &&{
								/// ThIeecianlcursively
						//i	ad
maarg {
						//e
				//e {				}
		;
(igument )s )
							 ( ( temery  !stling
	a{
						i rine({			} }
				}
				return seuhil		}

},					 GeReme toyoml( ck toom top elli a	di	reme t:inction( s{
		ififuery g.ch e{
arguntMas	unction( ela,aarg {
							r i =ex o			} }
ile ( soeliex of= uery gninray|Esearg,lli a,liex of) > -1 ) {

			se		li aeipce( i, ex oj );
							i  IfHdlin eling
	a ex o (						/ ( !fiex of<= ling
	Iex of{
							seling
	Iex o--					}

					}
				}
	 {				}
turn seuhil		}

},					 GeCck agifoyogelynoml( ck tois ithe leli ae	/// GeIfht  arguntMaois gelyn,eturn tren er se non-teli anha);ml( ck tsoterhed =.	///sh;:inction( sefn {
				}
turn sefn 						euery gninray|Esefn	 li an{
-1;
 :		se		li aength > 0,
		}

},					 GeReme toyllhml( ck tsolm top elli a	di	ety i:inction( s{
		ifif ( b li an{

		se		li a [];
					i				return seuhil		}

},					 GeDabled" .lin, andhead
				 Gedbt foceyomurntNo/seo g anec( u n d
	//e Coman royllhml( ck tsoandhlues (	//esabled":inction( s{
		ififlock,
 coqryue se,
					ili a []temery = ;
	fo	}
turn seuhil		}

},	//esabled"
:inction( s{
		ififturn tr!li a		}

},					 GeDabled" .lin,				 Gedlso dabled" .yddoiqss we *kve a temery (nce elielrkd reve a neleffian)				 Gedbt foceyoseo g anec( u n d
	//elock:inction( s{
		ififlock,
 coqryue se,
					i ( !matemery  !stling
	a{
						ili a []temery = ;
	fo	}
				return seuhil		}

},	fiflock,
:inction( s{
		ififturn tr!!lock,
		}

},					 GeCl ancllhml( ck tsoth the legelynomtext ).e argrguntMas
			natnWh t:inction( sentext, xmarg) {
						 ( !malock,
 {
						iarg) =marg)  [];
						iarg) =m[entext, xmarg)oice(  ?marg)oice(  ==	marg) 
						iqryueesh( maarg) {;						 ( ( tling
	a{
						i rine({			} }
				}
				return seuhil		}

},					 GeCl ancllhkheoml( ck tsoth the legelynogrguntMas
			natn:inction( s{
		ififlecfanatnWh teluhilsegument )s )
			return seuhil		}

},					 GeTkeet wh ( kheoml( ck tsove a plready
beenisel( duateadi an e e
			natn
:inction( s{
		ififturn tr!!natn
			} e
}

}
return ellecf}


/*
nction() IntifitEsev {

	uturn elv}

/nction() Tougw( eleof{
			row a  o		
function maadtioVue i(hlues xmsulolv xmsujtor,hnoVue is> 			r i tbthod}
retry 
			/ AvCck agl repm te usaecianlnat ?
 kepcive ( somchronizs elbeve i
		// ( selues   Ex<snction( fu( tbthod =mlue;
epm te us) ) {
					tbthodall( Exlues  ).ne; (msulolv ;
.rai Exsujtor 
			// Adherwi khenled"s
		else {
 ( !flues   Ex<snction( fu( tbthod =mlue;
e: eth) ) {
					tbthodall( Exlues xmsulolv xmsujtor 
			// Adherwi n-sekhenled"s
		else {
						 Gentexrol `sulolv `egument )s b	ol tng trray|E#ice(  ci anblean p `noVue i`o avteger d:				 Ge*rlse;
:m[elues  slice( 0,  { =>msulolv Exlues  )				 Ge*rue;
:m[elues  slice( 0,1 { =>msulolv E)	di	relolv pply( nudefined" ,m[elues  slice( 0,noVue is> 
		}	
		m GeF csProte us/A+, ntevt anexceptns in S masujtorn d
	/ Eapg celuery g.en stn'est beunwrap khenled"s,e hac belp ==e let, rarmck asoappeang
	a e
	 Defendrtnd#: ethe-onteo:onalPs poeupprensasujtorn d.		}.cch ) Exlues  ) 
			/ Avpport: IEAndrd tr4.0nly
				 espict-ceme ) nction fthinvok,
 th tout all( /pply( et maglob t-lbjtor ntext
				sujtorpply( nudefined" ,m[elues  st
			}	)//uery g.crtend{
		
	fendrtnd:inction( sefctie{
	if	r i rupl (2to[				// Suaion( , yddoli a net,oml( ck ts,			// Su... e: ethndlins, searguntMaoiex oj [nal mastatet			pu"CHxotify"coarvogrens"seuery g.Cl( ck ts(n"memery),
					mauery g.Cl( ck ts(n"memery),
	 2 ),			pu"CHrelolv "coane; "seuery g.Cl( ck ts(n"tnc( memery),
					mauery g.Cl( ck ts(n"tnc( memery),
	, i Hrelolv d" ),			pu"CHrejtor"coarai "seuery g.Cl( ck ts(n"tnc( memery),
					mauery g.Cl( ck ts(n"tnc( memery),
	,1,CHrejtor d" )				),			pstate = ;seo g a"			pree te us=
		ififltate:inction( s{
		ififeturn elltas 
/	}

},	fif	ways h:inction( s{
		ififedendrtnd.ne; (mgument )s ).rai Exgument )s )
			re/turn truhil		}



,	fif	"cch )":inction( sefn {
				}
	turn pare te ue: etnull, tofn;
	}
				,				// SuKp thpip
ol reck-prmpil t					pip
:inction( se/*rlnDe; tofnFai tofnPvogrens
*/ {
	vaaaaar i fn) =margtextBac					//turn truery g.fendrtndExnction( elnewfendr {
						ouuery g.ch e{
rupl (	unction( ela=	okupl .{
							i / esp );rupl (2(rvogrens,une; ,ailin)o avoument )s (ne; ,ailin,arpegrens						.car i fn =m<snction( fuf[ 0 rupl [ 4 ] = )  elf[ 0 rupl [ 4 ] =
							// A dendrtnd.rpegrens(nction( s{
	 bd theolnewfendr  nonewfendr.xotify })						// A dendrtnd.ne; (nction( s{
	 bd theolnewfendr  nonewfendr.sulolv ;})						// A dendrtnd.rai Enction( s{
	 bd theolnewfendr  nonewfendr.sujtor })						//dendrtnd0 rupl [ 1 ) ]elnction() {
			re		.car i turn t ) = fn  elf[pply( nuuhilsegument )s )
			reeeee ( carurn t )  Ex<snction( fururn t )epm te us) ) 							se		rurn t )epm te u()						se			.rpegrens(onewfendr.xotify )						se			.ne; (mnewfendr.sulolv ;)						se			.rai Exnewfendr.sujtor {
						///else {
				pu	se		newfendr0 rupl [ ] ==+ "Wh t&&]e						se			khils						se			fn 	m[erurn t ) ]=	margunts
											{
						///e
				///el
						}
	l
						}
fn) =mll;
			re}
	l
epm te u()		}



,	fif	: et:inction( seonFulfil( d,eonRejtor d,eonPvogrens
{
	vaaaaar i maxDepth 0;
			fo}
fction masulolv Exdepth, dendrtnd,hndlins,,pecial up{
							sturn trnction() {
			re		.cr i rt el= khils						se	arg) =marguntMas							se	mightTougw conction( e{
											r i turn t ),he fn
							//	/ Avpport: IEProte us/A+lleion ma2.3.3.3.3						//	/ Avtp:/s://pm te usaplus.mpi/#pot-di59						//	/ AvIgno juneue-nesulolu n deternmp
											 ( cadepth < maxDepth {
											sturn t
						///						}
				sturn t ) = ndlins,pply( nuuha xmarg) {
							//	/ Avpport: IEProte us/A+lleion ma2.3.1						//	/ Avtp:/s://pm te usaplus.mpi/#pot-di48										 ( caturn t ) = docendrtnd.rpete u() {
											srow a new pe <Eor w(n"Thenled"llecfesulolu n d" {
						///						}
				s Avpport: IEProte us/A+lleion msa2.3.3.1,C3.5						//	/ Avtp:/s://pm te usaplus.mpi/#pot-di54						//	/ Avtp:/s://pm te usaplus.mpi/#pot-di75						//	/ AvReictev ;`e fn`aly cae ce						//	/: eth=arurn t )  E				}
				s/ Avpport: IEProte us/A+lleion ma2.3.4			}
				s/ Avtp:/s://pm te usaplus.mpi/#pot-di64			}
				s/ Avly ?
mck aglbjtorsoandhnction fthl rekhenleility
		}
				s/sepeof elturn t ) = do"lbjtor"|
									//	/:eof elturn t ) = do"nction( "&&&
						( 			sturn t ).e fn
							//	/ AvHdlin ealturn t ) khenled"										 ( caisnction( fuuheth) ) {				}
				s/ Avpcial uppm cess )is(xotify)ost pawaitil retulolu n d			}
				s/ ( !fecial up{
							s	//	/: etall( E						s	//	/sturn t ),						s	//	/stulolv ExmaxDepth, dendrtnd,hIntifitE,pecial up{,						s	//	/stulolv ExmaxDepth, dendrtnd,hTougw( ,pecial up{						s	//	/{
							//	// AvNorm uppm cess )is(tulolv ) nls	 hookn S marpegrens						//	//else {
									//	// Av...d sedisregd &&olr ) sulolu n delues (	//eeeeeeeeemaxDepth++
							//	///: etall( E						s	//	/sturn t ),						s	//	/stulolv ExmaxDepth, dendrtnd,hIntifitE,pecial up{,						s	//	/stulolv ExmaxDepth, dendrtnd,hTougw( ,pecial up{,						s	//	/stulolv ExmaxDepth, dendrtnd,hIntifitE,						s	//	/sedendrtnd.xotifyWh tp{						s	//	/{
						//	//e							//	/ AvHdlin ealleherwilturn t ) lues (	//eeeeeeeelse {
									//	/ Avly ?
subsfite vahalins, ossedoon ntext
								//	/ Avd seltipleConlues (e.n-seecialbeve i
	)			}
				s/ ( !fhalins,
! "sIntifitEp{
							s	//	/:  el= defined" 
						s	//	/arg) =m[erurn t ) ]
						//	//e							//	// esProcess=e lelues (s)						//	// esDault
	ipm cessois tulolv 
		}
				s/seecial up docendrtnd.tulolv Wh tp{nuuha xmarg) {
					//	//e				//	//e,							/// Thly ?
norm uppm cess )is(tulolv ) cch ) a agrujtor exceptns i						///pm cesso=eecial up?					//	//mightTougw :					//	//nction( e{
											etry 
						s	//	/mightTougw({
						//	//e.cch ) Exe ) {				}
				s/f ( b uery g.fendrtnd.exceptns Hookn{
							s	//	/	uery g.fendrtnd.exceptns HookExe,						s	//	/sepm cess.sthekTrk e {
					//	////e							//	/// Avpport: IEProte us/A+lleion ma2.3.3.3.4.1						//	/s/ Avtp:/s://pm te usaplus.mpi/#pot-di61						//	/s/ AvIgno jupostesulolu n deexceptns i						///			 ( cadepth + 1 >= maxDepth {
								s	//	/s Avly ?
subsfite vahalins, ossedoon ntext
								//	/	/ Avd seltipleConlues (e.n-seecialbeve i
	)			}
				s/s/ ( !fhalins,
! "sTougw( n{
							s	//	/	/:  el= defined" 
						s	//	/	/arg) =m[ee ]
						//	////e							//	///	cendrtnd.tujtorWh teluha xmarg) {
					//	////e				//	////e				//	///}
							// A pport: IEProte us/A+lleion ma2.3.3.3.1						// A tp:/s://pm te usaplus.mpi/#pot-di57						// A Rnesulolveare te ushmediately fot= coe solse ) sujtorn dolm t						// A subsequtMaoror wi						// ( cadepth {
							s	/pm cess({
						//else {
									// GeCl anc  oponalPslhookn masucordhe selthek,giconase  elecceptns 							// Gence elie'seherwise uslt ) en stec( u n degot(eamchr			reeeee ( cauery g.fendrtnd.getSthekHookn{
							s	//pm cess.sthekTrk e =auery g.fendrtnd.getSthekHook({
						///e
				///	ndow.lesAtTimeout(ipm cesso{
						//e
				//e				}
						}
	turn truery g.fendrtndExnction( elnewfendr {
		
				// Gerpegrens_halins, ead
un... )			}
		rupl ([ ] =[ 3fappddE						s	tulolv E
				///	0,						s	/newfendr,						s	/isnction( fuonPvogrens
{
?					//	//onPvogrens
:					//	//IntifitE,						s	/newfendr.xotifyWh t						s	)			}
		
							i  Iffulfil( d_halins, ead
un... )			}
		rupl ([ 1 =[ 3fappddE						s	tulolv E
				///	0,						s	/newfendr,						s	/isnction( fuonFulfil( d
{
?					//	//onFulfil( d
:					//	//IntifitE						s	)			}
		
							i  Ifrejtor d_halins, ead
un... )			}
		rupl ([ 2 =[ 3fappddE						s	tulolv E
				///	0,						s	/newfendr,						s	/isnction( fuonRejtor d
{
?					//	//onRejtor d
:					//	//Tougw( 						s	)			}
		
			}
			l
epm te u()		}



,	
		i  IfG arbepm te usl rekhis cendrtnd
		i  IfIfglbjois proventl,he fipm te usaecianl thpd
 dp poe elobjtor				spm te u:inction( seobjo{
				}
	turn paobjo doll ? 	 uery g.crtend{
obj,ipm te us==	mpm te u	fo	}
				re,	//esendrtnd ( 	}
	
		 Ged elli a-ecialercgmbthod(
ouuery g.ch e{
rupl (	unction( el=	okupl .{
					r i li a []rupl [ 2 ),			pultas Sing"  []rupl [ 5;

			// Were te uerpegrensf= li aead
				 Gere te uene; o= li aead
				 Gere te uerai o= li aead
				re te u0 rupl [ 1 ) ]o= li aead

			// ReHdlin eltas 		// ( !fetas Sing"  {
		ififli aead
E
				/nction( e{
							// Restate = ;relolv d" f .e.,efulfil( d)					// Restate = ;rejtor d"					//state = etas Sing" 			}
			,							 Ifrejtor d_ml( ck ts.dabled"						 Iffulfil( d_ml( ck ts.dabled"						rupl ([ 3 - i;
[ 2 ).dabled",							 Ifrejtor d_halins, edabled"						 Iffulfil( d_halins, edabled"						rupl ([ 3 - i;
[ 3 ).dabled",							 Ifrpegrens_ml( ck ts.lock						rupl ([ 0;
[ 2 ).lock,							 Ifrpegrens_halins, elock						rupl ([ 0;
[ 3 ).lock
}
		
			}
}			// Were grens_halins, elin,				 Gefulfil( d_halins, elin,				 Gerejtor d_halins, elin,				li aead
E rupl [ 3 ).lin, 

			// Redendrtnd.xotify conction( e{
	edendrtnd.xotifyWh te...) }		// Redendrtnd.sulolveaconction( e{
	edendrtnd.tulolv Wh te...) }		// Redendrtnd.sujtor ( nction( e{
	edendrtnd.tujtorWh te...) }		//dendrtnd0 rupl [ 0 ) ]o= nction( e{
						dendrtnd0 rupl [ 0 ) + "Wh t&&]eekhis = docendrtnd 	 defined" 
:luhilsegument )s )
			return seuhil		}

}
			// Redendrtnd.xotifyWh tp= li aenatnWh t		// Redendrtnd.sulolveWh tp= li aenatnWh t		// Redendrtnd.sujtorWh tp= li aenatnWh t		//dendrtnd0 rupl [ 0 ) + "Wh t&&]p= li aenatnWh t		}	
 
			// AdMes  e elfaudrtnd bepm te u
		re te uepm te u(lfaudrtnd 
			// AdCl angelynofctieifoynE			 ( !ffctie{
	if	/nctiall( Exdendrtnd,hfaudrtnd 
		}

		// FiA anne; !
	vturn paraudrtnd;	}},	
	 Defeudrtnd help( 		w et:inction( seog eleVue is> 				r i			// Recnt == elctiplex r d
subordatorei				suintag"  []gument )sength,
				// Recnt == elctpm cesseargrguntMas
			ih=aruintag" 				// Resubordatoreefulfil(nt (irata				sulolventext )sf= ray|Eseip{,				sulolveVues (e= ece( all( Exgument )s )				// Ree elmasr toDendrtnd
		imasr to=auery g.fendrtnd()				// Resubordatoreeml( ck tooaor, E				upratencti conction( elio{
		ifesturn trnction() xlues  ) 
			}
	tulolventext )si ] ) pouhil		}


	sulolveVues (i ] ) pogument )sength,
 1 ?
	 ece( all( Exgument )s )
:lvue i		}
	// ( !f!( --suintag"  ) {
								masr t.tulolv Wh te tulolventext )sxmsulolv Vues (e{			} }
				}
			}

}
			//Eapg ele-nceardty isgument )s as  ydopoed like Prote u.tulolv 
		 ( catuintag"  <1 ) {

		i adtioVue i(hog eleVue i,lmasr t.ne; (mupratenctielio{
).tulolv ,lmasr t.sujtor,			}
!suintag"  )
			// Ree ine: etn)o avunwrap leiondar	o henled"s (cf. gh-3000)		// ( !fmasr t.etas  === nonseo g a"|
						<snction( furulolveVues (i ] )  elrulolveVues (i ] ).uheth) ) {				}
turn elrksr t.: etn)			} e
}

		// AdMtipleCongument )s as  yggregdoed like Prote u.l ancay|Elem.gts f
		ile ( i-- ) {
					adtioVue i(hrulolveVues (i ] ),mupratenctielio{,lmasr t.sujtor 
		}

		mat =n trmasr t.pm te u()		}}	);

		/ AdThesaduduPs podowe(as  aere grammy  ti aes  dung"  del copnt.hx	 Adwa trabout : em ASAP raerwi kh belwaowedg ) : em bylfault
	.	r sirror wme.ts Si/^(Evue|Inrn.t m|Rginv|Rufed e e|Syntax|pe <|URI)Eor w$/
		uery g.fendrtnd.exceptns Hooknconction( eleor w,elthekn{
	ire Copport: IE 118 - 9nly
			 Gentelollet,i a( en stdelo aols as  opyn,eatichoc behappedeteoceyoplme
/ ( !fndow.lectelolle elndow.lecteloll.wa tr eleor wh elruor wme.tsest( mauor w.me );
 {
				ndow.lecteloll.wa t( "uery g.fendrtndlecceptns : + lapor w..tssag ,lpor w.lthek,glthekn{		}}	)
		


uery g.readyEcceptns nconction( eleor w {
		iidow.lesAtTimeout(inction( e{
				row a  or w;}

;
}


		


 AdThehfaudrtnd ud toon DOM ready
r sirradyLi a []uery g.fendrtnd()
		uery g.nn.ready
=inction( sefn {
			utuadyLi a			e: etnufn {		// AdWrap uery g.readyEcceptns nistyonction seto rt elp ellookup	// Adhappedsotehe elmlme  eleor w haling
	a esr ado elml( ck t
		 Geregi atorns .	//.cches(inction( eleor w {
		iouuery g.readyEcceptns eleor w {		}	
 
			/turn seuhil		}
		uery g.crtend{
		
	 IfIs=e leDOM readyo avbe ud t? Se?
 keee;
ooe elielocrsiv.	/isReady:olse )a	so Earhcnt =wi koherk toh a mceyoitemso powaitil rebel re
/ Ree elreadyouvt (ilintse See #6781	utuadyWait: 1a	so EaHdlin een ste leDOM is tuady
/ready:olction( elwaiti) 
			/ AvAbt fo wee n adas  seo g anholds  ) 're juplready
ready
// ( !fnaiti= true;
 1 --uery g.readyWait
:luery gnisReady {
		iouturn t
			
		// AdRember t rt elp elDOM is tuady
/	uery gnisReady =rue;
		
i  IfIfga
norm upDOM Readyouvt (ilintd,hfacrent ),ea agtait
 ( xt fe a*// ( !fnaiti! true;
  el--uery g.readyWait
>,  { 		iouturn t
			
		// AdIwee n adas  nction fthbndat,n reec( u t	mat adyLi a.tulolv Wh te cument.hx [ uery g st
			}	) )
		uery g.t ady.: eth=aruadyLi a.e fn
		 AdThehreadyouvt (ihalins,
a selecelman pupgmbthodunction seeplex r de{
			cument.hareme tEvt (Li a net( "DOMCtextNoLoaded",eeplex r dt
			idow.lereme tEvt (Li a net( "load",eeplex r dt
			uery g.t ady(
}

// EaCch ) nase( en s  $ecument.h).t ady(
n iscel( d/ Eaafr to  lebrows( ouvt (ihaa dlready
ocrsitnd./ Eapport: IE 1 <19 1 ]0nly
		 Avllr )  1 sombtes t gn tse a"termeaionve"o ao so
		v( cadument.hareadyState = noneplex r "|
			cadument.hareadyState ! "stloadg" && elocumentIs.cumentIsement &.cuScrollh) ) {			 EaHdlin e anymchronizs e fot= aowed script);e eloort: unitEpt= celay
ready
/idow.lesAtTimeout(iuery g.t ady )
		else {
				 Ree ine elhaliylevt (iml( ck t		cument.haaddEvt (Li a net( "DOMCtextNoLoaded",eeplex r dt
		so Earhfl( ck to powdow.lely
oad,nSt elrl ? ways h work
/idow.leaddEvt (Li a net( "load",eeplex r dt
		}		


 AdMtiplnction fal tbthod  pot maa seletnlues (e el rcloweion f	 AdThehlues /som belponalPs pobeeec( u tdp ( ie'seyonction s
r siaccess conction( elemens	unn,ekey,xlues xmchntaled",rdty iG":paraws> 			r i = 0,
		len = toem.nsength >		lebulkncokey= null |		re Cop":s mceyolues (	/ ( !fkepe <fukey=) = do"lbjtor"|{ 		iochntaled"a=rue;
				r ( i inistkey=) 					accesselemens	unn,ei,ekeyi ], reie, rrdty iG":paraws>		}	
		m Gep":s e; olues 
	else {
 ( !flues  = oudefined" 
{ 		iochntaled"a=rue;
		*// ( !f!<snction( fulues  ) { 		ioutawa=rue;
				
		ma ( !fbulkn{
						 GeBulknortiaon fthnes ainst the eltifire edt		// ( cataws> 			f	/nnall( Exem, s,ulues  );		f	/nn null |		re// Av...eccept en stec( u n
	alction selues (	//eelse {
				pubulkncofn;		f	/nn nunction( elem ), _key,xlues o{
				}
	turn pabulkall( Exuery gelem );
,llues  );		f	/}			} e
}

		// ( !ffn {
				}r ( ; i < len; i++ ) {
		if	ifnE
				/em[  i ], rekey,xtaws					malue mu					malue;
ell( Exem, si ], rei	unnExem, si ], rekey=) )
}
		
			}
}		
	}

	re ( cachntaled"a{
			vturn paem, s;}

	so EaG":(	/ ( !fbulkn{
		}
turn sefnell( Exem, sl
	}

	sot =n trn = ?unnExem, si 0, rekey=) :rdty iG":}


		
/Getcher (edasd =sring" il rece )lizg t	r sirmsPrinex Si/^-ms-/		lrdasdAlpha Si/-([a-z])/g
		 AdUs.dhbyice )lse() a);ml( ck tn masuace( ()unction sefce )lse()( _a, tol tn( n{
			t =n trn tr t.:oUppease();
		}

 Adntevt andasd =se-one )lse(); ud toby kheomssoandhna onmodud"s
 Eapport: IE 1 <19 1 ]1, Ee so12 1 ]5
/Geticrosofthr cgo?
 kehumpn heir vt d repminex (#9572)unction sece )lse()( sing"  {
		iturn elltng" .suace( (irmsPrinex, "ms-"
).tuace( (irdasdAlpha,efce )lse()t
		}	r siacceptDa onconction( elterDo ) {			 EaAccept);ly
	:		 Ea 1 Nes 		 Ea a 1 Nes .ELEMENT_NODE		 Ea a 1 Nes .DOCUMENT_NODE		 Ea -aObjtor		 Ea a 1 Anyreturn eloerDoodeType < = 1 )  b.terDoodeType < = 1 9s !se( +terDoodeType < 
}


		


nction seDa o({
			rois.preando Exuery g.preando +eDa o.uid++
	}

Da o.uid 1;
		
Da o.ototype = Ex{			naed;:onction( elterDo ) {			/ AvCck ag ( kheoterDo lbjtor dlready
haa donaed;
ifr i lueue seterDo[ rois.preando ]		
i  IfIfgno:paeateBu e; *// ( !f!lues o{
				}lueue se{}
			// ReWhac beaccept na onl ren-seem.gts  deNas ithme )rnfbrows( s				p Rebute hasrtd reno:pasee #8335e	/// Gedays haturn el elety islbjtor.		// ( caacceptDa oelterDo ) {
					// Su thi)  thpodeNaoiqsiky fot= belltng" ify- toorllooped ov( 			// Suud  plns" a)gn tmied					 ( caterDoodeType < 

				}
	terDo[ rois.preando ] =mlue;
					// Suherwise,  leies  i)  nhpodeseenentrled"aprortiey			// Suconfigurled"ast albsore;
 t= aowed e fipm rtieyot= be			// Sucel r dten stda on hatume td
		i else {
				pu	Objtorefined"PrortieycaterDo, rois.preando,
								lue;
:lvue i						i ntefigurled"3;ue, 				i el);		f	/}		} e
}

		//turn elvue i		}},		met:onction( elterDo,tda o,xlues o{
				r i rror					naed;i( uhilenaed;elterDo )			// FiHdlin :m[eterDo,tkey,xlues o]marg)
// Gedays haud  ce )lse()tkey=(gh-2257)
i =( !f:eof elda on= "string" &&{
				enaed;[ece )lse()( da on) ] =mlue;
					 FiHdlin :m[eterDo,t{ipm rties (j}o]marg)
//else {
						 Gentpy e fipm rties (j ne-by-e; o poe elnaed;iobjtor				r ( ; pm r  nhda on) 						naed;[ece )lse()( pm r ) ] =mda o[ pm r ]			}
}		
	}
eturn conaed;		}},		get:onction( elterDo,tkey=) 				turn cokey= noudefined" 
				}uhilenaed;elterDo ) :					 Gedays haud  ce )lse()tkey=(gh-2257)
i 	terDo[ rois.preando ]  elterDo[ rois.preando ][ece )lse()( key=) ]		}},		access:onction( elterDo,tkey,xlues  ) 
			/ AvIn nase( en s  eierwi:		/ A		/ Av  1.vNorkey=s a ecialer.d		/ Av  2.arhming"  key=s a ecialer.d,ebutenoxlues  proventl		/ A		/ AvTes  e el"read" pat) a agaowed e fit matbthod  podetmissno		/ Avaticholues   masurn c,ereeciangly
	 eierwi:		/ A		/ Av  1.vT eltifire naed;iobjtor			 Av  2.aT fina onstor duatee fikey		/ A		/=( !fkey= noudefined" 

						( !fkey= ( seof elkey= noutring" &&{
 ( lueue s oudefined" 
{ {
					/turn truhileget(lterDo,tkey=)
			
		// AdWn ste lekey= not yeahming" ,  reth chaekey=andhlues 	// Adas  ecialer.d,eletn reertend (t,i ag"  lbjtors)oth theierwi:		/ A		/ Av  1.vA  objtoro elev rties (		/ Av  2.arhkey=andhlues 	// A
	}uhileset(lterDo,tkey,llues  );	
	//Eapg c  e el"set" pat) c beha opewohsitblinmltif g oot-ds
		 Gerern truheeecptor d
na onbad toon atichopat) s a aes n[*]	//turn elvue i = oudefined" 
	lvue i :tkey		}},		reme t:inction( slterDo,tkey=) 				r i ix				naed;i( terDo[ rois.preando ]		
i  ( cacaed;i( oudefined" 
{ 		iouturn t
			
		//=( !fkey== oudefined" 
{ 						 Gepport: ncay|El corpk e seram rndpming"   elkey(
			 ( caray|E.isray|Esekey=) )
					// Su thkey= no beaay|El elkey(...			// SuWe ways h letnce )lse()tkeylseloatume tnSt e.			//key= tkey.mepelce )lse()t
			i else {
				pukey= tce )lse()( key=);				// Su thaekey=th the lerpk eset,i a(,aud  it.			// Suherwise, theateBu  beaay|Elby tchesg"  deseilet=rpk e			//key= tkeygiconaed;i					ma[tkeyg]u					ma(tkey.mehes(irxothtmlilet= )  [];
 
		}


		///i= tkey.ngth;

			i	ile ( i-- ) {
						cel r  naed;[ekeyi ],  ]			}
}		
	}
// AdRemo ope inpreando  wee n a'not  me marata			=( !fkey= noudefined" 

	luery gnisEty iObjtor( naed;i)
{ 						 Gepport: :vCcrome <135 1 45		// ReWhbki) & Blink rtir pmt c  suffs, oen stdel rg ) rv rties (		/	 Gefm toDOM deNasseloase?
 kedefined" 
 esr ad		/	 Getp:/s://buglencromium. cg/p/ncromium/issues/detail?id=378607 (bugereeict-c d)				 ( caterDoodeType < 

				}
terDo[ rois.preando ] =mdefined" 
				else {
				pucel r  terDo[ rois.preando ]			}
}		
	}

,		sh;Da o:onction( elterDo ) {	rer i caed;i( terDo[ rois.preando ]		
eturn conaed;== oudefined" 
 elouery gnisEty iObjtor( naed;i)		}}	)
	r i rataPrio Sinew Da o({;
	r i rataUs to=anew Da o({;
	

 A	Ilex miedaon feppmmar		 A
 A	1.vEnl rc( API resfk e a selemcealc mpil tieility=th th1.9.xfbrt ch
 A	2.aIlero ope inmodud"'s mciains"leilitylby r ducg thise storage
 A		pat)so poahog eleatbcngiism./ E	3.ee ine else );og eleatbcngiismo popport fo"p)ivive" a se"ud r" rata./ E	4. _Nevy _npreo in"p)ivive" na on keds toceNao(TODO: Dm r _da o,x_tume tDa o)/ E	5.arid trpreo g
	a lex miedaon fedetaildoon ds tolbjtorso(eg.npreando rv rties ()/ E	6. Provent donan ropat) r (  lex miedaon feupgrad   maWeakp );ico2014*
r sirbrk e =a/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/a		rltiplDh;
 =a/[A-Z]/g
		nction segetDa oelda on) 			v( cada on= "stue, "=) 				turn coue;
			}
		v( cada on= "stlse )"=) 				turn colse;
			}
		v( cada on= "stll |"=) 				turn coll;
			}			 Ealy ?
mtevt an poahnenr t  ( ietn'est becnginvaise stng
		dv( cada on= "s+da on+ ""=) 				turn co+da o			}
		v( carbrk eest( mada on) ) 				turn coJSON.rseOnmada on)	}

	sot =n trda o		
function mada oArib( em ), key,lda on) 			r sime )		re CoIfgno:sg"  s a fndatvtegerlPs preieyot= feh ) a 			 Gena onlm top elML ?5ena o-*ttribute v	dv( cada on= "sdefined" 
 elem[ odeType < = 1 ) ) 				me );"stna o-+ lakey.suace( (irmtiplDh;
, "-$&"
).toLgw( se();
		puca oncoem[ ogetAribute vmame );
		
i  ( ca:eof elda on= "string" &&{
				etry 
					ca oncogetDa oelda on)
				elcch ) Exe ) {
		/// Getcs  res owast are fina onso i)  tt becnginvdeaat i
			ca oUs teset(lem ), key,lda on);
		else {
				pca oncodefined" 
				}

	ot =n trda o		
fuuery g.crtend{
			sh;Da o:onction( elem ) {
			vturn para oUs tesh;Da oelem ) {
 docataPrioesh;Da oelem ) {;	}},	
	da o:onction( elem ),lme, opda on) 				turn para oUs teaccesselemen,lme, opda on);	}},	
	tume tDa o:onction( elem ),lme, n) 				ra oUs tetume telem ),lme, n);	}},	
	 DeTODO: Ned e teocllhml( so po_da o a se_tume tDa oeha opbeenisuace( l
/ esth threctlyhml( so porataPrio mbthod(,he fserm be aadepctl rnd.		_da o:onction( elem ),lme, opda on) 				turn para oPrioeaccesselemen,lme, opda on);	}},	
	_tume tDa o:onction( elem ),lme, n) 				ra oPrioetume telem ),lme, n);	}}	) )
		uery g.nn.prtend{
			da o:onction( elkey,xlues o{
				r i ixlme, opda ox				em,  eluhil[ ] =x				tribsncoem[ 
 elem[ otributes (;	
	//EaG":(ocllhlues (	//=( !fkey= noudefined" 
{
				e ( !fkhilength,
 ) 
					ca oncora oUs teget(lem )=);				// ( ( em.nodeType < = 1 )  e !ra oPrioeget(lem ), "sh;Da oAribs"s) {
					//i= ttribsength >					maile ( i-- ) {
							i /Dopport: IE 11+,nly
						i /DoT fitribsnem.gts frm be aall ? (#14894)					// ( caaribsi ] ) ) 									me );"saribsi ] ).me )							// ( cade.todexOf( (stna o-+ ) = do0 ) 										me );"sce )lse()( de.toice( 0,5 {
{
						///da oArib( em ), me, opda o[ame ==]={
						//e
				//e
			//e
			//ra oPrioeset(lem ), "sh;Da oAribs"reie, l);		f	/}		} e
			/turn trda o			

		// Fip":s mtipleConlues (
i  ( ca:eof elkey= noutlbjtor"|{ 		io/turn truhilech e{
nction( e{
						da oUs teset(luhilsekey=)
			 el);		f
		//turn elaccesseluhilsefction() xlues  ) 
			}r i rata
			// ReTheoml( g"  uery g objtoro(em.gts  tches ))= not yeety i		// Re(a see n al reaha);d  ement (i ppeansotehe il[ ] =) a see n		// Re`vue i`oram {etmi s a t yedefined" .vA  ety isuery g objtor		// Rerl ? reet
	iico`defined" `gl reem,  eluhil[ ] = atichorl ?		// Rerow a adeexceptns eifoyneternmp
  masuad beca onnaed;iis mcde.		// ( caem[ 
 ellueue s oudefined" 
{ 					// SuAernmp
  mat mana onlm top elnaed;
if// ReTheokey=th ? ways h b  ce )lse()tvte Da o					ca oncora oUs teget(lem )sekey=)
			 dv( cada on= oudefined" 
{ 		io		/turn trda o			

						}
 SuAernmp
  ma"discov( "he fina on n			}
 SuML ?5ecustomena o-*ttribs					ca oncora oArib( em ), key=)
			 dv( cada on= oudefined" 
{ 		io		/turn trda o			

						}
 SuWsorer.dhsuas pohard,ebutee fina onn'est bet,i a.			//turn t
				
		/// GeS are fina o...			/uhilech e{
nction( e{
					// SuWe ways h ltos  kheoml )lse()tvkey		/		da oUs teset(luhilsekey,llues  );		f	el);		f
,ull, tolues xmgument )sength,
 1 ?,ull, toie, l);		},	
	tume tDa o:onction( elkey=) 				turn couhilech e{
nction( e{
					ra oUs tetume teluhilsekey=)
			}n);	}}	) )
		uuery g.crtend{
			qryue:onction( elem ),l:eofopda on) 				r i qryue		
i  ( caem, o{
		ifepe = Exca:eof
 do"fx"|{ + "qryue";		f	qryue sera oPrioeget(lem ), te < 
}
	/// GeSpt feupadeqryue b et mag"  lutequick podfekhis is st paallookup	//dv( cada on{ 		io		 ( !f!qryue  doray|E.isray|Eseda on) ) 					f	qryue sera oPrioeaccesselemen,l:eofopuery g.mekeray|Eseda on) )			

		lse {
				pu	qryueesh( mada on)
				/}		} e
}
	turn coqryue  do;
				}	}},	
	deqryue:onction( elem ),l:eof ) 				pe = Ex:eof
 do"fx"}
	//r i qryue Exuery g.qryueelem ),l:eof ),			pstartLgth,
 = qryueength;
,			pnn nuqryueeift();
,			phooks Exuery g._qryueHookselem ),l:eof ),			pxtSio= nction( e{
						uery g.deqryue(lem ), te < 
}
	

}
			//EaIwee n fx qryue is ceqryued,eaays hatumo ope inrpegrensfstifinel
// ( !ffn  noutinrvogrens" {
				}rn nuqryueeift();
;			pstartLgth,
--				
		// ( !ffn {
			/// Ged elyorpegrensfstifinel  kepcuvt (ie n fx qryue lm tobeg t		ma Adautomaticas poceqryued			e ( !fke < = 1 "fx"|{ 						qryueeunift();utinrvogrens" {
				
		/// Geman rouphe lentst qryue stoponction s
	pucel r  hooksastop;			}rnell( Exem, ,ult, xmhooks 
		}	
		ma ( !f!startLgth,
  elhooks 
 					hooksaety i.rine({			}}	}},	
	 DeN yepubce( -et ntiaot doqryueHooks objtor,  rerern truheemurntNo e; */_qryueHooks:onction( elem ),l:eof ) 				r i key= t:eof + "qryueHooks"		
eturn cora oPrioeget(lem ), key=)  docataPrioeaccesselemen,lkey,l					ety i:iuery g.Cl( ck ts(n"tnc( memery),
ead
E nction( e{
						da oPrioetume telem ),l[t:eof + "qryue",tkeyg]u);		f	el)			}n);	}}	) )
		uery g.nn.prtend{
			qryue:onction( el:eofopda on) 				r i s tn( n= 2		
i  ( ca:eof elte < ! 1 tring" &&{
				eca oncote <;	ifepe = Ex"fx"}
		ps tn( --				
		// ( !fgument )sength,
 < s tn( n{ 		io/turn truery g.qryueeluhil[ ] =x te < 
}
	

		//turn elda on= "sdefined" 
				}uhilu					uhilech e{
nction( e{
						r i qryue Exuery g.qryueeluhilse:eofopda on);				// SuEures  yohooks l rekhis qryue					uery g._qryueHookseluhilse:eof=);				// ( ( ke < = 1 "fx"| elqryue[ ] = !noutinrvogrens" {
				}		uery g.deqryue(luhilse:eof=);				/}		} e >		}},		deqryue:onction( el:eof ) 				turn couhilech e{
nction( e{
					uery g.deqryue(luhilse:eof=);			e >		}},		nan rQryue:onction( el:eof ) 				turn couhileqryue(lueof
 do"fx",];
 
		}},	
	 DeG arbepm te usrelolv doen stqryue(e el rcerins"lueof
/ Adas  ety r.dh(fx i);e elueof
bylfault
	)		pm te u:inction( se:eofopobjo{
				r i rmr					nnt === 1a		//dendro=auery g.fendrtnd()					em, ts fr= khils				ii( uhilength;
,			psulolveaconction( e{
		io		 ( !f!( --nnt ==) ) 					f	dendr.sulolv Wh te em, ts f,l[tem, ts fr]=);				/}		} e		
i  ( ca:eof elte < ! 1 tring" &&{
				eobjocote <;	ifepe = Exdefined" 
				}
	pe = Ex:eof
 do"fx"}
	//ile ( i-- ) {
					rmr sera oPrioeget(lem )ts fi ], reieof + "qryueHooks"=);				 ( ca:mr  ( smpaety in) 						nnt =++
					rmraety i.ad
E sulolv ;)			}
}		
	}
	tulolv E)		
eturn corendr.pm te u(lobjo{;	}}	) )
	r i rnum ( di/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/,
esourc(
		r sircssNum ( new RegExp(n"^(?:([+-])=|)(+ larnum + ")([a-z%]*)$"coai" )
		ur i cssEreand =m[e"Top"coaRight"coaBottom"coaLeft" ]		
r i rumentIsement & serumentIs.cumentIsement &;
	

	r i isAerhed = nunction( elem )n{ 		io/turn truery g.ntexnst ( em.noterDoDument.hx em ) {;	}re,	//mpilosnd ( 	 mpilosnd3;ue,  }		re Copport: IE 119 1 ]1+, Ee so12 1 ]8+, iOS 10.0 1 ]0.2nly
			 Genck agterhednt (i crossfshadowoDOM bndatarie oen stsitblinml(gh-3504)		 Copport: IEiOS 10.0-]0.2nly
			 GeEar
	 iOS 10 vy sn fthpport fo`terhedShadow`ebutenofo`getRootNes `,		 Gean  g an reeor wi.uWe xt fee-onck agl re`getRootNes `.	dv( cadumentIsement &.getRootNes n{ 		ioisAerhed = nunction( elem )n{ 		io/turn truery g.ntexnst ( em.noterDoDument.hx em ) {

						em[ ogetRootNes ( mpilosnd ) = doem.noterDoDument.h;	}re;	}}	r i isHiddenWh tinTree nunction( elem )x em ) 
			/ AvisHiddenWh tinTree might b  cel( d
lm touery g#filn( nnction( ;		/ Avin e teonase, ement (ith ? be leiondfgument )
		em,  eleup doem, 
			//EaInled" stylsore;mp(ocll	
eturn coem.nostyls.dabplay
= "stle; "

					em.nostyls.dabplay
= "st"  E				} Suherwise, theck agmpilurndpmiyln		// Repport: IEFirefoof<=43 1 45		// ReDisconntor d
em.gts frm beha opmpilurndpdabplay: deseseloanat ?
ntefirm e teoem,  i(		/	 Geithe lerumentIs.				 sAerhed =elem )n{  E				}uery g.nsselemen,l"dabplay+ ) = dotle; ";	}};	


nction seadst pCSSelemen,lrror	olues Partlse:weenn) 			r siadst p.d,elceli				maxIttiaon fth= 2
		lemurntNoVueue se:weenn				}nction( s{
		ififturn tr:ween.murn)			} eu					nction( s{
		ififturn truery g.nsselemen,lrror	o"" {
				
		leinitl up= murntNoVueue()				unit =mlue;
Partl
 ellueuePartl[ 3 )p do(ruery g.nssNenr t[ pm r ] ?o"" : "px" )				/ Reptartg anlues  mpiluraon fe hatuquintdgl repoxtNol upunit te tches )	leinitl uInUnit =mem.nodeType < 
					(ruery g.nssNenr t[ pm r ]  dounit ! 1 tpx"| el+initl up&&
					rcssNum.ec( (ruery g.nsselemen,lrrorn) )		
/ ( !fieitl uInUnit  Ex<eitl uInUnit[ 3 )p= oudeiti) 
			/ Avpport: IEFirefoof<=54			 FiHdl ope inittiaon f targetnlues   kepcuvt (itegerfed e e
lm toCSSoupper bndats=(gh-2144)			initl up= initl up/ 2		
i  ReTrt padeithaturt:  toby uery g.nss			unit =munit  do<eitl uInUnit[ 3 )
			//EaIttiaonly
	 aprroximoreefm unanle;zero startg anoot-d	leinitl uInUnit =m+initl up do1}
	//ile ( i-maxIttiaon ft ) {
						 GeElueseBu  bdmuprate our be paguensf(neue-g anguenses e teozero out)e	/// GeFinishg ( kheolceli uquse a recrosses 1 (makg thise old*new rroduct deseeo gonly)e	///uery g.miylnelemen,lrror	oinitl uInUnit +udeiti);				 ( ca0,1 -olceli ) *a0,1 -o(olceli = murntNoVueue() / initl up do0.5 {
{ <1 0 ) 						maxIttiaon fth= 0			}
}		
einitl uInUnit =minitl uInUnit /olceli}
	//
		// nitl uInUnit =minitl uInUnit * 2		//uery g.miylnelemen,lrror	oinitl uInUnit +udeiti);	
// Getcs  res owasuprate e eluweennpm rties (jaat i  s
	plue;
Partl
=mlue;
Partl
 do;
			}
		v( calue;
Partl
{ 		ioinitl uInUnit =m+initl uInUnit  do+initl up do0
	
		 Gedly( erelaonlye eft ar(+=/-=)g ( ecialer.d		/adst p.d
=mlue;
Partl[ 1 ) ?		
einitl uInUnit + calue;
Partl[ 1 ) + ) ) *alue;
Partl[ 2g]u					+lue;
Partl[ 2g];
i  ( ca:weenn) 					rween.unit =munit;				rween.start =minitl uInUnit;				rween.end =madst p.d
				}

	ot =n tradst p.d
	}		ur i fault
	Dabplayp );se{}
		nction segetDault
	Dabplayelem )n{ 		ir i remr				rum doem.noterDoDument.h				deTyNe );"sem.nodeTyNe )				rabplay
= fault
	Dabplayp )[ deTyNe );]		
/ ( !frabplay
) 				turn parabplay			}
		remr serum.body.appeddCle dcadum.eateBuement &( deTyNe );) )			rabplay
= uery g.nsselremr	l"dabplay+ );
		remr.rset &Nes .tume tCle dcaremr )		
/ ( !frabplay
= "stle; "
) 				rabplay
= "block";	}}		deult
	Dabplayp )[ deTyNe );] serabplay		
	turn parabplay		
function mashowHidee em, ts f,lshown{ 		ir i rabplay, emen,
	plue;
) =m[]		leinx of= 
		len =h,
 = em, ts f.ngth;

			 ReDetmissno new rabplay
lues  l reem, ts fre teoxt fee-oncginv
}r ( ; i <ex of< ngth;

 <ex o ) {
		ifem,  eleu )ts fi ]ex of];
i  ( ca!em.nostyls&{
				enoifin;
				
		marabplay
= em.nostyls.dabplay;
i  ( cashown{ 				// Repg c  w  l rc  visieility=up secelcede-hidden em, ts f,l bemediatelye(a seslow)				 Geeck ag hatuquintdgicouhilanat ?
loopoiqss we *kve a anle;ety inrabplay
lues  (eierwi		/	 Geitled"  ( about-to-bnesultor d)				 ( carabplay
= "stle; "
) 					plue;
)i ]ex of] sera oPrioeget(lem ), "dabplay+ )  doll;
			re} ( !f!lues )i ]ex of] ) 					f	em.nostyls.dabplay
= ;
	fo	}
				r}				 ( caem.nostyls.dabplay
= "st"  EvisHiddenWh tinTreeelem )n{ ) 					plue;
)i ]ex of] segetDault
	Dabplayelem )n{			}
}		
	lse {
				p ( carabplay
! "stle; "
) 					plue;
)i ]ex of] setle; ";				// SuRember t wt elrre juov( writg t		ma/ra oPrioeset(lem ), "dabplay+,frabplay
)			}
}		
	}

		m Gep":he lerabplay
o( kheoem, ts fr nhpoleiondfloopo poaid trctelta (ireflow
}r ( ; inx of= 
i <ex of< ngth;

 <ex o ) {
		ifv( calue;
)i ]ex of]  doll ? ) 					eu )ts fi ]ex of]ostyls.dabplay
= lue;
)i ]ex of];		
	}

		mturn coem.nxtBac	}		uery g.nn.prtend{
			show:inction( s{
		ifturn ellhowHidee uhilse:e, l);		},		hide:inction( s{
		ifturn ellhowHidee uhill);		},		toggd":inction( sestate {
		ifv( ca:eof elstate = nonblean p"|{ 		io/turn trstate ? uhilelhow ==	muhilehide(
}
	

		//turn eluhilech e{
nction( e{
					 ( caisHiddenWh tinTreeeluhill)
) 					puery geluhill)elhow =			} euse {
				puuery geluhill)ehide(
}
	

}		
	l{;	}}	) )
	r i reck aled"Te = Exca/^(?:eck abox|radio)$/i {;
	r i rtagNe );"sca/<([a-z][^\/\0>\x20\t\r\n\f]*)/i {;
	r i rscriptTe = Exca/^$|^modud"$|\/(?:java|ecma)script/i {;
	

{
nction( e{
			r i fragnt & serumentIs.eateBuDument.hFragnt &()				dio Sifragnt &.appeddCle dcadumentIs.eateBuement &( "dav"s) {		leinlur serumentIs.eateBuement &( "inlur"t
		so Eapport: IEAndrd tr4.0n-r4.3nly
			 Genck agstate lt )  ( kheome ==ih letn(#11217)		 Copport: IEWdow.lseWhbedlysf(WWA)		 Co`me =`  bdm`:eof`ast alud  esetAribute v l reWWA (#14901)		inluresetAribute v( ":eof"coaradio" {
		inluresetAribute v( "eck aed",e"eck aed" {
		inluresetAribute v( "me =",e"r"t
		sodioeappeddCle dcainlur 
		so Eapport: IEAndrd tr<=4.1nly
			 Gellr ) WhbKietn'est becle; oeck aedgstate corctly podoifragnt &s		pport f.eck aCle; o= dioecle; Nes ( :e, l)ecle; Nes ( :e, l)entstCle d.eck aed		re Copport: IE 11<=11nly
			 Getcs  res oxt )setae(a seeck abox) fault
	Vueue is prorti ?
mle; dsodioeinrDoML ? set<xt )seta>x</xt )seta>
	fopport f.noCle; Cck aedg= !!dioecle; Nes ( :e, l)entstCle d.fault
	Vueue		re Copport: IE 11<=9nly
			 Ge 11<=9nsuace( s <lponal> tags=th the lir ntextna( en stinse:  tooutsent of
/ Ree elseltor ement &.sodioeinrDoML ? set<lponal></lponal>
	fopport f.optns nco!!dioentstCle d;	) )(

		/ AdW*kve a e-onlo ine e ineags= popport foXML ? (#13200)	r i wrapp );se{	re CoXML ? rseOnrstn'enofomagicas poinse: oem, ts fr nhe n		 Cose );way rt elpag soup rseOnrstn'. Soe hac bnofolho:  n
/ Ree is by
omimag"  <tbody>  ( herwiltuquintdgem, ts f.		roead:m[e1,CH<tled">",e"</xled">" =x		col:m[e2,CH<tled"><colgroup>",e"</colgroup></xled">" =x		tr:m[e2,CH<tled"><tbody>",e"</xbody></xled">" =x		td:m[e3,CH<tled"><tbody><tr>",e"</xr></xbody></xled">" =x			_dault
	:m[e i H"	o"" ]


		wrapp ).xbody;sewrapp ).xfoot;sewrapp ).colgroup;sewrapp ).captns ncowrapp ).xoead;	wrapp ).xhncowrapp ).xd
		 Adpport: IE 11<=9nly
		 ( !f!sport f.optns n{
			wrapp ).optgroup;sewrapp ).optns nco[e1,CH<seltor mtipleCo='mtipleCo'>",e"</seltor>" ]		}
		nction segetA( Exntext
	,lpag ) {			 Eapport: IE 1 <19 1 ]1nly
			 Gee ineeof eltpoaid trzero-gument )atbthod invocaon f  f ht ) lbjtorso(#15151)
	r i tur		
/ ( !feeof elntext
	egetement &sByTagNe );! "stdefined" "=) 				tur = mtext
	egetement &sByTagNe )(lpag  do"*"t
		soelse {
 ( !feeof elntext
	eqry gSeltororA an! "stdefined" "=) 				tur = mtext
	eqry gSeltororA a(lpag  do"*"t
		soelse {
				tur = ;
			}
		v( capag  noudefined" 

	lpag  EvdeTyNe )Exntext
	,lpag ) {
		ifturn eluery g.merg)Ex[xntext
	, retur )	}

	sot =n trtur		}		
/Getcrk script);askve g"  dlready
beenielueseBudunction sesetGlobalElueExem, s,urefement &sn{ 		ir i = 0,
		len toem.nsength >		sor ( ; i < leni++ ) {
		ifra oPrioeset(				eu )fi ], r				"globalElue"r				!refement &sn docataPrioeget(lrefement &si ], re"globalElue"l)			{;	}}	)		ur i rhtml =a/<|&#?\w+;/
		nction sebue dFragnt &(xem, s,untext
	,lscript),lseltorn s, igno jdn{ 		ir i em ),l:mr	lpag,ewrap,gterhed.d,ejr			fragnt & semtext
	eeateBuDument.hFragnt &()				deNas =m[]		lei 0,
		len toem.nsength >		sor ( ; i < leni++ ) {
		ifem,  eleu )si ], 		
i  ( caem, o doem,  = do0 ) 				/	 Ged eldeNas rectly
					 ( !fkepe <fuem )n{  noutlbjtor"|{ 					// Support: IEAndrd tr<=4.0nly
	, Pha (omJS ,nly
						 Sush( pply( n_,eaay|Esiky)erow adoon ancit & WhbKie			puuery g.merg)ExdeNasseem.nodeType < ?l[tem,  ]=	mem )=);				/ Adntevt andesehtml  S maaoxt )xdeNa		} euse {
 ( !f!rhtmlest( maum )n{ ) 					pdeNasesh( mamtext
	eeateBuTt
	Nes ( um )n{ );				/ Adntevt anhtml  S maDOM deNas		} euse {
				purmr sermr  dofragnt &.appeddCle dcamtext
	eeateBuement &( "dav"s) {;				// SuDe irializeeahmiaatardhsupresiedaon f			purag   cartagNe ).ec( (rem ) {
 do[ H"	o"" ] )[ 1 ).toLgw( se();
		pu		wrap;sewrapp )[lpag ]  dowrapp )._dault
	
					rmrainrDoML ? sewrap[ 1 ) + uery g.htmlPrineln( (rem ) {
+ewrap[ 2;

			/// SuDe ce see roughewrappnrst poe elright ntextna			puu sewrap[ 0 ]
					ile ( i-j ) {
						urmr sermrentstCle d;	o	}
					// Support: IEAndrd tr<=4.0nly
	, Pha (omJS ,nly
						 Sush( pply( n_,eaay|Esiky)erow adoon ancit & WhbKie			puuery g.merg)ExdeNassermrecle dNeNas );				// SuRember t e eluop-lel c ntexnst( 			//rmr sefragnt &.nat ?Cle d;				// SuEures  uheemateBueldeNas as  orpha .dh(#12392)					rmraxt
	CtextNo
= ;
	fo	}}		
	}

		m GeRemo opwrappnrefm unfragnt &
	fragnt &axt
	CtextNo
= ;
	f
ei 0,
;
	ile ( i-(eem,  eldeNas[++ ) ]i)
{ 					 Supkipoem, ts frdlready
ithe lentext
	,cloweion f (erk -4087)
i =( !fseltorn s  Evuery gninray|Eseem ),lseltorn s ) > -) {

		i  ( caigno jdn{ 		i	i  gno jdesh( maem )n{			}
}		
enoifin;
				
		maaerhed = nu sAerhed =elem )n{
	
		 Gedlye seeonfragnt &
	/rmr segetA( Exfragnt &.appeddCle dcaem )n{	o"script"n{
	
		 GePresirvelscriptielueseBn s  isr, E			 ( caarihed = { 		i	isetGlobalElueExtmr )			

		// FiCaptes  ec( u led"s
i =( !fscript);{
					uh= 0			}
ile ( i-(eem,  eltmr[ j ) ]i)
{ 			re} ( !frscriptTe =est( maum ).:eof
 do""s) {
					//script)esh( maem )n{			}
/}		} e
}

	

	sot =n trfragnt &
	}		ur isotkeyEvt ( =a/^key/a		rlouseEvt ( =a/^(?:louse|oot-der|ntext
	nt u|drag|drop)|click/a		r:eofme =rpk e =a/^([^.]*)(?:\.(.+)|)/
		nction set =n tTrue() {	/turn seue;
		}		nction set =n tFse;
() {	/turn selse;
		}		 Adpport: IE 11<=9n1 ]1+	 Adfumes() a seblurn) as  ymchronizs e, eccept en ste ly as  no-op./ Eapoeecptordfumesot= bellchronizs eeen ste leement (iifrdlready
aionvex	 Ada seblurot= bellchronizs eeen ste leement (iifrt yealready
aionve./ Ea(fumesoa sebluroas  yays h lchronizs eeithherwilsport f tobrows( s		 Ree is st pafined"eeen st hac becnt == n it)e	nction seecptorSyncelem ),l:eof ) 			turn se(oem,  = dosafeAionveement &()n{  nou( ke < = 1 "fumes" )		}		 Adpport: IE 11<=9nly
		 AvAccessg"  dument.haaionveement &ac berow a unecptor d
		 Avtp:/s://buglejqry g.ntm/ticket/13393unction sesafeAionveement &()n{
etry 
			turn parument.haaionveement &;	}}lcch ) Exer n{ 	 }	}		nction se( elem ),l:eof),lseltoroo,tda o,xnn,ee; o{ 		ir i origFn,ote <;	
	 DeTeof)rm be aaa map; elte <s/halins, 
  ( ca:eof elte <s  noutlbjtor"|{ 					 Ea(lte <s-Objtor, seltoroo,tda o )
i =( !f:eof elseltoroo ! 1 tring" &&{
					/ Ad(lte <s-Objtor, da o )
i 	ca oncora o
 doseltoroo;	i	iseltoroo Exdefined" 
				}
	r ( ; ke < s"lueof);{
					( elem ),l:eofopseltoroo,tda o,xueof)[t:eof ],ee; o{
				}
	turn coem.n			}
		v( cada on= oll ?  Evfn  noll ? ) 					 Ea(lte <s,ufn {		}rn nuseltoroo;	i	ca oncoseltoroo Exdefined" 
		euse {
 ( !ffn  noll ? ) 		i =( !f:eof elseltoroo = "string" &&{
					/ Ad(lte <sopseltoroo,tfn {		}}rn nuda o			

ca oncodefined" 
				 se {
						 Ge(lte <sopda o,xnn {		}}rn nuda o			

ca oncoseltoroo;	i	iseltoroo Exdefined" 
				}
}
/ ( !ffn  noulse ) ) 		i fth=aru=n tFse;

		euse {
 ( !f!fn {
				turn coem.n			}
		v( cae; o= 1 ) ) 				origFn cofn;		fnn nunction( elevt ( {
					/ AdCan ds l elety iss":pance elevt (imtexnst pe ininfo
	puuery ge).offelevt ( {;	io/turn trorigFnpply( n uhilsegument )s )
			}
			//Eae inse );guid so cel( rrm betumo opusg"  origFn		fnn.guid 1;origFnpguid  do(rorigFnpguid = uery g.guid++ )	}

	eturn coem.noch e{
nction( e{
				uery g.cvt.haadd(luhilse:eofs	unn,eda o,xseltoroo )	}

 )		}		 *
 * Help(  nction fthr ( managg"  cvt.hs  ) t yepart o( kheopubce( tegerfk ee
 * Prorsot= De beEdwards' addEvt ( librar	or ( many
o( kheoidease
 */
uery g.cvt.h;se{	reglobal: {},	
	add:onction( elem ),l:eofs	uhalins,,eda o,xseltoroo )
					r i halinsObjIn,ecvt.hHdlin , rmr					cvt.hs, r, halinsObj,			pscialal	uhalins,lse:eofopme =rpk es,rorigTeof					em, Da oncora oPrioeget(lem )n{
	
		 Gely ?
arihed cvt.hs t= lbjtorsoe teocccept na o	i =( !f!acceptDa oelum )n{ ) 					turn t
			
		// AdCel( rrm bepasfr nhp  objtoro elcustomena or nhlieu
o( kheohalins,	i =( !fhalins,.halins,

 					halinsObjInncohalins,;				halinsrncohalinsObjIn.halins,;				seltoroo ExhalinsObjIn.seltoroo;	i	
		// AdEures  uha(itelueidxseltorooserow a exceptns soteharihed plme
/	 GeElueseBu  inst thrumentIsement & in naseoem,  i(hpodeseel.gts  deNa (e.g.,hrumentIs)
i =( !fseltor w {
		iouuery g.nedd.tches )SeltororcadumentIsement &,xseltoroo )	}


		// AdMcs  res oxt elp elhalinsrnhaa douniqry ID, ud toeonfedd/tumo opiteaat i
		=( !f!halins,.guid 
 					halinsrpguid = uery g.guid++	}


		// AdInit e leement ('slevt ( rinuctes  a semciauhalins,,edfekhis is e n fat ?
		=( !f!( cvt.hs eleu )Da o.cvt.hs { ) 					cvt.hs eleu )Da o.cvt.hs =aObjtoreeateBu(oll ? )
				}
	=( !f!( cvt.hHdlin eeleu )Da o.halins { ) 					cvt.hHdlin eeleu )Da o.halins nunction( ele|{ 					// SuDiscardhe elseiondfevt (  el ruery g.cvt.hainggger() a s			// Suen st elevt (iifrcel( d
afr toaepageaha);uy
oadtd
		i turn seueof eluery g ! "stdefined" "= Evuery gncvt.hainggger d
! "se.:eof
					mauery gncvt.hadabpchespply( n em ),lgument )s )
:ldefined" 
				e	}


		// AdHdlin emtipleConcvt.hs seram rndpbyeahmpk e			te <s  e(lte <s
 do""s).mehes(irxothtmlilet= )  [];o"" ]	}

t Ex:eofsength >				ile ( i-t ) {
					rmr ser:eofme =rpk e.ec( (rueof)[t: ]i)
 do;
					pe = ExorigTeof eltmr[ 1 ]
				me =rpk es  e(ltmp[ 2;

 do""s).spli&( "."s).st: ();				/ AdTn s  *st a*e aaa :eofopmoharihedg"  de =rpk e-ly
	 halins, 
 
	=( !f!:eof ) 				
enoifin;
					
		/// GeIflevt (imcginvs irsoeeofopu ine elscialalouvt (ihalins,s l rekheecnginvdeueof
/	pscialal = uery g.cvt.hascialal[t:eof ]
 do{}
			// ReIelseltoroo fined" ,odetmissnolscialalouvt (iapie:eofopoerwise,  gelynoueof
/	ppe = Excaseltoroo ?lscialal.cel gdoeTeof :lscialal.beddpe < 


	lpe <;	
		//Eaeprate scialalobad toon new( eret areeof
/	pscialal = uery g.cvt.hascialal[t:eof ]
 do{}
			// RehalinsObj is pasd toeoncllhuvt (ihalins,s				halinsObj = uery g.crtend{
			/	ppe =:e:eofo		/	porigTeof:rorigTeof						da o:oda ox					halinsr:uhalins,,					guid:uhalins,.guid,					seltoroo:pseltoroo,					xt fsntext ):pseltoroo= Evuery gncxpr.mehes.xt fsntext )est( maseltoroo ),					xe =rpk e:pme =rpk es.join( "."s)				
,xhalinsObjIn );				/ AdInit e leevt (ihalins,
qryue iflrre jue n fat ?
			=( !f!( halins,s =ncvt.hs[t:eof ]
) {
					/halins,s =ncvt.hs[t:eof ]
=o;
					/halins,s.cel gdoeCnt === 0					// Suhy
	 ds l ddEvt (Li a netg ( kheolcialalouvt (sihalins,
turn ssulse )		re} ( !f!scialal.t aup

							scialal.t aupell( Exem, ,uda o,xme =rpk es,rcvt.hHdlin e)  noulse ) ) 								 ( caem.no ddEvt (Li a netg) 								em.no ddEvt (Li a netse:eofopcvt.hHdlin e)					/
				}
					
		///=( !fscialal. ddg) 						scialal. ddell( Exem, ,uhalinsObj );				// ( ( !halinsObj.halins,.guid 
 							halinsObj.halinsrpguid = halinsrpguid;			}
					
		/// Ged el poe element ('slhalins,
li a, cel gdoesodoifron?
			=( !fseltor w {
		iou/halins,s.spli( 0,halins,s.cel gdoeCnt =++,e i halinsObj );		} euse {
				puhalins,s.sh( mahalinsObj );		} e		/// GeKeepherk to elatichouvt (sihavleevtr
beeniud t, l reevt (  ptnmizaon f			puery g.cvt.haglobal[t:eof ]
=oue;
				
		m},	
	 DeDeihed  elevt (ioreletn fouvt (sifm unacoem.nxtB		reme t:inction( slem ),l:eofs	uhalins,,eseltoroo,tmappedTeof);{
					r i j,rorigCnt =, rmr					cvt.hs, r, halinsObj,			pscialal	uhalins,lse:eofopme =rpk es,rorigTeof					em, Da oncora oPrioesh;Da oelem ) {
 Evra oPrioeget(lem )n{
	
		 ( ca!em.nDa o
 do!( cvt.hs eleu )Da o.cvt.hs { ) 					turn t
			
		// AdOe e
l reehed pe =eme =rpk e s"lueof);t:eof mapobeeomimatd
		te <s  e(lte <s
 do""s).mehes(irxothtmlilet= )  [];o"" ]	}

t Ex:eofsength >				ile ( i-t ) {
					rmr ser:eofme =rpk e.ec( (rueof)[t: ]i)
 do;
					pe = ExorigTeof eltmr[ 1 ]
				me =rpk es  e(ltmp[ 2;

 do""s).spli&( "."s).st: ();				/ AdUnbeddncllhuvt (s (ocouhilame =rpk e,edfeproventl) l rekheeem.nxtB		
	=( !f!:eof ) 				
er ( ; ke < s"lcvt.hs { {				mauery gncvt.hatume telem ),lieof + ueof)[t: ]	uhalins,,eseltoroo,tie, l);		f	/}		} enoifin;
					
		///scialal = uery g.cvt.hascialal[t:eof ]
 do{}
	/	ppe = Excaseltoroo ?lscialal.cel gdoeTeof :lscialal.beddpe < 


	lpe <;			/halins,s =ncvt.hs[t:eof ]
 do;
					pmr sermr[ 2;


						new RegExp(n"(^|\\.)+ lame =rpk es.join( "\\.(?:.*\\.|)"|{ + "(\\.|$)" );				/ AdRemo optchesg"  cvt.hs
/	porigCnt === j = halinsrsength >					ile ( i-j ) {
						halinsObj = halinsrs[ j ];				// ( ( (tmappedTeof); b.trigTeof e=ExhalinsObj.trigTeof &&
							(r!halins,; b.halinsrpguid ==ExhalinsObj.guid 
 
							(r!rmr  dormraxt( mahalinsObj.me =rpk e ) 
 
							(r!seltoroo  doseltoroo ==ExhalinsObj.seltoroo  d							seltoroo = "st**"= EvhalinsObj.seltoroo ) 
 							halins,s.spli( 0,j,r1 );				// =( !fhalinsObj.seltoroo ) 								halins,s.cel gdoeCnt =--				f	/}		} e/=( !fscialal.tumo op) 								scialal.tumo oell( Exem, ,uhalinsObj );				/
				}
					
		/// AdRemo opt ntiiceevt (ihalins,
iflrratume td sombtsg"  a set  me mahalins,s t,i a	/// Ad(aid tsepoxtNol upl reelinsshatursivn madung"  tume  upoflscialalouvt (ihalins,s)				 ( catrigCnt == e !halinsrsength >
{ 			re} ( !f!scialal.teardown

							scialal.teardownell( Exem, ,ule =rpk es,rcu )Da o.halins {  noulse ) ) 								uery g.t me tEvt (elem ),l:eofopcu )Da o.halins {;	o	}
					//cel r  cvt.hs[t:eof ]	fo	}}		
	}
// AdRemo opda o a see inpreando  weie'set  loinvriud t
		 ( cauery gnisEty iObjtor( cvt.hs { ) 					da oPrioetume telem ),l"halins cvt.hs" )
				}
},	
	dabpches:inction( slnaonlyEvt ( {
					r i ixljretur, tches d, halinsObj,ihalins,Qryuex				trgs =nnew ray|Esegument )sength,
 )				// AdMcs  a writled"auery gnEvt ( lm top elnaonlylevt (iobjtor		//cvt.h;seuery g.cvt.hafixslnaonlyEvt ( {				//halins,s =nE
				/ra oPrioeget(luhilse"cvt.hs" )  doObjtoreeateBu(oll ? )
				)[ cvt.haieof ]
 do;
,			pscialal = uery g.cvt.hascialal[tcvt.haieof ]
 do{}
			//Eae ine n fax- touery gnEvt ( raerwilthaste le(read-ly
	)lnaonlylevt (
		trgs[ ] = =ncvt.h
			/r ( i in1;
	 < legument )sength,
i++ ) {
		if	trgs[ i = =ngument )si ], 			
	}
//cvt.hadel gdoeTargetn( uhil
			//EaCel(pe inrpeDabpchesohook l rekheemappedl:eofopa sel rpitebail  wedesintd
e/=( !fscialal.rpeDabpcheso e scialal.rpeDabpchesell( Exuhilseevt ( {
 noulse ) ) 		i 	turn t
			
		// AdDetmissno halins,s			halins,Qryue = uery g.cvt.hahalinsrsell( Exuhilseevt (	uhalins,ln{
	
		 GeRun cel gdoesofat ?;te ly mapowa (i poptopoprorageBn s b ntat) us
i =h= 0			}ile ( i-(etches d = halinsrQryue[ + ) ]i)
 e !cvt.haisProrageBn sStoppnd() ) 					cvt.h.murntNoTargetn( tches d.em, 
			/	uh= 0			}
ile ( i-(ehalinsObj = tches d.halinsrs[ j ) ]i)
 e
				!cvt.haisIediatelyProrageBn sStoppnd() ) 					// SuIwee n evt (iifrle =rpk ed,he fneehed halins,
i);ly
	 invoaedgithi)  t			// Suscialal
	 dnivy s upor irsome =rpk es as  ylspoy set o( kheoevt ('s.		re} ( !f!cvt.hatme =rpk e  b.halinsObj.me =rpk e  noulse ) 
							cvt.hatme =rpk eaxt( mahalinsObj.me =rpk e ) 
 								cvt.hahalinsObj = halinsObj;						cvt.haca oncohalinsObj.rata
			//		tur = ( cauery gncvt.hascialal[thalinsObj.trigTeof ]
 do{}l)ehalins  d							halinsObj.halinsr,
ealy( n tches d.em, ,lgums );				// =( !ftur = oudefined" 
{ 		io		// ( ( (tcvt.hatuet
	i=etur )
 noulse ) ) 		i 					cvt.hapcuvt (Dault
	;
		pu					cvt.haptopProrageBn s;
		pu				e
			//e
			/}		} e
}

		///EaCel(pe inrostDabpchesohook l rekheemappedl:eof
e/=( !fscialal.rostDabpcheso{ 		i	iscialal.rostDabpchesell( Exuhilseevt ( {
			
		//turn coevt.hatuet
	;}
},	
	halinsrs:unction( elevt (	uhalins,ln{ 		i	r i ixlhalinsObj,isel, tches dHalins,lsetches dSeltororls				halins,Qryue = ;
,			pcel gdoeCnt === halins,s.cel gdoeCnt =					nur =ncvt.h.target
	
		 GeFeddncel gdoe halins,s			v( cadel gdoeCnt == E				} Support: IE 11<=9			} SuBlack-hons SVG <ud >
 esrt c  trees (erk -13180)				nurodeType < 
					} Support: IEFirefoof<=42			} Supporrensfscia-violaon"  clicksododicaon"  podeseprimar	 oot-derebutt f (erk -3861)				 Getp:/s://www.w3. cg/TR/DOM-Lel c-3-Evt (s/#cvt.h-:eof-click			} Support: IE 11+,nly
					 Su...butenofoarw a keyg"clicks" o( radioainlurlseatichom beha op`butt f` -) (gh-2343)				!( cvt.h.ke < = 1 "click"= Evcvt.h.butt f >1 ) ) 
 						r ( ; i nur = ouuhil
 nur =nnurorset &Nes   dorhill)
					// SuDot becnk agdeseel.gts s (#13208)			// SuDot beprocess clicksooparabled"d
em.gts fr(#6911, #8165, #11382, #11764)					 ( cacuoodeType < = 1 )  e !( cvt.h.ke < = 1 "click"= Evcuoorabled"d
= 1 ie, l) ) 		i 			tches dHalins,l
=o;
					/	tches dSeltororl =o{}
	/	p	/r ( i in1;0	 < ledel gdoeCnt =i++ ) {
		if				halinsObj = halinsrs[ i ];				//// SuDot beconflict=th thObjtoreprotoke < pm rties (j(#13203)					//sel ExhalinsObj.seltoroo + " ";				//// ( catches dSeltororl[isel = = oudefined" 
{ 		io		//	tches dSeltororl[isel = =ahalinsObj.mt fsntext )
					ma	puuery gelsel, uhill)e]ex ocacuo ) > -) :				ma	puuery g.neddelsel, uhil,ull, to[acuo ]l)ength >					ma/e
				// ( catches dSeltororl[isel = { 		io		//	tches dHalins,l.sh( mahalinsObj );		} 			e
			//e
			// ( catches dHalins,l.ngth >
{ 			re}		halins,Qryue.sh( ma{
em.g:acuo	uhalins,l:atches dHalins,l } );				/
				}
					
	}

		///Ead el hratumainn"  (rectly
	-bndat) halins,s			nur =nuhil
			v( cadel gdoeCnt ==< halinsrsength > 
 					halinsrQryue.sh( ma{
em.g:acuo	uhalins,l:ahalins,s.sli( 0,del gdoeCnt ==) el);		f
		//turn elhalinsrQryue;}
},	
	addPror:inction( slna, ophook 
 				Objtorefined"Pm rtiey(ouery gnEvt (eprotoke <, me, op					cnentrled"3;ue, 					nnnfigurled"3;ue, 						get:oisFction( slhook 
 					mnction( s{
		ifife ( !fkhiletriginalElt ( {
		io		//	turn elhook!fkhiletriginalElt ( {;				/
				}
	 :				mnction( s{
		ifife ( !fkhiletriginalElt ( {
		io		//	turn elkhiletriginalElt ([ame ==];				/
				}
							set:onction( ellues  ) 
			}	Objtorefined"Pm rtiey(ouhil,ule, op							cnentrled"3;ue, 							nnnfigurled"3;ue, 							writled"3;ue, 							lues :hlues 	//f	el);		f
}		
	l{;	}}				fax:onction( eltriginalElt ( {
		ioturn troriginalElt ([auery gncxpando ] 					triginalElt ( :				new uery gnEvt (eltriginalElt ( {;	}}				scialal:
		io
oad:
					/ AdPcuvt (ienggger d
image.
oadouvt (sifm unbube-g an powdow.l.
oad				noBube-"3;ue, 
}re,	//mlick:
					/ AdUtilizeenaonlylevt (i reeures  corctlygstate r ( eck aled"ainlurl				setur:inction( slda on) 					// SuF ( mutual mpilrensieility=th th_dault
	,nsuace(  `uhil`laccess=th thalloll(hlur.			// Su` docata` is ceadoceNaomea == nly  kepcusirvel hraluriled"ae rougheminnficaon f.			//r i em =nuhiln docata					// SuClaimue n fat ?ohalins,	i / =( !fteck aled"Te =est( maum.teof &&
							um.mlick  EvdeTyNe )Exel, "inlur"t
 
 								//vra oPrioeset(lem, "click",u... )
					lel rageNaonly(lem, "click",ut =n tTrue {;	o	}
					// AdRern selse;
oeoncll a n pmtleprocessg
	a the lenel( r
	//	turn ellse;
			}re,	//	enggger:inction( slda on) 					// SuF ( mutual mpilrensieility=th th_dault
	,nsuace(  `uhil`laccess=th thalloll(hlur.			// Su` docata` is ceadoceNaomea == nly  kepcusirvel hraluriled"ae rougheminnficaon f.			//r i em =nuhiln docata					// SuF rc  t aup
bal reaengggern"  poclick			} =( !fteck aled"Te =est( maum.teof &&
							um.mlick  EvdeTyNe )Exel, "inlur"t
 
 								lel rageNaonly(lem, "click" {;	o	}
					// AdRern sedeselse;
oeoncll a n pmtlecvt.h-pat) prorageBn s
	//	turn elue;
				
							 SuF ( cross-brows( rcteli a ncy,lsporrensfnaonlyl.mlicks{
onhlink(		/	 GeAlskepcuvt (itt iflrre jumurntNo poinsent dolel ragedfnaonly-evt ( riack			}_dault
	:mnction( elevt ( {
				//r i targetn( cvt.h.target
		//	turn elteck aled"Te =est( matarget.teof &&
							target.mlick  EvdeTyNe )Extarget, "inlur"t
 
							ra oPrioeget(luarget, "click" {  d						deTyNe )Extarget, "a"l);		f
}		
						bal reuy
oad:
		io	rostDabpches:mnction( elevt ( {
					// Adpport: IEFirefoof20+			// SuFirefoofn'est bealt an ( kheoturn eVueue fieldiifrt yet a.		re} ( !fcvt.hatuet
	i= oudefined" 
 elcvt.hatriginalElt ( {
		io		/cvt.hatriginalElt (.turn eVueue =oevt.hatuet
	;}
	}
					
	}

	}}	)
	
 SuEures  uheepresiece  el elevt (ili a netgxt elhalinss mcnual
	-enggger d
 Susynuheticeevt (s by
t-derruptg anopegrensft =i? reinvoaedgibetusptel
oeo
 Su*naonly* cvt.hs tha(itt fatas rectly
	,eeuresg thisaygstate mcginvs ha o	 Adalready
ocmurntd
bal reaherwilli a nets as  invoaede	nction selel rageNaonly(lem, :eofopccptorSync ) {			 EaMissg
	accptorSync dodicaoes aaengggerenel(seatichost alf rc  t aup
e rougheuery g.cvt.haadd
} ( !f!ccptorSync ) {	/dv( cada oPrioeget(lem,l:eof ) = oudefined" 
{ 		io	uery g.cvt.haadd(lem, :eofopt =n tTrue {;	o		}
	turn c;}

		m GeRegi a rhe lentexrol( rraa doscialal dnivy s uphalinsr,r ( cllhuvt (ime =rpk es
/ra oPrioeset(lem, :eofoplse ) );}
uery g.cvt.haadd(lem, :eofop		ioxe =rpk e:plse ),	//halinsr:unction( elevt ( {
				/r simotAlchr, reet
	,					sav d = ra oPrioeget(luhilse:eof );		///=( !f!fcvt.haisTngggere& ) )  ( shil[ :eof ]
) 					// SuI-derrupteprocessg
	ao( kheooua rhsynuheticeainggger()edlevt (
		// Adpav d da onshould
baplse ) ibesuchom ses,rbutemight b  doleftov(  captes  objtor		/// Adfm unacoymchrfnaonlylhalinsr,(gh-4350)					 ( ca!sav dength > 
 								//vStos  gument )s r ( ds len sthaling thise inrDolnaonlylevt (
				/ AdTn s  th ? ways h b  aygletst e; ogument )a( elevt (iobjtor)seloauhilnaay|E
				/ Adth ? t yeblentefud toth thalleftov(  captes  objtor.		re}	sav d = sli( ell( Exgument )s )
				a/ra oPrioeset(luhilse:eofopsav d );				//  AdTngggerep elnaonlylevt (ia secaptes  ithatuet
							//vSport: IE 11<=9n1 ]1+						//vfumes() a seblurn) as  ymchronizs e						detAlchr =oecptorSynceluhilse:eof=);				/	shil[ :eof ];
		pu			tuet
	i=era oPrioeget(luhilse:eof );						 ( casav d = outuet
	i doletAlchr {
		io		//ra oPrioeset(luhilse:eofoplse ) );}

	}
	use {
				pu		tuet
	i=e{}
	/	p	/}						 ( casav d = outuet
	i
 								/ AdCancel kheooua rhsynuheticeevt (
				/	cvt.haptopIediatelyProrageBn s;
		pu				cvt.hapcuvt (Dault
	;
		pu				t =n trtuet
	.vueue			o	}
					// AdIfekhis is  bemnrDolsynuheticeevt (,r ( celevt (ith thalbube-g anrespegely			// Ad(fumeso ( blur)seassentoxt elp elrespegelydalready
prorageB d
lm toengggern"  td;
if// Renaonlylevt (ia sepcuvt (ie a( lm tohappedn"  pgciauh s .			// SuThis technicas pogets e n ordern"  wniz  w.r.t.oeon`ainggger()` (iauatichotd;
if// Rebube-g anrespegely
prorageB s *afr t*ep elnesebube-g anbad ),ebutee aygseemt			// Sunsshabadlthastdupli(aon f.			//euse {
 ( !fcauery gncvt.hascialal[tteof ]
 do{}l)ecel gdoeTeof {
		io		/cvt.haptopProrageBn s;
		pu		
		/// GeIflkhis is  enaonlylevt (i nggger d
abov(seevtrytsg"  ifrt weithhrder				 SuFis  a emnrDolsynuheticeevt (,th the lltriginalxgument )s
	//euse {
 ( !fsav dength > 
 							 Su...a secaptes  kheotuet
						ra oPrioeset(luhilse:eofop{						lues :huery g.cvt.hainggger(							/ AdSport: IE 11<=9n1 ]1+							 GeErtend,th the llprotoke <  masus":he leabov( ptopIediatelyProrageBn s;
							uery g.crtend{
sav d[ ] =x uery gnEvt (eprotoke < ),					}	sav d.sli( 0,1 ),					}	uhil					})	//f	el);						 SuAbt fohaling thofep elnaonlylevt (
		/	cvt.haptopIediatelyProrageBn s;
		pu	
	}

	}} )		}		uery g.t me tEvt ( nunction( elem )x :eofophalins { {			 EaThis "if" ifrteedtdgl replciaulbjtors
	 ( caem.not me tEvt (Li a netg) 				em.not me tEvt (Li a net( :eofophalins {;	}}	)
	
uery gnEvt ( nunction( elsrc,lrrors { {			 EaAll a  esrt tieBn s th toutee fi'new' keywhrd
} ( !f!eluhill esrt c  eluery g.Elt ( {
{
		ioturn trnew uery gnEvt (elsrc,lrrors {;}

		m GeEvt (iobjtor		 ( !fsrco e src.teof &&		iokhiletriginalElt ( = src;	iokhilepe = Exsrc.teof
	
		 GeEvt (s bube-g anuphe ledumentIs mapoha opbeenimaraedgasepcuvt (td
e/ Rebyeahhalins,
lgw(  down
e eluree;irefltlyge lentrctlyglues .	iokhileisDault
	Pcuvt (td Exsrc.dault
	Pcuvt (td  d					src.dault
	Pcuvt (td = oudefined" 
 e				// Support: IEAndrd tr<=2.3nly
						src.turn eVueue =noulse ) 					t =n tTrue :				t =n tFse;

	
e/ ReCateBu targetnpm rties (
// Support: IESafarir<=6n1 7nly
				 EaTargetnshould
t yebleaoxt )xdeNa (#504, #13143)			khilepargetn( (xsrc.targetn e src.target.deType < = 1 3 
 					src.target.rset &Nes  :				src.target
	
e/khilemurntNoTargetn( src.murntNoTarget;	iokhilerelaoedTargetn( src.relaoedTarget;		m GeEvt (i:eof
e	use {
				khilepe = Exsrc;}

		m GePuteecpli(io poproventl pm rties (jon poe elevt (iobjtor		 ( !frrors { {			uery g.crtend{
uhilserrors {;}

		m GeCateBu a plmesrtmpgithincomg"  cvt.hfn'est beha ope; */khileplmeSrtmpg=fsrco e src.tlmeSrtmpg doDeBu.dew(
		so Eatcrk itgasefixtd
eshil[ uery gncxpando ] =oue;
		)
	
 Suuery g.Elt ( is bad toon DOM3eEvt (s as ecialer.debyee elECMAScriptiLanguageaBdoding	 Avtp:/s://www.w3. cg/TR/2003/WD-DOM-Lel c-3-Evt (s-20030331/ecma-script-bdoding.html
uery gnEvt (eprotoke < se{		cteltnuctoo:puery gnEvt (,		isDault
	Pcuvt (td:aru=n tFse;
,		isProrageBn sStoppnd:aru=n tFse;
,		isIediatelyProrageBn sStoppnd:aru=n tFse;
,		isSimulaoed:plse ),			pmuvt (Dault
	:inction( s{
		ifr i e =nuhiletriginalElt (
	
e/khileisDault
	Pcuvt (td Ext =n tTrue		
i  ( cae  e !khileisSimulaoed ) 					capcuvt (Dault
	;
		pu	}
},		ptopProrageBn s:inction( s{
		ifr i e =nuhiletriginalElt (
	
e/khileisProrageBn sStoppnd Ext =n tTrue		
i  ( cae  e !khileisSimulaoed ) 					captopProrageBn s;
		pu	}
},		ptopIediatelyProrageBn s:inction( s{
		ifr i e =nuhiletriginalElt (
	
e/khileisIediatelyProrageBn sStoppnd Ext =n tTrue		
i  ( cae  e !khileisSimulaoed ) 					captopIediatelyProrageBn s;
		pu}	
e/khileptopProrageBn s;
		p}	)
	
 SuIncluNas all mpimoelevt (irrors incluNg"  KeyEvt ( a seMouseEvt ( ecialercirrors
uery g.ch e{
			altKey3;ue, 			bube-es3;ue, 			cancelled"3;ue, 			cnginvdToues )3;ue, 			ctrlKey3;ue, 			detail3;ue, 			evt (Phas"3;ue, 			metaKey3;ue, 			pageX3;ue, 			pageY3;ue, 			shiftKey3;ue, 			view3;ue, 			"cngr"3;ue, 			cod"3;ue, 			cngrCod"3;ue, 			key3;ue, 			keyCod"3;ue, 			butt f3;ue, 			butt f)3;ue, 			clit &X3;ue, 			clit &Y3;ue, 			 eft aX3;ue, 			 eft aY3;ue, 			oot-derId3;ue, 			oot-derTeof:rue, 			screenX:rue, 			screenY3;ue, 			targetToues )3;ue, 			toement &3;ue, 			toues )3;ue, 		
	ilees:mnction( elevt ( {
		ifr i butt f =oevt.habutt f
	
		 Geddduatichol rekeygcvt.hs
e} ( !fcvt.haaticho= oll ?  EvtkeyEvt (est( mauvt.h.ke < { ) 					turn tauvt.h.cngrCod"  doll ? ?auvt.h.cngrCod" :auvt.h.keyCod"
			
		// Adddduatichol remlick:
1 = 1 left; 2 = 1 midins; 3 = 1 right
e} ( !f!cvt.haaticho Evbutt f = oudefined" 
 elrlouseEvt (est( mauvt.h.ke < { ) 					 ( !fbutt f & ) ) 						turn ta1					
		/// ( !fbutt f & 2 ) 						turn ta3					
		/// ( !fbutt f & 4 ) 						turn ta2					
		///turn ta0
			
		//turn coevt.haatich		p}	),euery g.cvt.haaddProrn)
	
uery gnch e{
	vfumes: "fumesin", blur: "fumesour"t),enction( se:eofopcel gdoeTeof {
		iuery gncvt.hascialal[tteof ]
= 					 EaUtilizeenaonlylevt (idfepitblinmlso blur/fumesosequiece ifrctrctly
		setur:inction( s{
					/ AdClaimue n fat ?ohalins,	i ///vra oPrioeset(luhilse"fumes",u... )
			//vra oPrioeset(luhilse"blur",u... )
			lel rageNaonly(luhilse:eofopccptorSync );				/ AdRern selse;
oeoncll a n pmtleprocessg
	a the lenel( r
	//turn ellse;
			}e,	//enggger:inction( s{
					/ AdF rc  t aup
bal reaenggger
			lel rageNaonly(luhilse:eof );				/ AdRern sedeselse;
oeoncll a n pmtlecvt.h-pat) prorageBn s
	//turn elue;
										cel gdoeTeof:pcel gdoeTeof	}};	el);		 GeCateBu louset (tr/leavoncvt.hs usg"  louseov( /outeandfevt (-tlme eck as
 Susoee aygcvt.hfnel gdon s torksodoeuery g.
 SuDolp elre ==l repot-dert (tr/pot-derleavona sepot-derov( /pot-derout
 S
 Support: IESafarir7nly
		 AvSafarirseats=louset (troeoo often;gsee:	 Avtp:/s://bugleronimium. cg/p/ronimium/issues/detail?id=470258	 Adfurep elNascriptn se(fep elbug (it t,i aedgibeolr ) Conime vy sn fthawe *ll).
uery g.ch e{
			louset (tr: "louseov( "r		louseleavo: "louseour"			oot-dert (tr: "pot-derov( "			oot-derleavo: "pot-derout"
),enction( setrig,efix {
		iuery gncvt.hascialal[ttrig ]
= 				cel gdoeTeof:pfix,	//beddpe <:pfix,	
//halins:unction( elevt ( {
				/r situr,					targetn( uhil,					tulaoed =oevt.hatulaoedTargetx					halinsObj = evt.hahalinsObj;				/ AdF r louset (tr/leavoncel(pe inhalins,
ifltulaoed i);lutsent e eluarget.			/ AdNB: No relaoedTargetn ( kheolouse left/t (treel hrabrows( rwdow.l	/// ( !f!tulaoed  do(rtulaoed = ouuargetn e !uery g.ntexnst Extarget, tulaoed )l) ) 		i 		cvt.h.ke < =thalinsObj.trigTeof
		//	tur =thalinsObj.halinsrpply( n uhilsegument )s )
					cvt.h.ke < =tfix		pu	
	}
ot =n trtur		pu	}
};	el);		uery g.nn.prtend{
				 s:inction( sl:eof),lseltoroo,tda o,xnn {
		ioturn tron(luhilse:eofs	useltoroo,tda o,xnn {;	}}			 se:inction( sl:eof),lseltoroo,tda o,xnn {
		ioturn tron(luhilse:eofs	useltoroo,tda o,xnn,r1 );	}}			 ff:inction( sl:eof),lseltoroo,tnn {
		ior i halinsObj,lpe <;			=( !f:eofl
 el:eofsepcuvt (Dault
	
 el:eofsehalinsObj )
						 Ge(levt ( {
 dabpches touery gnEvt (
			halinsObj = :eofsehalinsObj		pu	uery gelueofsedel gdoeTargetn).offe					halinsObj.me =rpk e 					mahalinsObj.trigTeof + "."s+ahalinsObj.me =rpk e :				mahalinsObj.trigTeofx					halinsObj.seltoroo,					halinsObj.halinsr				{;	io/turn truhil
			}			=( !f:eof elte <s  noutlbjtor"|{ 					/ Ad(lte <s-objtoro[,lseltoroo] {		}}r ( ; ke < s"lueof);{
					okhiletffel:eofopseltoroo,tiyof)[t:eof ]n{			}
}		
eturn truhil
			}			=( !fseltoroo = "slse ) 
	f:eof elseltoroo = "stnction( "|{ 					/ Ad(lte <so[,lfn] {		}}rn nuseltoroo;	i	iseltoroo Exdefined" 
				}
	 ( !ffn  noulse ) ) 		i  fth=aru=n tFse;

				}
	turn couhilech e{
nction( e{
					uery gncvt.hatume teluhilse:eofs	unn,eseltoroo )	}


l{;	}}	) )
		ur isre Copport: IE 11<=10n1 ]1, Edge 12n1 ]3nly
			 GeInE 1/Edge usg"  regex groupsuh s nceuses sel reeslowdowns.		 Copeevtp:/s://ntentor.microsoft.ntm/ 1/feedback/details/1736512/
	rnoInrDohtml =a/<script|<styls|<link/i,	
	 Deeck aed="eck aed"  ( eck atd
ercck aedg= /cck aed\s*(?:[^=]|=\s*.eck aed.)/i,	ercan pScripti=a/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;		 GePrin toaexbody;ov(  itharset & tled"al remtexnstg"  dew rows	nction semanipulaon sTargetelem )x ntextna ) 		i ( !fdeTyNe )Exel ),l"tled""t
 
				deTyNe )Exntextnt.deType < = ou11 ?antextna :xntextnt.nat ?Cle d,l"tr"t
 
 					turn eluery g(lem )n{ecle det ( ":body" )[ 0 ]
 doem.n			}
		turn coem.n		}		 AdRuace( /sultor  e elue < aribute v  elscriptiem.gts frl resafeaDOM manipulaon s	nction serabled"Scriptelem )n{ 		iem ).:eof
= caem.nogetAribute v( ":eof"n{ ! noll ? ) + "/"s+aem ).:eof;		turn coem.n		}	nction set ltor Scriptelem )n{ 		i=( !f!fcm ).:eof
 do""s).sli( 0,0, 5 ) = ou"ue;
/"=) 				em ).:eof
= em ).:eof.sli( 0,5 )	}

 se {
				em.not me tAribute v( ":eof"n{			}
		turn coem.n		}		nction secle; CopyEvt (elsrc,lNasa ) 		ir i ixlm, :eofopprataO d,lurataO d,lurataCuo	ucvt.hs		
/ ( !fNasa.deType < = ou1 {
		ioturn t;}

		m Ge1. Copy priveBu da o:ocvt.hs	uhalins,lseetc.
dv( cada oPrioesh;Da oelsrco) ) 		i prataO di=era oPrioeget(lsrco)	}

cvt.hs =pprataO d.cvt.hs		
/} ( !fcvt.h);{
					da oPrioetume telNasa,l"halins cvt.hs" )
			}}r ( ; ke < s"lcvt.h);{
					/r ( i in1;0xlm =ncvt.hs[t:eof ]ength,
i++ leni++ ) {
		if			uery gncvt.haadd(lNasa,l:eofopcvt.hs[t:eof ][ i = {			}
/}		} e
}

	

	so Ge2. Copy us( rna o	iv( cada oUss,.ha;Da oelsrco) ) 		i urataO di=era oUss,.access(lsrco)	}

urataCuo = uery g.crtend{
	},lurataO d )
			}ra oUss,.set(lNasa,lurataCuo {;	}}	)		 SuFixE 11bugl,eseeopport fost( s	nction sefixInlurelsrc,lNasa ) 		ir i deTyNe )i=erasa.deTyNe ).toLgw( se();
		so GeFails  kepy snsyge lenck aedgstate  el rmle; deeck abox  ( radioabutt f.	i ( !fdeTyNe ) = ou"inlur"t elreck aled"Te =est( masrc.teof &&) 				cest.cck aedg= src.mck aed		re CoFails  keturn couhelseltor tooptn se poe eldault
	lseltor tostate en stmle;g thoptns s		euse {
 ( !fdeTyNe ) = ou"inlur"t doleTyNe ) = ou"xt )seta"&) 				cest.fault
	Vueue Exsrc.dault
	Vueue			}	}		nction sedomManip(,cloweion f,lgums,ncel(back, igno jdn{ 		re CoFlaot st ey de aedgaay|Es		trgs =nflao(lgums );			r i fragnt &, fat ?,lscript),lha;Script),lleTy,hrum		lei 0,
		len tocloweion fength,
		leiNoCle; o= ln1 ],
		lues  =ngums[ ] =,
		lues IsFction(  =oisFction( sllues  )		re CoWhac b becle; Nes  fragnt &see aygmtexnstenck aed, s"lWhbKie		v( calue;
IsFction(   d				( ln> )  e :eof elvueue =noutring" && e
				!pport f.eck aCle; o elreck aed.st( malues  ) {
{
		ioturn trcloweion fech e{
nction( e ]ex of{
				/r siself tocloweion feeqe ]ex of{;	/// ( !flue;
IsFction(  {
		if		trgs[ ] = =nlues .ll( Exuhilse]ex o,eself.html()n{			}
}		
edomManip(,self,lgums,ncel(back, igno jdn{	}


l{;	}}			v( ca? ) 		i fragnt & sebue dFragnt &(xgums,ncloweion f[ ] =.ownerDument.hoplse ),,cloweion f,ligno jdn{	}

fat ?osefragnt &.nat ?Cle d;				 ( !ffragnt &.cle dNeNasength > = 1 ) ) 				 fragnt & sefat ?;			
		// AdRuquint eierwildew ntextna  ( celt-derts& in igno jdnem.gts frto invoaehe lenel(back			 ( !ffat ?o doigno jdn{ 		i	iscript);= uery g.map(,getA( Exfragnt &	o"script"n{,erabled"Scriptn{			}
ha;Script) Exscript)ength >		so	//Eae ine n triginalxfragnt & furep elntst itemso	//Ea esreado(fep elfat ?obeceuse itgm beend,upso	//Eabeg"  cmptnedgibcorctly podoicerxnstesitseBn s(j(#8070).		}}r ( ; i++ leni++ ) {
		if		deNa =rfragnt &
		if		 ( cai = ouiNoCle; o{
		if			deNa =ruery g.nle; (lleTy,hue, 	tie, l);		if			 GeKeephrin tieces e-onlo; descript);r ( aat iet ltoreBn s
	//	 =( !fha;Script) 
 								/ Adpport: IEAndrd tr<=4.0nly
	, Pha (omJS ,nly
								 Sush( pply( n_,eaay|Esiky)erow adoon ancit & WhbKie			pupuuery g.merg)Exscript),lgetA( ExleTy,h"script"n{ );				/
				}
					}
nel(back.ll( Excloweion f[ ], releTy,hi );		} e		///=( !fha;Script) 
 				
edoc Exscript)[xscript)ength >n1 ] =.ownerDument.h;				// SuReenled"ascript)
pupuuery g.map(,script),lt ltor Scriptl);						 SuElueseBu ec( u led"escript); sefir thrumentIsoinse: n s
	//	r ( i in1;0	 < leha;Script)i++ ) {
		if			deNa =rscript)[xi=];				/
 ( !frscriptTe =est( madeNa.:eof
 do""s) 
								!da oPrioeaccess(lleTy,h"globalElue"l) 
								uery g.ntexnst Exrum	xdeNa 
 
 								i ( !fdeTy.srco e madeNa.:eof
 do""s).toLgw( se();
  ! "stmodud""t
 								i/ AdOptns alxAJAXldapedd ncy,lbutewot berunescript); ( t yepresied						i/ ( cauery gn_elueUr?  Ev!deNa.noModud" {
		io		//		uery gn_elueUr?!fdeTy.src,
		io		//			den e:pmeNa.non e  b.meNa.getAribute v( "non e" )
								
,xdoc 
		pu					e
				//	use {
				pu			DOMElueExdeNa.:t
	CtextNo.suace( !ftean pScript	o"" ),lleTy,hrum );		} 			e
			//e
			/}		} e
}

	

	sot =n trcloweion f		}		nction set me telem ),lseltoroo,tkeepDa on) 		ir i deTy				deNas =mseltoroo ?luery g.neln( (rseltoroo,tem )n{ 	mem )		lei 0,
		sor ( ; i ExdeNa eldeNas[++ ]
)  doll ?i++ ) {
		if ( !f!keepDa on EvdeTyodeType < = 1 ) {
					uery gnean pDa oelgetA( ExleTyn{ );			}				 ( !fdeTyorset &Nes  ) 					 ( !fkeepDa on Ev sAerhed =eldeNa 
 
 					/setGlobalElueExgetA( ExleTy,h"script"n{ );				}		} deTyorset &Nes etume tCle dcadeNa 
;
}

	

	sot =n trem.n		}		uery g.crtend{
			htmlPrineln( :inction( slhtml {
		ioturn trhtml;	}}				nlo; :inction( slem ),lda oAndEvt.hs	udeepDa oAndEvt.hs {
		ior i ixlm, srcement &s,lNasaement &s,		} cle; o= em.nocle; Nes (tie, l),		} inPageanu sAerhed =elem )n{
	
		 GeFixE 11mle;g thissues	if ( !f!pport f.noCle; Cck aedg e maem.nodeType < = 1 )  doem.nodeType < = 1 )1l) 
						!uery g.isXMLDumelum )n{ ) 		so	//EaWhaesed w Sizzd" h s nl reperf pmtn e etas f)3;tp:/s://jsperf.ntm/getl( -vs-sizzd"/2			}Nasaement &s segetA( Excle; o);				srcement &s segetA( Exem )n{
	
		/r ( i in1;0xlm =nsrcement &sength,
i++ leni++ ) {
		if		fixInlurelsrcement &s[ ], reNasaement &s[ i = {			}
e
}

		///EaCopy e elevt (s lm top eltriginalx poe elcle; 	if ( !fda oAndEvt.hs {
		io/ ( !fNaepDa oAndEvt.hs {
		io		srcement &s sesrcement &s  dogetA( Exem )n{
				}Nasaement &s seNasaement &s  dogetA( Excle; o);					/r ( i in1;0xlm =nsrcement &sength,
i++ leni++ ) {
		if			cle; CopyEvt (elsrcement &s[ ], reNasaement &s[ i = {			}
/}		} euse {
				pucle; CopyEvt (elem )x nle; o);				e
}

		///EaPresirvelscriptielueseBn s  isr, E			Nasaement &s segetA( Excle; 	o"script"n{
		/ ( !fNasaement &sength,
n> 0n{ 		i	isetGlobalElueExNasaement &s, !inPagea e getA( Exem ),h"script"n{ );			
		// AdRurn couhelnlo; deset	ioturn trclo; ;	}}				nln pDa o:inction( slem )s {
		ior i da o,xem )x :eofo	i	iscialal = uery g.cvt.hascialal,		} i 0,
		soor ( ; i Exem,  elem )s[++ ]
)  dExdefined" 
++ ) {
		if	 ( caacceptDa oelum )n{ ) 					i=( !f!fca oncoum )[era oPrioecxpando ] ) ) 		i 			 ( !fda o.cvt.h);{
					/}}r ( ; ke < s"lda o.cvt.h);{
					/}}/=( !fscialal[ :eof ]
) 		io		//		uery gncvt.hatume telem ),lieof );		if			// SuThis is  esht fcu(i reaid t uery gncvt.hatume t's;ov( head						//	use {
				pu				uery g.t me tEvt (elem ),l:eofopda o.halins {;	o	}
			e
				//	
			//e
	if			 Gepport: IEConime <=35n1 45+						//vAssignudefined" 
 esreado(feusg"  cel r ,eseeoDa o#t me t						um )[era oPrioecxpando ] Exdefined" 
			//	
			/ ( caem.n[era oUss,.cxpando ] ) {
	if			 Gepport: IEConime <=35n1 45+						//vAssignudefined" 
 esreado(feusg"  cel r ,eseeoDa o#t me t						um )[era oUss,.cxpando ] Exdefined" 
			//	
			
	}

	}}	)l);		uery g.nn.prtend{
			detaes:mnction( elseltoroo ) 				t =n trtume teluhilseseltoroo,tie, l);		}				reme t:inction( slseltoroo ) 				t =n trtume teluhilseseltorool);		}				xt ):pnction( ellues  ) 
			t =n traccess(luhilsenction( ellues  ) 
			}t =n trvueue =noudefined" 
?
pupuuery g.xt )(orhill)
:				muhilecty i()ech e{
nction( e{
					fe ( !fkhiledeType < = 1 )  dokhiledeType < = 1 ))  dokhiledeType < = 1 9
) 		io		//khilept
	CtextNo =nlues ;				/
				}
	 );			
,ull, tolues ,egument )sength,
 );		}				appedd:inction( s{
		ifturn parumManip(,uhilsegument )s,inction( slem ) {
		if	 ( cakhiledeType < = 1 )  dokhiledeType < = 1 ))  dokhiledeType < = 1 9
) 		io		r i targetn( manipulaon sTargeteluhilseem )n{
				}uarget.appeddCle dcaem )n{
				}		
	l{;	}}				prepedd:inction( s{
		ifturn parumManip(,uhilsegument )s,inction( slem ) {
		if	 ( cakhiledeType < = 1 )  dokhiledeType < = 1 ))  dokhiledeType < = 1 9
) 		io		r i targetn( manipulaon sTargeteluhilseem )n{
				}uarget.inse: Bal reelem ),l:arget.nat ?Cle dn{
				}		
	l{;	}}				bal re:inction( s{
		ifturn parumManip(,uhilsegument )s,inction( slem ) {
		if	 ( cakhilerset &Nes  ) 						khilerset &Nes .inse: Bal reelem ),l:hill)
				}		
	l{;	}}				afr t:inction( s{
		ifturn parumManip(,uhilsegument )s,inction( slem ) {
		if	 ( cakhilerset &Nes  ) 						khilerset &Nes .inse: Bal reelem ),l:hil.nt
	Sie-g an)
				}		
	l{;	}}				cty i:inction( s{
		ifr i em )		le i 0,
		soor ( ; i Exem,  elshil[ + ]
)  doll ?i++ ) {
		if	 ( caem.nodeType < = 1 ) {
							 SuPcuvt (imumerygletk)
pupuuery g.ean pDa oelgetA( Exem ),llse ) ) );				// SuRemo op ey tumainn"  deNas
				um )ept
	CtextNo =n"";				e
}

		//turn truhil
		}				nlo; :inction( slda oAndEvt.hs	udeepDa oAndEvt.hs {
		ioda oAndEvt.hs =fda oAndEvt.hs =doll ? ?alse ) :fda oAndEvt.hs;			NaepDa oAndEvt.hs =udeepDa oAndEvt.hs =doll ? ?ada oAndEvt.hs :udeepDa oAndEvt.hs;		//turn truhil.map(,nction( e{
					turn eluery g.nle; (luhilseda oAndEvt.hs	udeepDa oAndEvt.hs {;		
	l{;	}}				html:pnction( ellues  ) 
			t =n traccess(luhilsenction( ellues  ) 
			}r i em ) elshil[ 0 ]
 do{},					i 0,
		lelen touhil.ngth >		so	/ ( !flue;
 = oudefined" 
 eaem.nodeType < = 1 ) {
						turn elem.nomnrDoHTML;		} e		/// Copeeviflrram betcs  a sht fcu(ia sejt aluse inrDoHTML	if	 ( cakeof elvueue =noutring" && e !rnoInrDohtml.st( malues  ) 
						!wrapMap[ !frtagNe ).ec( (rlues  )  [];o""	o"" ] )[ ] =.toLgw( se();
 ] ) {
	if		lues  =nuery g.htmlPrineln( sllues  )		re			kryg		io		/r ( ; i++ leni++ ) {
		if				um ) elshil[ + ]
 do{}
			//	// SuRemo opel.gts  deNasia sepcuvt (imumerygletk)
pupuf	 ( caem.nodeType < = 1 ) {
			pu				uery g.ean pDa oelgetA( Exem ),llse ) ) );		if				um )omnrDoHTML =nlues ;				/
/	
			//e
	if			um ) el0					// SuIfeusg"  mnrDoHTML row ado beexceptns opu ine elfel(back mbtsod			}
	 cchesoele|{ 						
		///=( !fem ) {
		if	muhilecty i()eappeddsllues  )					e
}

,ull, tolues ,egument )sength,
 );		}				suace( With:inction( s{
		ifr i igno jdn=o;
		
// AdMcs  kheecnginvs,nsuace(g"  ched deseigno jdnctext )
el.gts  th the lldew ntextna	ifturn parumManip(,uhilsegument )s,inction( slem ) {
		if	r i rset & =akhilerset &Nes 		so	/ ( !fuery g.inray|Eseuhilse]gno jdn{ < 0n{ 		i	i	uery g.ean pDa oelgetA( Exrhill)
);		if	 ( !frset & {
			pu		rset &.suace( Cle dcaem ),l:hill)
				
					
		// AdF rc  nel(back invoceBn s
	/},ligno jdn{	}
}	)l);		uery g.ch e{
			appeddTo: "appedd"			orepeddTo: "orepedd"			inse: Bal re: "bal re"			inse: Afr t:i"afr t"			suace( A( :i"suace( With"
),enction( sele, optriginalx{
		iuery gnfn[ame ==] nunction( elseltoroo ) 				r i em )s,		} tur =t;
,			pinse:  =nuery gmaseltoroo ),				ntst =oinse: ength >n1 ]		le i 0,
		soor ( ; i ir<=lntsti++ ) {
		if	em )s = in1==lntst ?a:hill:akhilenle; (lurue {;	o	}uery gmainse: [ + ]
)[ptriginalx]slem )s {		so	//Eapport: IEAndrd tr<=4.0nly
	, Pha (omJS ,nly
					 Su.gete)obeceuse sh( pply( n_,eaay|Esiky)erow adoon ancit & WhbKie			psh( pply( netur, em )s.gete)o);		f
		//turn elkhilerh( Siack!ftur {	}
};	el);	r sitnumdespx =nnew RegExp(n"^("s+apnum + ")(?!px)[a-z%]+$"	o"i" )
		r sigetStylss nunction( elem ) ) {
	if Copport: IE 11<=11nly
	, Firefoof<=30j(#15098, #14150)			 SuIEerow adoon em.gts freateBudgibepopup(
// SuFFomea ile ( row adoon fre ==em.gts frt roughe"dault
	View.getCompuBudStyls"			r i viewo= em.noownerDument.h.dault
	View
	
		 ( ca!viewo do!view.op netg) 					viewo= wdow.l;		f
		//turn elview.getCompuBudStylscaem )n{
		}
		r siswap nunction( elem )x optns s,ncel(backn) 		ir i tur, le, o	//o di=e{}
			 SuRememberep elo dilues sopa seinse:  e lldew e; ssor ( ; me ==ibeoptns sg) 				o d[ame ==] nuem.nostyls[ame ==];			em.nostyls[ame ==] nuoptns s[ame ==];		
	sot = tocel(back.ll( Exem )n{
	
	 SuReve:  e llo dilues ssor ( ; me ==ibeoptns sg) 				em.nostyls[ame ==] nuo d[ame ==];	

	sot =n trtur		}
		ur i rboxStyls =nnew RegExp(ncssExpand.join( "|" ),l"i" )
		

(,nction( e{
			m GeEc( u g anbot) pixelPosiBn s & boxSizg aReliled"aet( srtuquint  nly e; olayout
	 Susoee eye juec( u edgatlp elre ==tlme  popavel hrasented mpilutaon f.		nction secompuBuStylsTt( s() {
	if CoThis is  esg alets opwerteedi reec( u e itg nly e;c 	if ( !f!div ) 
			}t =n t;		f
		//ntexnsts,.styls.cssTt )
= "posiBn s:absolu e;left:-11111px;width:60px;"s+			}"mgumin-top:1px;padNg" :0;bhrder:0";			dioestyls.cssTt )
=			}"posiBn s:tulaoive;dabplay:block;bhx-sizg" :bhrder-bhx;ov( flow:scrol(;"s+			}"mgumin:auto;bhrder:1px;padNg" :1px;"s+			}"width:60%;top:1%";			dument.hement &.appeddCle dcantexnsts, ).appeddCle dcadiv )
	
		r i divStyls =nwdow.l.getCompuBudStylscadiv )
		psixelPosiBn sVal = divStyls.topo! "st1%";	
	//Eapport: IEAndrd tr4.0n-r4.3nly
	, Firefoof<=3n-r44	//tuliled"MguminLeftVal = rndatPixelMeares s( divStyls.mguminLeft ) = ou12;	
	//Eapport: IEAndrd tr4.0n-r4.3nly
	, Safarir<=9.1n1 ]0.1,liOSr<=7.0n-r9.3
	//Eapime stylss cime backnth thperc exngeilues sopuvt   tougthe lynshouldn't			dioestyls.right
= "60%"
		psixelBoxStylssVal = rndatPixelMeares s( divStyls.right
) = ou36;	
	//Eapport: IEIEe9n1 ]1nly
				 EaDetmctemissuat: g thofentextna dlmensn fthr ( bhx-sizg" :bhrder-bhx=em.gts f			boxSizg aReliled"Val = rndatPixelMeares s( divStyls.width
) = ou36;	
	//Eapport: IEIEe9nly
				 EaDetmcteov( flow:scrol(lscrewdossha(gh-3699)
		 Gepport: IEConime <=64
// SuDot begetning aedgen stzo unafftors  eft aWidth
(gh-4029)
		dioestyls.posiBn s
= "absolu e"
		pscrol(boxSiz"Val = rndatPixelMeares s( div. eft aWidth
/ 3 
 = ou12;	
	/dument.hement &.tume tCle dcantexnsts, );	
	//EaNl, ify e eldiv soeitewouldn'tebleltor da the lemumerygand
	//Eaitewh ? waso b  a signue aygmck asdalready
perf pmtd
e/div doll ?i	

	sonction setndatPixelMeares s( meares  ) 
			t =n trMath.tndat!frseseFloao(lmeares  ) {;	}}			r i rixelPosiBn sVal, boxSizg aReliled"Val, scrol(boxSiz"Val, sixelBoxStylssVal,	//tuliled"TrDlmensn ftVal, tuliled"MguminLeftVal,	//ntexnsts, = dument.h.eateBuement &( "div" ),			div dodument.h.eateBuement &( "div" )		re CoFinish chr podoilimi edg(nesebrows( ) environgts f		 ( !f!divestyls {
		ioturn t;}

		m GeSport: IE 11<=9n1 ]1nly
			 GeStyls ofenlo; deel.gts  afftors sourc  el.gts  nlo; de(#8908)		dioestyls.backgtndatClip nu"ntextna-bhx"
		dioecle; Nes (tie, l)estyls.backgtndatClip nu""
		pport f.ean rCle; Styls =ndioestyls.backgtndatClip n=nu"ntextna-bhx"
	
	uery g.crtend{
sport f,
		ioboxSizg aReliled":inction( s{
		if	compuBuStylsTt( s();				turn elboxSizg aReliled"Val;			
,		psixelBoxStylss:inction( s{
		if	compuBuStylsTt( s();				turn elsixelBoxStylssVal;			
,		psixelPosiBn s:inction( s{
		if	compuBuStylsTt( s();				turn elsixelPosiBn sVal;			
,		ptuliled"MguminLeft:inction( s{
		if	compuBuStylsTt( s();				turn eltuliled"MguminLeftVal;			
,		pscrol(boxSiz":inction( s{
		if	compuBuStylsTt( s();				turn elscrol(boxSiz"Val;			
,	
	//Eapport: IEIEe9n1 ]1+, Edge 15n1 18+			 SuIE/Edge missuat:  `getCompuBudStyls`o(fepled"aw adoth thwidth/height
e} Suse& in CSS ile ( ` eft a*` pm rties (jsuat:  ntrctlyglues s.		r SuBehavior inEIEe9nis me masubt ( rocelt-nnews, vy sn fth&aitepass (
// Susime vy sn fthoflkhis et( ; mcs  res  t ye remcs  itepasshe lre!	//tuliled"TrDlmensn ft:inction( s{
		if	r i taed",tie,tieCle d,ltrStyls;so	/ ( !ftuliled"TrDlmensn ftVal =doll ? {
		if	muled"adodument.h.eateBuement &( "tled""t

				}u, = dument.h.eateBuement &( "tr"t

				}u,Cle dndodument.h.eateBuement &( "div" )		ref	muled".styls.cssTt )
= "posiBn s:absolu e;left:-11111px"
				}u,.styls.height
= "1px"
				}u,Cle d.styls.height
= "9px"
	
			/dument.hement &		pu		.appeddCle dcauled"a)		pu		.appeddCle dcaura)		pu		.appeddCle dcaurCle dn{
					}u,Styls =nwdow.l.getCompuBudStylscatrt

				}tuliled"TrDlmensn ftVal =frseseI &( u,Styls.height
) > 3
	
			/dument.hement &.tume tCle dcauled"a)					e
}
	turn eltuliled"TrDlmensn ftVal;		f
	}} )		} );
		s	nction securCSSelem )x le, opcompuBudn) 		ir i width,eminWidth,emaxWidth,etur,	
	//Eapport: IEFirefoof51+			 SuReingevg anrtyls bal reacompuBudnsimeh.l	// Adfixes  bemssueoth thgettn"  wniz  lues sso/ Ad sederhed ==em.gts f			styls =nem.nostyls
	
	compuBudn=acompuBudn dogetStylssExem )n{
	
	 SugetPm rtieyVueue ifrteedtdgl r:
	 Su  .css('neln( ') (IEe9nly
	, #12537)
	 Su  .css('--cultomPm rtiey) (#3144)		 ( cacompuBudn) 		iot = tocompuBud.getPm rtieyVueue; me ==)  []compuBud[ame ==];	
	/ ( !ftut n=nu"&& e ! sAerhed =elem )n{ ) 
			}t = =nuery g.stylscaem ), me ==);		f
		////vA ibute v  poe el"awesime hacknbyaDe beEdwards"	////vAndrd trBrows( rturn eshperc exngeil resime vues so
// Rebut widthgseemt  pobeltuliledylsixels.		r SuThis is  gciasyge leCSSOM draf( ecia:
		 Getp:/s://draf(s.csswg. cg/cssom/#s solved-lues sso/ ( !f!pport f.sixelBoxStylss()  ( tnumdespx.st( matur )
 ( tboxStylsest( made ==) ) 		so	//EaRememberep eloriginalxlues sso/	widthg=nrtyls.width					minWidthg=nrtyls.minWidth					maxWidthg=nrtyls.maxWidth		so	//EaPute the lenew lues s  pogetnaacompuBudnlues  out
			styls.minWidthg=nrtyls.maxWidthg=nrtyls.widthg=ntur		puot = tocompuBud.width		so	//EaReve:  e llcnginvdxlues sso/	rtyls.widthg=nwidth					styls.minWidthg=nminWidth					rtyls.maxWidthg=nmaxWidth		}

	

	sot =n trtur = oudefined" 
?
	if Copport: IE 11<=9n1 ]1nly
				 Ea 11turn eshzIex oflues  as celt-deger.			tur +u"&&:			tur		}			nction seaddGetHookIfcantediBn sFnophookFnn{ 		re CoDined"pe inhookopwe'll mnk agonep elfat ?oruneithit'(jsuas poteedtd.sot =n tr
			get:inction( s{
		if	 ( cacoediBn sFn(
 
 							 CoHook t yeteedtdg(or it'(jt yepitblinml pouse itgdu;
if// Re remissg
	adapedd ncy),rtume t it.			//cel r lkhileget
		//	turn e;		} e		/// CoHook teedtd;irefined" itgsoee aygp elreort fost( iifrt yeec( u edgagcia.
}
	turn el(lkhilegetg=nhookFnn{pply( n uhilsegument )s )
				}
};	e		ur i cssPrinexss nu[ "Webkit"	o"Moz"	o"ms" =,
	cty iStyls =ndument.h.eateBuement &( "div" ).styls			veddorPrors =e{}
		 AdRurn coa veddor-prinexsl pm rtiey  ( defined" 	nction seveddorProrNe )Exde ==) 		re CoCck ail reveddor prinexsl me =r	ir i capNe )i=eme =[ ] =.toUppe se();
 +eme =.sli( 0,1 ),			i 0,cssPrinexss.ngth >		soile ( ( i-- ) 
			ne )i=ecssPrinexss[ + ]
+ capNe );so/ ( !fme ==ibecty iStyls {
					turn elne );so/}	}}	)		 SuRurn coa poxtnaial
	-mappnd uery g.essPrors  reveddor prinexsl pm rtiey	nction sefinalProrNe )Exde ==) 			r i finalx= uery g.essPrors[ame ==]  []veddorPrors[ame ==];	
	 ( !ffanalx{
		i/turn ellanal;}

	/ ( !fme ==ibecty iStyls {
				turn elne );so}sot =n trveddorPrors[ame ==] =nleddorProrNe )Exde ==)  b.me );s}		ur isre Copwappled"aif dabplayiifrt nelorostartdoth thuled"re Coexcept "tled"",l"tled"-cell"optrl"tled"-captns "		 Copeevt s nl redabplayilues s3;tp:/s://del c rti.mozilla. cg/en-US/dums/CSS/dabplaysotdabplayswap nu/^(nese|tled"(?!-c[ea]).+)/,	ercultomPm r nu/^--/,	eessSh.l =e{ posiBn s: "absolu e", visieility: "hidd n",edabplay: "block"t),	eessN pmtlTransf pm = 				l rn( Spe(g" : "0"				fontWeight: "400"		}
		nction set aPosiBnveNumber( _em ), lues ,esubtract=) 		re CoAey tulaoive (+/-) lues s ha opalready
beenre Con pmtlizedgatlp ifrpot-d		r i tches s =eressNum.ec( (rlues  );sot =n trtches s ?
	if CoGuard  gciasygdefined" 
"subtract",ee.g.,gen stud toasodoeessHooksso/Math.max0,0, tches s[ 2=] - !fsubtract= b.0=) ) + catches s[ 3=]  []"px"l)
:			lues ;	}		nction seboxMocelAdjt amt (elem ),ldlmensn f, box,iifBhrderBox,istylssopcompuBudValx{
		ir i i =ndimensn f n=nu"width" ?,1 :,
		let )ra 0,
		lecel onco0
	
	 SuAdjt amt ( mapot yeblenecessa E		 ( !fboofn=nu(iifBhrderBox ?,"bhrder&&:u"ntextna" {
{
		ioturn tr0i	

	son ( ; i++ le4i++ += 2 ) 				r SuBot) boofmocelsoexcluNa mguminso/ ( !fboofn=nu"mgumin"&) 				ecel on+= uery g.esselem ),lboof+ncssExpand[ ], reue, 	tstylss );		f
		////vIflrragetgn s  th thalntextna-bhx,lrre juseekg
	a"padNg" "  ( "bhrder&& ( "mgumin"so/ ( !f!ifBhrderBox ) 		so	//EadddupadNg" 			ecel on+= uery g.esselem ),l"padNg" " +ncssExpand[ ], reue, 	tstylss );	so	//EaF ( "bhrder&& ( "mgumin",eadd bhrder				 ( !fboof! "stpadNg" " 
 				
edel on+= uery g.esselem ),l"bhrder&&+ncssExpand[ ],  +u"Width"reue, 	tstylss );	so	//EaBuygsth ? keep trackhoflitg e lrwis;
if/	use {
				put )ra += uery g.esselem ),l"bhrder&&+ncssExpand[ ],  +u"Width"reue, 	tstylss );			f
		////vIflrragetgn s  th thalbhrder-bhx=(ntextna +upadNg"  +ubhrder),lrre juseekg
	a"ntextna" or	////v"padNg" "  ( "mgumin"so/	use {
		so	//EaF ( "ntextna",esubtract=padNg" 			e ( !fboofn=nu"ntextna" {
				
edel on-= uery g.esselem ),l"padNg" " +ncssExpand[ ], reue, 	tstylss );		} e		/// CoF ( "ntextna"  ( "padNg" ",esubtract=bhrder				 ( !fboof! "stmgumin"&) 				eedel on-= uery g.esselem ),l"bhrder&&+ncssExpand[ ],  +u"Width"reue, 	tstylss );			f
	}

	

	so GeAccou & fureposiBnvelntextna-bhxlscrol( gurn( gen sttuque aedgbpoproveng
	acompuBudVal
/ ( !f!ifBhrderBox  ( compuBudValx>= 0n{ 		so/ Ad eft aWidth/ eft aHeight
is  etndatudnsumhofentextna,=padNg" ,lscrol( gurn( opa sebhrder			//vAssumg"  mndegerlscrol( gurn( opsubtract=kheotue(ia setndat down

edel on+= Math.max0,0, Math.ceile				um )[e" eft a&&+ndimensn f[ ] =.toUppe se();
 +edimensn f.sli( 0,1 )=] -	if	compuBudValx-			ecel on-			et )ra -			e0.5		////vIfl eft aWidth/ eft aHeight
is unknown,l:h stwhac b bed r rmed" ntextna-bhxlscrol( gurn( 
	//Eae in beexpli(io zeroi reaid t NaNa(gh-3964)			)=)  b.0i	

	soturn parel o;	}		nction seg aWidthOrHeightelem ),ldlmensn f, t )ra ) 		re CoStart th thcompuBudnstyls	ir i stylss nugetStylssExem )n{,	
	//EaTreaid t f rcn"  poreflow,g nly fehesoboxSizg aviflrrateediio (gh-4322).		r SuFcs  ntextna-bhxlt =i? rrakt weit'(jteedtdg rekt wee elurueglues .	ioboxSizg aNeedtdg=f!pport f.boxSizg aReliled"()  b.t )ra,			ifBhrderBox = boxSizg aNeedtdg
					uery g.esselem ),l"bhxSizg a"oplse ),,stylss )fn=nu"bhrder-bhx",
		lues IsBhrderBox = ifBhrderBox,	
		r n tocurCSSelem )x dlmensn f, stylss )o	//oeft aPm r nu" eft a&&+ndimensn f[ ] =.toUppe se();
 +edimensn f.sli( 0,1 );		m GeSport: IEFirefoof<=54
	 SuRurn coa ntefndatn"  den-sixelnlues  oi feignuigno tn e, as cppm rrtely.	i ( !ftnumdespx.st( mavalx{
{
		if ( !f!t )ra ) 					turn elval;		f
	}	r n to"auto"i	

	s	m GeSport: IE 119n1 ]1nly
			 Gee in eft aWidth/ eft aHeight
fureen stbhxlsizg avis untuliled".		 GeInEthoseom ses,re lentmpuBudnlues  m bebeluru aedg pobelbhrder-bhx.	i ( !f(f!pport f.boxSizg aReliled"()  Ev sBhrderBox ||
	if Copport: IE 1110n1 ]1+, Edge 15n1 18+			 SuIE/Edge missuat:  `getCompuBudStyls`o(fepled"aw adoth thwidth/height
e} Suse& in CSS ile ( ` eft a*` pm rties (jsuat:  ntrctlyglues s.		r SuI-derts&g aly, s"lsime m sesE 119nn'est besufn tolm top is isss .	io!pport f.tuliled"TrDlmensn ft()  EvdeTyNe )Exel ),l"tr"t
 ||
	if CoFel(pbacknton eft aWidth/ eft aHeight
en stvueue ifr"auto"		r SuThis happedthr ( inled" em.gts frth thnoeexpli(io settn"  (gh-3571)	}	r n t=to"auto" ||
	if Copport: IEAndrd tr<=4.1n-r4.3nly
				//vAaso u in eft aWidth/ eft aHeight
furemissuat:  da tled" dlmensn fth(gh-3602)	}	!rseseFloao(lvalx{
 Evuery g.esselem ),l"dabplay"oplse ),,stylss )fn=nu" tled""l) 
		
// AdMcs  ses  kheoel.gts  is visie ( ( coentortd
e/em.nogetClit &Rtors()ength > 
 					ifBhrderBox = uery g.esselem ),l"bhxSizg a"oplse ),,stylss )fn=nu"bhrder-bhx";	
	//EaWn s  availaed",t eft aWidth/ eft aHeight
cppm ximeBu bhrdertbhxldlmensn ft.
	//EaWn s  t yeavailaed" (e.g.,gSVG)seassentountuliled" bhx-sizg" pa seinderpr":he l
	//Eareingevudnlues  as centextna bhxldlmensn f.
		lues IsBhrderBox = oeft aPm r itrem.n		// ( !flue;
IsBhrderBox ) 			}	r n toum )[eoeft aPm r ]		}

	

	so/EaN pmtlizeu"&&a seauto
	r n torseseFloao(lvalx{
 b.0i	
	 SuAdjt a furep elel.gts '(jboofmocel
	turn el(lvalx+	ioboxMocelAdjt amt (e				um )		le dlmensn f,			et )ra  do(rifBhrderBox ?,"bhrder&&:u"ntextna" {,		}	r n;
IsBhrderBox,				rtylss,	so	//EaProventre lenurntNohcompuBudnsizeu ketuque alscrol( gurn( gcalculaon s (gh-3589)
			r n
	})	/) + "px"
	}		uery g.crtend{
		
//Eadddus"lstyls pm rtiey hookthr ( ov( reng
	ae eldault
	
//Eabehavior (fegettn"  a sesettn"  alstyls pm rtiey	eessHooks: 				ope(gty: 			}	get:inction( slem )x ntmpuBudn) 		io		 ( cacompuBudn) 			io		//EaWhashould
alwaysogetnaanumberpbacknlm toope(gty	io		/r i tur tocurCSSelem )x "ope(gty"t

				}ot =n trtur n=nu"&&?,"1&&:utur		puo/	
			
	}

	}},	
	 DeDot beautomeBicas poadd "px"l poe ese sitbliny-unitnsshapm rties (
/essNumb t:i		io"animeBn( In( eBn( Cou &"3;ue, 				"ntlumdCou &"3;ue, 				"fillOpe(gty"3;ue, 				"flexGw a"3;ue, 				"flexShrink"3;ue, 				"fontWeight"3;ue, 				"grenAeta"3;ue, 				"grenCtlumd"3;ue, 				"grenCtlumdEnd"3;ue, 				"grenCtlumdStart"3;ue, 				"grenR a"3;ue, 				"grenR aEnd"3;ue, 				"grenR aStart"3;ue, 				"led"Height"3;ue, 				"ope(gty"3;ue, 				"hrder&3;ue, 				"hrphans&3;ue, 				"wid ad&3;ue, 				"zIex o&3;ue, 				"zoom&3;ue, 	}},	
	 Dedddus"lpm rties (jwhoseome =r yourthshl pofix bal re
} Suse& g thoregettn"  e elr n;

/essPrors:o{},	
} SuGet a sesetgp elrtyls pm rtiey  seaaDOM Nes 
	rtyls:inction( slem )x le, oplues ,et )ra ) 		re	 DeDot besetgstylss onept )
aed mpigts  deNas	if ( !f!tm )n doem.nodeType < = 1 3n doem.nodeType < = 1 8o do!em.nostyls ) 
			}t =n t;		f
		// AdMcs  ses  khatlrre jutorkn"  wh the llright
le, 
	/r situr, :eofophooks,				origNe )i=ece )lse();xde ==)		le isCultomPm r nurcultomPm rest( made ==),				rtyls =nem.nostyls
	
	/ AdMcs  ses  khatlrre jutorkn"  wh the llright
le, .aWhadon't			 Adwanye reqry g e elr n;
eithit
is  eCSS cultom pm rtiey	e} Susin e e lynare us( -fined" .so/ ( !f!ifCultomPm r ) 
			}ne )i=efinalProrNe )ExorigNe )i);		f
		////vGetsphook furep elprinexsl vy sn f,l:h stunprinexsl vy sn f	//hookth= uery g.essHooks[ame ==]  []uery g.essHooks[aorigNe )i
		
// AdCck aiiflrre jusettn"  alr n;

// ( !flue;
 = oudefined" 
) 
			}:eof
= keof elvueue;	so	//EaConve:  "+="  ( "-="u ketulaoive number(j(#7345)				 ( !fte < = 1 tring" && e !ftut neressNum.ec( (rlues  ) )
 ( tet[ ] =
) 		io		r es  =ngdjt aCSSelem )x le, optur {	}
o		//EaFexss bug #9237
o		/:eof
= "number";		} e		/// CoMcs  ses  khatlll ? aed NaNalues s set  besetg(#7116)				 ( !fvueue =nlll ?  []vue;
 = oulues  ) 
			}	turn e;		} e		/// CoIfnaanumberpwasepass dus",eadd p elunit (except l remerxnsteCSS pm rties ()
			//vThe ifCultomPm r mnk agm bebeltume tdodoeuery gr4.0nwh stwha nly auto-appedd
			//v"px"l poa few hardcod"dglues s.		r	 ( !fte < = 1 tnumber"& e ! sCultomPm r ) 
			}	r es  +=ntur
 ( tet[ 3=]  [](]uery g.essNumb t[aorigNe )i
&?,"&&:u"px"l);		} e		/// Cobackgtndat-*irrors afftorloriginalxcle; '(jlues sso/	 ( !f!pport f.ean rCle; Styls  ( vueue =nout"& e le, .]ex oOf(,"backgtndat" )fn=nu0n{ 		i	i	styls[ame ==] nu" tn sit";		} e		/// CoIfnaahook waseproventlopu ine atplues ,e e lrwis;ejt alsetgp elrcialer.der n;

//	 ( !f!hookth do!(,"t a&&doehookth)  d					!fvueue =ehookt.set(lem ), lues ,et )ra ) ) = oudefined" 
) 
		io		 ( ca sCultomPm r ) 
			}		rtyls.setPm rtiey( le, oplues l)
				
	use {
				pu	styls[ame ==] nulues ;				/					
		//	use {
		so	//EaIfnaahook waseproventlegetni lenon-ntmpuBudnlues  lm top er

//	 ( !fhookth e "g a&&doehookth
						!ftut nehookt.getelem )x lse ),,t )ra ) ) = oudefined" 
) 
		io		t =n trtur		pu e		/// CoOe lrwis;ejt algetni lelues  lm top elrtyls objtor				turn elstyls[ame ==];			
	}},	
	ess:inction( slem )x le, opt )ra,,stylss )f				r i val, numophooks,				origNe )i=ece )lse();xde ==)		le isCultomPm r nurcultomPm rest( made ==)
	
	/ AdMcs  ses  khatlrre jutorkn"  wh the llright
le, .aWhadon't			 Adwanye remocify e elr n;
eithit
is  eCSS cultom pm rtiey	e} Susin e e lynare us( -fined" .so/ ( !f!ifCultomPm r ) 
			}ne )i=efinalProrNe )ExorigNe )i);		f
		////vTry prinexsl me = l ll aedgbpop elunprinexsl me =	//hookth= uery g.essHooks[ame ==]  []uery g.essHooks[aorigNe )i
		
// AdIfnaahook waseproventlegetni lentmpuBudnlues  lm top er

// ( !fhookth e "g a&&doehookth) 			}	r n tohookt.getelem )x ue, 	tt )ra );		f
		////vOe lrwis;,eitha way  pogetni lentmpuBudnlues  t,i asopu ine at
// ( !flue = oudefined" 
) 			}	r n tocurCSSelem )x le, opstylss );		f
		////vConve:  "n pmtl"l pontmpuBudnlues 
// ( !flue = ou"n pmtl"l e le, odoeessN pmtlTransf pm ) 			}	r n tocssN pmtlTransf pm[ame ==];			
	
	/ AdMcs  num siceithf rc tootoaequaller.r waseproventleaed r n lookthnum sic
// ( !ft )ra 0nout"& b.t )ra ) 
			}num torseseFloao(lvalx{;				turn elt )ra 0nouurueg doisFini v( num )&?,num  b.0=:lval;		f
	
		turn elval;		}	)l);		uery g.ch e{
[ "height",l"width" ],enction( se_ix dlmensn fx{
		iuery gnessHooks[adlmensn fx]
= 				get:inction( slem )x ntmpuBud,.t )ra ) 
			} ( cacompuBudn) 			io		//vCerxnsteem.gts fre beha opdlmensn fxinfoviflrrainvisie ynshowee em	io		//vbut it
mu ?oha opaenurntNohdabplayirtyls khatlrould
beninet	io		t =n trtdabplayswapest( mauery g.esselem ),l"dabplay" ) )
 (		io		//Eapport: IESafarir8+						//vTled" ntlumdsodoeSafarirha opnon-zeroi eft aWidth
& zero						//vgetBndatn" Clit &Rtor().widthgunnsshadabplayiifrcnginvd.	io		//Eapport: IE 11<=11nly
		io		//EaRunnn"  getBndatn" Clit &Rtor  seaadabcoentortd deNa	io		//EainEIEerow ado beerror.	io		/!f!tm )ogetClit &Rtors()ength >  do!em.nogetBndatn" Clit &Rtor().widthg) 					ma	swapslem )x nssSh.l,inction( s{
		if	io		t =n trg aWidthOrHeightelem ),ldlmensn f, t )ra )
				}o}} ) :				ma	g aWidthOrHeightelem ),ldlmensn f, t )ra )
				e
}

,		ioset:inction( slem )x lues ,et )ra ) 				/r i tches s,	i	i	stylss nugetStylssExem )n{,	
	/////vOnly readpstylss.posiBn s
 ( kheost( ihas cenhtn e  pofail
	/////vtreaid t f rcn"  poreflow.	io		scrol(boxSiz"Buggyg=f!pport f.scrol(boxSiz"() 
							stylss.posiBn s
t=to"absolu e",	
	/////vTreaid t f rcn"  poreflow,g nly fehesoboxSizg aviflrrateediio (gh-3991)		pu	boxSizg aNeedtdg=fscrol(boxSiz"Buggyg b.t )ra,					ifBhrderBox = boxSizg aNeedtdg
							uery g.esselem ),l"bhxSizg a"oplse ),,stylss )fn=nu"bhrder-bhx",
				subtract==et )ra 					maboxMocelAdjt amt (e							um )		le 	e dlmensn f,			e		et )ra,			e		eisBhrderBox,							stylss						) :				ma0;	so	//EaAccou & fureuntuliled" bhrder-bhx=dlmensn fthbpocomparg thofft a*l pontmpuBudnadd
			//vfakn"  pontextna-bhxl pogetnbhrderta sepadNg"  (gh-3699)
			 ( ca sBhrderBox  ( scrol(boxSiz"Buggyg{ 		i	i	subtract=-= Math.ceile						um )[e" eft a&&+ndimensn f[ ] =.toUppe se();
 +edimensn f.sli( 0,1 )=] -	if			rseseFloao(lstylss[adlmensn fx]
) -	if			boxMocelAdjt amt (elem ),ldlmensn f, "bhrder&oplse ),,stylss )f-	if			0.5					)		pu e		/// CoConve:   kepixelsvifllues  adjt amt ( ifrteedtd
			 ( casubtract= e !ftches s =eressNum.ec( (rlues  ) ) 
						catches s[ 3=]  []"px"l)
! "stpx"t
 							em.nostyls[adlmensn fx]
= lues ;				/lues  =nuery g.esselem ),ldlmensn fx{		pu e		///turn els aPosiBnveNumber( em ), lues ,esubtract=)
				}
};	el);		uery g.essHooks.mguminLeft =eaddGetHookIfcapport f.tuliled"MguminLeft,sonction sslem )x ntmpuBudn) 		io ( cacompuBudn) 		io	turn el(lrseseFloao(lcurCSSelem )x "mguminLeft" ) )
 d					em.nogetBndatn" Clit &Rtor().leftf-	if			swapslem )x { mguminLeft:i0 },inction( s{
		if	io	turn elem.nogetBndatn" Clit &Rtor().left
				}o}a)		pu	) + "px"
	}

	

	)
		 AdT ese hookthare us(dgbpoanimeBei reecpa sepc rties (
uery g.ch e{
			mgumin:o""	
	padNg" :o""	
	bhrder:u"Width"
),enction( seprinex,esufnixx{
		iuery gnessHooks[aprinex + sufnixx]
= 				ecpa s:pnction( ellues  ) 
			ir i i =n
		leleecpa sedi=e{},	
	/////vAssumes  esg aleanumberp ( t yealstrg" 			e	rsehs =ukeof elvueue =noutring" &&?glues .bpli&( " "l)
:
[ vueue ]
	
		/r ( i i++ le4i++ ) {
		if		ecpa sed[aprinex + cssExpand[ ],  +usufnixx]
=	if			rsetl[ + ]
 dorsetl[ + - 2=]  dorsetl[ 0=];				e		///turn elecpa sed
				}
};		i ( !fprinex ! "stmgumin"&) 				uery gnessHooks[aprinex + sufnixx].setg=fs aPosiBnveNumber;		}	)l);		uery g.nn.prtend{
			ess:inction( slle, oplues l) 
			t =n traccess(luhilsenction( elem )x le, oplues  ) 
			ir i stylssopngt		lelemap nu{},					i 0,
		so	/ ( !fray|E.isray|Esede ==) ) 		i	i	stylss nugetStylssExem )n{
				}ngti=eme =.ngth >		so	//r ( ; i++ leneni++ ) {
		if			map[ me =[ + ]
] =nuery g.esselem ),lme =[ + ]oplse ),,stylss );				/			io		t =n trmap;				e		///turn ellue;
 = oudefined" 
?
pupuuery g.stylscaem ), me =oplues  ) :
pupuuery g.esselem ),lme = );			
,ule, oplues ,egument )sength,
 >,1 );		}	)l);			nction seTwee elem )x optns s,npc r,eend,eeasg
	a{
		iturn elneweTwee .pc to:eof.ini elem )x optns s,npc r,eend,eeasg
	a{
	}	uery g.Twee  =nTwee ;		Twee .pc to:eof
= 			nterinuoroo:nTwee 			init:inction( slem )x optns s,npc r,eend,eeasg
	,lunit {
		ifuhilecl,  elem );	ifuhilepm r nupm r;	ifuhileeasg
	a=eeasg
	a []uery g.easg
	._dault
	;	ifuhileoptns sgnuoptns s;	ifuhilestart =okhiledew =okhilecur();			uhileendi=eend;			uhileunit =lunit  [](]uery g.essNumb t[apm r 
&?,"&&:u"px"l);		),	eeut:inction( s{
		ifr i hookth= Twee .pc pHooks[auhilepm r ];		//turn trhookth e hookt.get
?
puphookt.getelrhill)
:				Twee .pc pHooks._dault
	.getelrhill);		),	erus:inction( shperc ex ) 				r i ee()d,
puphookth= Twee .pc pHooks[auhilepm r ];		// ( cakhileoptns s.du eBn( 
) 
			}:hileposa=eeasedi=euery g.easg
	[auhileeasg
	a]e					perc ex,akhileoptns s.du eBn( 
* perc ex,a0, 1,akhileoptns s.du eBn( 
			)		pu	use {
				p:hileposa=eeasedi=eperc ex;		f
	}	khiledew =ocakhileendi- uhilestart )
* easedi+ uhilestart;		// ( cakhileoptns s.step
) 
			}:hileoptns s.step.ll( Exuhil.em ),l:hil.now,g:hill)
			}				 ( !fhookth e hookt.se& {
			puhookt.set(l:hill)
			}use {
				pTwee .pc pHooks._dault
	.set(l:hill)
			}	//turn truhil
		}	}
		Twee .pc to:eof.ini .pc to:eof
= Twee .pc to:eof
		Twee .pc pHooks
= 			_dault
	: 				get:inction( sltwee  ) 
			ir i rest
	;		/// Coe in  pm rtiey  sekheoel.gts  dictly powh sti iifrt yeaaDOM el.gts ,	/// Coureen stp er
iifrt atchesg anrtyls pm rtiey khatlt,i as.		r	 ( !ftwee .em.nodeType < ! 1 )  d					twee .em.n[ftwee .pm r 
& doll ?  e :wee .em.nostyls[atwee .pm r 
&=doll ? {
		if	mturn truwee .em.n[ftwee .pm r 
		pu e		/// CoPassg
	aabecty ilstrg"  as ce3rsepare =n( g re.essewh ? wutomeBicas p	/// Coaot ty n  pseseFloaota sefel(back  poa strg"   ( kheopseseofails.		r	/Eapimple vues s such as "10px"lare psesedg poFloao;		r	/Eacompl oflues s such as "c teBe(1rad)"lare turn t toas-is.
}
	tust
	 =nuery g.esseluwee .em.n,ftwee .pm r	o"" );		/// CoEty ilstrg" s,ull, todefined" 
a se"auto" areaconve: edg po0.
}
	turn el!tust
	  []tust
	 ==to"auto" ?.0=:lrest
	;			
,		pset:inction( sltwee  ) 
		/// Coe instep
hook fureback compat.	/// Coe inessHookeithitshe lre.	/// Coe inostyls ithavailaed" a seuse slas"lpm rties (jwh s  availaed".		r	 ( !fuery g.nx.step[atwee .pm r 
&{ 		i	i	uery g.nx.step[atwee .pm r 
sltwee  )		pu euse {
 ( !ftwee .em.nodeType < = 1 )  e !						uery g.essHooks[auwee .pm r 
& d						:wee .em.nostyls[afinalProrNe )Exuwee .pm r ) 
& doll ? )&{ 		i	i	uery g.stylscauwee .em.n,ftwee .pm r	otwee .dew +otwee .unit {		pu euse {
{					twee .em.n[ftwee .pm r 
&=otwee .dew;			f
	}

	

	}
		 Adpport: IE 11<=9nly
		 CoPanicebad toappm hed  popettn"  e g" sd sedabcoentortd deNas	Twee .pc pHooks.scrol(T r nuTwee .pc pHooks.scrol(Left =e{		set:inction( sltwee  ) 
	r	 ( !ftwee .em.nodeType <  e :wee .em.norset &Nes  ) 					twee .em.n[ftwee .pm r 
&=otwee .dew;			
	

	}
		uery g.easg
	 =e{		led"a :inction( slpl) 
			t =n trp;		),	eswg" :onction( slpl) 
			t =n tr0.5n1 Math.cosslpl* Math.PIl) / 2;		),	e_dault
	: "swg" "	}
		uery g.fx
= Twee .pc to:eof.ini 
		 AdBack compat <1.8 prtensn fxpot-d	uery g.nx.step =e{}
				ur is	fxNow,ginProgress,	irfx:eofs nu/^(?:toggle|show|hide)$/,	errunenu/queueHooks$/
		nction seted =ud"() {	i ( !finProgress ) 
	r	 ( !fdument.h.hidd n = 1 lse )  e wdow.l.tuque aAnimeBn( Fre ==) 			/	wiow.l.tuque aAnimeBn( Fre =(eted =ud"l)
			}use {
				pwiow.l.setTimeourelsed =ud",fuery g.nx.indervalx{;			e		//uery g.nx.Bick();		}	)		 AdAnimeBn( freateBudgsynchronous powh ? runesynchronous p	nction secateBuFxNow() {	iwiow.l.setTimeourelnction( s{
		iffxNow Exdefined" 
		} );sot =n trelnxNow ExDely.now() {
	}	
//vGen( eBeepare =n( s  pocateBuoa sta sard  nimeBn( 	nction seg nFx( :eofopincluNaWidthg) {	ir i which		lei 0,
		leaotrs
= 	 height: :eof
}
			 SuIflrraincluNa width,estep vueue ifr1  podpoall mssExpand vues so
/ Coue lrwis;estep vueue ifr2  popkip ov(  Left and Right
eincluNaWidthg=pincluNaWidthg?,1 :,
;son ( ; i++ le4i++ += 2 -pincluNaWidthg) {	i	which tocssExpand[ ], ;	leaotrs[stmgumin"&+ which 
&=oaotrs[stpadNg" " +nwhich 
&=o:eof
		e		/ ( !fincluNaWidthg) {	i	aotrs.ope(gty&=oaotrs.widthg=n:eof
		e		/t =n traotrs;	}		nction secateBuTwee ellues ,epm r	o nimeBn( g) {	ir i twee 				cloweion f =ocaAnimeBn( .twee ers[apm r 
& [];
&{.concao(lAnimeBn( .twee ers[a"*" ] )		leiex of0,
		length,
 =rcloweion f.ngth >		on ( ; i++ex oflenenh,
i++ex o ) {
		if ( !fsltwee  =rcloweion f[++ex of].ll( Ex nimeBn( ,epm r	olues  ) ) ) 
		/// CoWre jud nelwh the is pm rtiey	e}mturn truwee ;			
	

	}		nction sedault
	Prineln( slem.n,frrorsx optsg) {	ir i pm r	olues 	otoggleophooks,uo dfict,frrorTwee 	otue(oreDabplay,edabplay,			ifBhof0,"width" s"lpm rth do"height" s"lpm rt		leanim =okhilo	//orig nu{},			rtyls =nem.nostyls,			hidd n = em.nodeType <  e isHidd nWithinTreeExem )n{,	ioda oSh.l =era oPrioegetelem )x "fxshow" )		re CoQueue-pkippg
	aabimeBn( frhijack   elfxphooks
/ ( !f!opts.queue {
		ifhookth= uery g._queueHookselem )x "fx"n{
		/ ( !fhookt.unqueued&=doll ? {
		if	hookt.unqueued&=,
;so		o dfict tohookt.cty i.nat ;				hookt.cty i.nat  =inction( s{
		if	i ( !f!hookt.unqueued&{
		if			o dfict()
				
					

			}	//hookt.unqueued++;		//abim.always(,nction( e{
			m// CoEnses  kheocompl te halinsriifrcl( (dgbal reae is compl tes				abim.always(,nction( e{
			if	hookt.unqueued--;	if	i ( !f!uery g.queueelem )x "fx"n{ength > 
 							hookt.cty i.nat ()
				
					
 {;		
	l{;	}}	re CoDitmcteshow/hideaabimeBn( f	on ( ; pm r itrpm rth) 				r es  =nprors[apm r 
		pu ( !ftfx:eofs.st( malues  ) ) 				ecel te prors[apm r 
		pu	toggle =okoggle  []vue;
 ==to"koggle";		}  ( !flue;
 = ou!fhidd n ? "hide&&:u"show" )n) 			io		//vPritendg pobelhidd n ifop is isoa "show" add
			///vt er
iifrsth ? ca onlm toa stoppnd show/hide	if	i ( !fvueue =noutrhow"  e da oSh.l  e da oSh.l[apm r 
&= oudefined" 
) 
			}		hidd n = urue					// SuIgno joall ue lr de- r show/hideada o				
	use {
				pu	ntexins ;				/					
		//orig[apm r 
&= da oSh.l  e da oSh.l[apm r 
& []uery g.stylscaem ), pm r );			
	

	re CoBail out ifop is isoa de- r siky .hid ().hid ()		ororTwee g=f!uery g.isEty iObjtor(rpm rth);
/ ( !f!ororTwee g Evuery g.isEty iObjtor(rorig {
{
		ioturn t;	}}	re CoRestrgcte"ov( flow&&a se"dabplay" stylss durg anboxaabimeBn( f	o ( ca sBhx
 eaem.nodeType < = 1 ) {
		
if Copport: IE 11<=9n1 ]1, Edge 12 -p15
	//EaRecord  ll 3eov( flowraotrute vsobeceuse  11n'esrt yeinferep elsht fhand
	//Ealm toid nBicas p-lues deov( flowX&a seov( flowY&a seEdge jt almirrorsso/ Adp elov( flowX&vueue e lre.	//opts.ov( flowrnu[ rtyls.ov( flow, rtyls.ov( flowX, rtyls.ov( flowYi
		
// AdId nBifyeaadabplayi:eofopprin( re thold show/hideada o ov(  e leCSS m scade	iftue(oreDabplay&= da oSh.l  e da oSh.l.dabplay		pu ( !ftue(oreDabplay&=doll ? {
		if	tue(oreDabplay&= da oPrioegetelem )x "dabplay" )
			}	//dabplay&= uery g.esselem ),l"dabplay" )		pu ( !fdabplay&= ou"n d""l) {		}  ( !ftue(oreDabplay&) 				eedabplay&= tue(oreDabplay		pu euse {
{				// SuGet n d"ty ilvueue(s)gbpop"tyorarily f rcn"  visieility			//showHid (u[ em )n],tie, l);		if	tue(oreDabplay&= em.nostyls.dabplay  []tus(oreDabplay		pu /dabplay&= uery g.esselem ),l"dabplay" )		pu//showHid (u[ em )n] );			f
	}

	
////vAnimeBeiinled" em.gts frasodoled"-block	pu ( !fdabplay&= ou" tled""l []dabplay&= ou" tled"-block"t ( tee(oreDabplay&!doll ? {
		if	 ( !fuery g.esselem ),l"floao" )fn=nu"n d""l) {				// SuRee(oreep eloriginalxdabplayilues gatlp elendgof pes  show/hideaabimeBn( f	of	i ( !f!ororTwee g) 
			}		abim.de; (lnction( s{
		if	io	styls.dabplay = tue(oreDabplay		pu 		
 {;		
	}  ( !ftue(oreDabplay&=doll ? {
		if	m /dabplay&= styls.dabplay;		
	} 	tue(oreDabplay&= dabplay&= ou"n d""l?,"&&:udabplay;		
	} }				/						styls.dabplay = " tled"-block";			f
	}

	

		o ( caopts.ov( flowr{
		ifrtyls.ov( flow = "hidd n";	//abim.always(,nction( e{
			ifrtyls.ov( flow = opts.ov( flow[ 0=];				rtyls.ov( flowX = opts.ov( flow[ 1=];				rtyls.ov( flowY = opts.ov( flow[ 2=];			
l{;	}}	re CoImpl gts  show/hideaabimeBn( f	oororTwee g=flse );	on ( ; pm r itrorig {
		
if CoGen( el show/hideasurnp furep isoel.gts  animeBn( 		i ( !f!ororTwee g) 
			} ( !fda oSh.l {
		if	i ( !f"hidd n" itrda oSh.l {
		if	i	hidd n = da oSh.l.hidd n
				
					
 se {
				puda oSh.l =era oPrioeaccess(lem )x "fxshow"x { dabplay: tue(oreDabplay&} );			f
		m// CoS(oreehidd n/visie ( furepoggle so `.stop().poggle()`i"suvy ses"	//	 ( !ftoggle )
				puda oSh.l.hidd n =f!hidd n
				
		m// CoSh.l em.gts frbal reaanimeBn"  e em	//	 ( !fhidd n ) 		i	i	showHid (u[ em )n],tie, l);		if
		m// * esledt-dabaed" de-loop-ncti */
				abim.de; (lnction( s{
			m// * esledt-enaed" de-loop-ncti */
					//vThe fanalxstep otha "hide&& nimeBn( gisoactuas poheng
	ae element &		pu	 ( !f!hidd n ) 		i	i	/showHid (u[ em )n] );			f/						ra oPrioetume telem )x "fxshow" )						n ( ; pm r itrorig {
		i	i	/uery g.stylscaem ), pm roptrig[apm r 
&)
				
					
 {;		
		
if CoPer-pr rtiey surnp
ifororTwee g=fcateBuTwee elhidd n ? da oSh.l[apm r 
&:,
	epm r	o nim )		pu ( !f!; pm r itrda oSh.l {
) 				eca oSh.l[apm r 
&=frrorTwee estart;	//	 ( !fhidd n ) 		i	i	rrorTwee eendi=errorTwee estart;	//		rrorTwee estart&=,
;so		
	}

	

	}		nction serrorFeln( slrrorsx rcialalEasg
	a{
		ir i iex ox le, optasg
	,llues 	ohookt		re Coce )lse()x rcialalEasg
	aa seecpa seessHookepass	on ( ; +ex ofitrpm rth) 				ne )i=ece )lse();x+ex of)		pueasg
	 =ercialalEasg
	[ame ==];			r es  =nprors[a+ex of]		pu ( !fray|E.isray|Eselues  ) ) 				eeasg
	 =elues [ 1=];				r es  =nprors[a+ex of] =elues [ 0=];			
	
	/ ( !finx of= oune ==) 			/	prors[ame ==] =nlues ;				cel te prors[a+ex of]		pu
	
	/hookth= uery g.essHooks[ame ==]
		/ ( !fhookth e "ecpa s&&doehookth) 			}	r nue =ehookt.ecpa ssllues  )					cel te prors[ame ==];	
	/o/EaN t quite $.prtend,g:hillwot beov( write t,i ag
	 keys.		r	/EaReusg"  '+ex o'obeceuse werha opkheocorctlyg"me ="	//	n ( ; +ex ofitrlues  ) 
			}	 ( !f!; +ex ofitrpm rth) {
		i	i	/prors[a+ex of] =elues [ +ex of]		pui	/scialalEasg
	[a+ex of] =eeasg
	;				/					
		/
 se {
				prcialalEasg
	[ame ==] =eeasg
	;			
	

	}		nction seAnimeBn( caem ), pm rties (,eoptns sg) 			r i rest
	,			rtoppnd		leiex of0,
		length,
 =rAnimeBn( .prineln( sength,
		lecen( redi=euery g.Den( red()ealways(,nction( e{
			m// CoDot betches em )n the le:animeBedaseltoroo				cel te Bick.em );	if}n{,	ioBick =inction( s{
		if	 ( castoppnd {
		if	mturn trlse );	o	/					r i curntNoTime =inxNow  []cateBuFxNow(),	if	mtumaing
	 =eMath.max0,0,  nimeBn( estartTime +  nimeBn( edu eBn( 
- curntNoTime {,	
	/////vpport: IEAndrd tr2.3nly
				////vArchaic]caash bug wot beall a usl pouse `1 - !f0.5n b.0=)`j(#12497)		pu	p"ty = tumaing
	 /  nimeBn( edu eBn( 
 b.0,	if	mperc ex 1 ) -op"ty,					iex of0,
		lelength,
 =ranimeBn( .twee s.ngth >		so	/n ( ; i++ex oflenenh,
i++ex o ) {
		if		abimeBn( .twee s[++ex of].ru shperc ex );		if
		m//cen( red.noBifyWithcaem ), [x nimeBn( ,eperc ex,atumaing
	 ] );		/// CoIf e lre's me ma podp, yield
			 ( caperc ex < )  e ngth > 
 						t =n trtumaing
	
				
		m// CoIfop is was cel"ty il nimeBn( ,esyne esizeua fanalxprogress noBificeBn( 
			 ( !f!ngth > 
 						cen( red.noBifyWithcaem ), [x nimeBn( ,e1, 0=] );			f
		m// CoR solvehe le nimeBn( ga setuat:  itshconclusn f	//	cen( red.s solveWithcaem ), [x nimeBn( =] );			fturn trlse );	o	}		leanimaon f =ocen( red.promi();x				eem ): um )		le prors:ouery g.crtend{
	}, pm rties (=)		le opts:ouery g.crtend{
ue, 	t		i	i	scialalEasg
	:u{},					easg
	:uuery g.easg
	._dault
				f
,eoptns sg),				originalProrties (: pm rties (,				originalOptns s: optns s,				rtartTime:inxNow  []cateBuFxNow(),	if	du eBn( : optns sedu eBn( ,	if	twee s: [],	if	cateBuTwee :onction( slpc r,eend ) 
			}	r rltwee  =ruery g.Twee caem ), abimeBn( .opts,npc r,eend,		
	} 	abimeBn( .opts.rcialalEasg
	[apm r 
& []abimeBn( .opts.easg
	a{
	if		abimeBn( .twee s.pushsltwee  )		pu mturn truwee ;				}		le	rtop:onction( slgotoEnd ) 
			}	r rliex of0,
				
	}  SuIflrraareagog
	aeolp elendopwerwanye rerune ll kheoswee s		
	}  Suue lrwis;ewerpkip e is part		
	} ngth,
 =rgotoEnd ?ranimeBn( .twee s.ngth > :,
;soif	 ( castoppnd {
		if	m/turn truhil
				/						stoppnd = urue						n ( ; i++ex oflenenh,
i++ex o ) {
		if			abimeBn( .twee s[++ex of].ru sh1 );				/			io		 CoR solvehwh stwhaplayed p ella a fre =;uue lrwis;,atujtor					 ( cagotoEnd ) 
			}		cen( red.noBifyWithcaem ), [x nimeBn( ,e1, 0=] );			f/	cen( red.s solveWithcaem ), [x nimeBn( ,agotoEnd 
&)
				
	use {
				pu	cen( red.s jtorWithcaem ), [x nimeBn( ,agotoEnd 
&)
				
	
f	m/turn truhil
				}	if}n{,	ioprors =eanimeBn( .prors;		/rrorFeln( slrrorsx abimeBn( .opts.rcialalEasg
	 );		/n ( ; i++ex oflenenh,
i++ex o ) {
		iftust
	 =nAnimeBn( .prineln( s[++ex of].ll( Ex nimeBn( ,eem.n,frrorsx abimeBn( .opts )		pu ( !ftust
	 {
		if	 ( caisFction( sltust
	.stop )&{ 		i	i	uery g._queueHookselabimeBn( .em ), abimeBn( .opts.queue {.stop =	if	m/tust
	.stop.bind{
tust
	 {;	o	/					t =n trtust
	;			
	}}	reuery g.mapslrrorsx cateBuTwee 	o nimeBn( g);		i ( !fisFction( slabimeBn( .opts.rtart )
) {	i	abimeBn( .opts.rtart.ll( Exem ), abimeBn( l{;	}}	re CoAerhedrcl( backsnlm toopBn( f	oanimeBn( 		i.progressslabimeBn( .opts.progress )		p.de; (labimeBn( .opts.de; , abimeBn( .opts.compl te )		p.fail(labimeBn( .opts.fail )		p.always(,abimeBn( .opts.alwayso)
	
	uery g.nx.Bim( s
		uery g.crtend{
Bick,x				eem ): um )		le abim:x nimeBn( ,	le queue: abimeBn( .opts.queue
}o}a)		)
	
	t =n trabimeBn( 
	}		uery g.Animaon f =ouery g.crtend{
AnimeBn( ,e			mtwee ers:i		io"*":
[ nction( slpc r,elues  ) 
			ir i twee  =rkhilecateBuTwee elpc r,elues  );	o	/gdjt aCSSeluwee .em.n,fpc r,eressNum.ec( (rlues  ),ltwee  )		pu turn truwee ;			
 ]	}},	
	twee er:onction( slpc rsx cel(back {
		if ( !fisFction( slpm rth) {
		i	icel(back =nprors;	le prorsrnu[ "*" ];		/
 se {
				pprorsrnuprors.tches!ftnue tmlwhite {;		
		
ifr i pm r	
			iex of0,
		lelngth,
 =rprors.ngth >		so	n ( ; i++ex oflenenh,
i++ex o ) {
		if	pm r nupm rs[a+ex of]		pu	AnimeBn( .twee ers[apm r 
&=aAnimeBn( .twee ers[apm r 
& [];
		pu	AnimeBn( .twee ers[apm r 
.unshifo(lcel(back {;			
	}},		/rrineln( s:
[ dault
	Prineln(  =,
	/rrineln( :onction( slcel(backoppripend ) 
			 ( !fpripend ) 
				AnimeBn( .prineln( s.unshifo(lcel(back {;			
 se {
				pAnimeBn( .prineln( s.pushslcel(back {;			
	}}	)l);		uery g.rcind = nction( slrcindoptasg
	,lf g) {	ir i opt =ercitdg
	ukeof elrcind = ou"objtor"l?,uery g.crtend{
	}, rcind )
:
				compl te:lf g do!f g Eveasg
	a [
			isFction( slrcind )
 ( scindo
f	du eBn( : scindo
f	easg
	:uf g Eveasg
	a [veasg
	a e ! sFction( sleasg
	a{
 Eveasg
	}
};		i CoGoaeolp elend stat{
 ( fxaareaoff
	 ( !fuery g.nx.off ) 
			optedu eBn( 
0,
		so
 se {
				 ( !fte < eloptedu eBn( 
! 1 tnumber"&{
		if	 ( caoptedu eBn( 
doeuery g.nx.scindth) 			}		optedu eBn( 
0,uery g.nx.scindt[aoptedu eBn( 
];	
	/o	use {
				puoptedu eBn( 
0,uery g.nx.scindt._dault
	;	iff
	}

	

	so GeN pmtlizeuoptequeue - urue/defined" /ll ? -> "fx"	o ( caoptequeue =nlll ?  []optequeue =nouurueg) 
			optequeue = "fx";	}}	re CoQueueg
	}
opteo dndooptecompl te;	
	optecompl te =inction( s{
		if ( !fisFction( slopteo dn) {
		i	iopteo d.ll( Exuhill)
			}				 ( !foptequeue {
		i	iuery g.dequeueeluhilseoptequeue {;			
	}}
	
	t =n tropt;	}
		uery g.fn.prtend{
			fadeTo: nction( slrcindoptooptasg
	,lcel(back {
		
// CoSh.l anyfhidd n em.gts frafn(  se& g thope(gty& po0
m/turn truhil.neln( slisHidd nWithinTree&{.csssl"ope(gty", 0={.show()	so	//EaAnimeBei ree elr n;
ercialer.dso	/eend()eanimeBe{
	 ope(gty:  re}, rcindoptasg
	,lcel(back {;		),	eanimeBe:onction( slpc r,ercindoptasg
	,lcel(back { 				r i ety il=vuery g.isEty iObjtor(rpm r )		le opt ll =nuery g.scindslrcindoptasg
	,lcel(back {,	if	doAnimaon f =onction( e{
			m/////vOp( eBeeocoa ntpygof pm r soaper-pr rtiey easg
	awot bebellost			}	r rlanim =oAnimeBn( cauhilseuery g.crtend{
	}, pm r ),lopt ll {	}
o		//EaEty il nimeBn( soptrlnedissg ans solves immedtely
				// ( !ftty il []da oPrioegeteluhilse"nediss" )&{ 		i	i		abim.stop(tie, l);		if						

				doAnimaon f.nediss =ocoAnimaon f;		//turn trtty il []opt llequeue =noulse ) ?
pupuhileeaes!fdoAnimaon f )
:				uhilequeueelopt llequeue,fdoAnimaon f );		),	ertop:onction( sl:eofopean rQueue,fgotoEnd ) 
			r i stopQueue = nction( slhookth) 			}	r i stop =ehookt.stop					cel te hookt.stop					stop(tgotoEnd );			
;		// ( cake < elte < ! 1 tring" &&) 			}	gotoEnd =pean rQueue					ean rQueueg=n:eof
			/:eof
= defined" 
							 ( cacan rQueueg) 
			}:hilequeueelueof
 do"fx",];
&{
			}				turn truhil.eaes!fnction( s{
		if	r i dequeue = urue,					iex of0,te < ! oll ?  e :e < + "queueHooks",
				Bim( th= uery g.Bim( t,
				da o = da oPrioegeteluhill)
		if	 ( caiex of) 
			}	 ( !fda o[a+ex of]  e da o[++ex of].stop )&		i	i	/stopQueue!fda o[a+ex of] )
				
					
 se {
				pun ( ; +ex ofitrda o )&		i	i	/ ( !fda o[a+ex of]  e da o[++ex of].stop  ( trun.st( maiex of) {
		if	io	stopQueue!fda o[a+ex of] )
				
 }				/					}	so	/n ( ; iex of0,tim( t.nenh,
i++ex o--;f) 
			}	 ( !ftim( t[++ex of].cl,  e==rkhilg
							!fte < = lll ?  []tim( t[++ex of].queue =nouue < )n) 			io			tim( t[++ex of].abim.stop(tgotoEnd );						cequeue = lse );	o	/		tim( t.bplic);x+ex o,h1 );				/					}	so	//CoStart e lenexte the lequeue  ( kheola a step wast bef rc t.		r	/EaTim( thcurntNo powh ? c ll kheirocompl te cl( backs,nwhich		r	/Eawh ? cequeue but  nly  ( khepowereagotoEnd.		r	 ( !fcequeue  do!gotoEnd ) 
			}	uery g.dequeueeluhilseue < )
				}	if}n{;		),	enediss:onction( sl:eof ) 
	r	 ( !fte < ! 1 lse ) ) 
			}:eof
= keof
 do"fx"
							turn truhil.eaes!fnction( s{
		if	r i +ex o,
				da o = da oPrioegeteluhill),
				queue = da o[a:e < + "queue" =,
			/hookth= da o[a:e < + "queueHooks" =,
			/Bim( th= uery g.Bim( t,
				ngth,
 =rqueue ?rqueue.ngth > :,
;s		r	/EaEnaed" nedissg anflag  serriveBeeda o				da o.nediss =ourue					//EaEty ile lequeue first			}uery g.queueeluhilseue <,];
&{
			r	 ( !fhookth e hookt.stop )&		i	i	hookt.stop.ll( Exuhil,tie, l);		if
		m// / Look fureanyfacoive  nimeBn( sopa sefediss e em	//	n ( ; iex of0,tim( t.nenh,
i++ex o--;f) 
			}	 ( !ftim( t[++ex of].cl,  e==rkhilg
	]tim( t[++ex of].queue =nouue < )n{	io			tim( t[++ex of].abim.stop(tie, l);		if		tim( t.bplic);x+ex o,h1 );				/					}	so	//CoLook fureanyfabimeBn( fr the leo dnqueue a sefediss e em	//	n ( ; iex of0,0i++ex oflenenh,
i++ex o ) {
		if		 ( !fqueue[a+ex of]  e queue[a+ex of].nediss )n{	io			queue[a+ex of].nediss.ll( Exuhill)
				/					}	so	//CoTn troff nedissg anflag				cel te da o.nediss;	if}n{;		)	)l);		uery g.ch e{
[ "koggle",utrhow", "hide&&],enction( se_ix de ==) 			r i cssF 
0,uery g.nn[ame ==]
		uery g.nn[ame ==] = nction( slrcindoptasg
	,lcel(back { 				turn elscind = lll ?  []teof elrcind = ou"booan n" ?
pupcssF .applyExuhil,tgument )s )
:				uhileanimeBe{
g nFx( le, opie, l), rcindoptasg
	,lcel(back {;		);	el);		//vGen( eBeesht fcutthr ( cultom abimeBn( f	uery g.ch e{
			slideDown:
g nFx( "show" ),		slideUp:
g nFx( "hide&&),		slideToggle:
g nFx( "koggle"&),		fadeIn:
	 ope(gty: "show" },		fadeOut:
	 ope(gty: "hide&&},		fadeToggle:
	 ope(gty: "koggle"&}
),enction( sele, oppm rth) 			uery g.nn[ame ==] = nction( slrcindoptasg
	,lcel(back { 				turn eluhileanimeBe{
rrorsx rcindoptasg
	,lcel(back {;		);	el);		uery g.Bim( trnu[]
	uery g.nx.Bick =inction( s{
		ir i tim( 		lei 0,
		leBim( th= uery g.Bim( t;		/nxNow ExDely.now();		/n ( ; i++fletim( t.nenh,
i++ ) {
		iftim( f0,tim( t[ ], ;	
	//EaRun kheosim( fa sesafely reme tti iwh std nel(all ag anf ( crternalxreme al)	r	 ( !f!Bim( s)g
	]tim( t[++ 
&=d0,tim(  ) 
			}:im( t.bplic);x+--,h1 );			
	

		o ( ca!tim( t.nenh,
 ) 
			uery g.nx.stop();		)	ffxNow Exdefined" 
	}
		uery g.fx.tim( f0,nction( sl:im(  ) 
		uery g.Bim( t.pushsltim(  );
	uery g.nx.start();	}
		uery g.fx.indervalx= 13;
uery g.nx.start =inction( s{
		i ( !finProgress ) 
	r	turn t;	}}	reinProgress = urue			ted =ud"();	}
		uery g.fx.stop =enction( s{
		i nProgress = ll ?;	}
		uery g.fx.scindth=e{		sl a: 600,		fast:
200,	
	 DeDault
	 rcind	e_dault
	: 400	}
			 AdBad tooff o( kheoplug thby Cledt Helf( t,lwh thp rmessn f.
 Adhttps://web.archive.org/web/20100324014747/http://bleddsignals.com/+ex o.php/2009/07/jqry g-celay/	uery g.fn.celayf0,nction( sl:im(,uue < )n{	itime =iuery g.fx
?,uery g.nx.scindt[atime ]  []tim( :,tim(			:eof
= keof
 do"fx"
	
	turn eluhilequeueelueof,enction( selcrt,lhookth) 			}r i tim(out = wiow.l.setTimeourellcrt,ltim( );			hookt.stop =inction( s{
		if	wiow.l.can rTimeoureltim(out );			
;	f}n{;	}
			!fnction( s{
		ir i +eput = dument.h.cateBuEm.gts ( " tput" {,		}seltor = dument.h.cateBuEm.gts ( "seltor" {,		}opt =ereltor.appeddChild( dument.h.cateBuEm.gts ( "opBn( " )&{;		i tput.:eof
= "mnk abhx";	
	//vpport: IEAndrd tr<=4.3nly
			 GeDault
	 lues  lotoaemnk abhxashould
be "on"		sport f.enk aO 
0, tput.lue;
 = ou"";	
	//vpport: IE 11<=11nly
		i AdMt alaccessereltoredIex oe remcs  dault
	eoptns sgreltor		sport f.optSeltoredndooptereltored;	
	//vpport: IE 11<=11nly
		i AdAn +eput losesEitshlues gafn(  becomn"  poradio	i tput = dument.h.cateBuEm.gts ( " tput" {;	i tput.r nue =e"t";		 tput.:eof
= "radio";		pport f.tadioV nue =e tput.r nue ===e"t";	}n{();		ur i booaHook,	eattrHalins =ouery g.crpr.attrHalins
		uery g.fn.prtend{
			attr:inction( slle, oplues l) 
			t =n traccess(luhilseuery g.attr,ule, oplues ,egument )sength,
 >,1 );		},	
	tume tAttr:inction( slle,  { 				turn eluhileeaes!fnction( s{
		if	uery g.tume tAttr(luhilseme = );			
n{;		)	)l);		uery g.crtend{
			attr:inction( slem )x le, oplues  ) 
			r situr, hooks,				npe < =aem.nodeType <;	
	//EaDot beget/se& aotrute vsoonept ), mpigts  a seaotrute v deNas	if ( !fnpe < = 1 3n donpe < = 1 8n donpe < = 1 2 {
		if	tu=n t;		f
		// AdFel(back  popm r wh staotrute vsoas  t yepport f.dso	 ( cake < elem.nogetAotrute v ===e"defined" " {
		if	tu=n teuery g.pm rslem )x le, oplues  );		f
		// AdAotrute v hookthare d=n( med" 
bpop ell aerm se vy sn f	////vGrabllccessary hook  (  nelillfined" 	if ( !fnpe < ! 1 )  df!uery g.isXMLDocExem )n{ {
		if	hookt =ouery g.attrHooks[ame =.toL aerse();
 
& d					(ouery g.crpr.tches.booaest( made ==)
?,booaHook :,defined" 
)
			}				 ( !flue;
 = oudefined" 
) 
			} ( !fvueue =noull ? {
		if	muery g.tume tAttr(lem ),lme = );			}	turn e;		} e		/// ( !fhookth e "s a&&doehookth
						!ftut nehookt.set(lem ), lues ,ede ==) ) = oudefined" 
) 
			}	t =n trtur		pu e		///em.nosetAotrute vslle, oplues l+o"" );		}	t =n trlues ;			}				 ( !fhookth e "g a&&doehookth
	 !ftut nehookt.getelem )x de ==) ) = oull ? {
		if	tu=n trtur		pu}				tur =iuery g.fiow.attr(lem ),lme = );	
/o/EaN n-t,i ats  aotrute vsoturn elnl, torrat pmtlizeu pounfined" 	ift =n trtur n=ull ? ?udefined" 
:utur		p},	
	attrHooks:
				ke <: 			}	set:inction( slem )x lues  ) 
			}	 ( !f!pport f.tadioV nue  ( vueue =noutradio"g
							deTyNe )Exel ),l" tput" { )n{	io			r i val =aem.nolues ;				//em.nosetAotrute vsl"ke <"oplues l)
				
/ ( !flue {
		if	io	em.nolues  =elue
				
 }				/	t =n trlues ;				/					
		/
		},	
	tume tAttr:inction( slem )x lues  ) 
			r i le, o	/// f0,
				
	 AdAotrute v me =r e bentexas"lnon-HTML whitespe(eenhtractersso/	 Adhttps:// tml.rcia.whatwg.org/mt
	ipage/syneax. tml#aotrute vs-2so/	aotrNe =r oulues   ( vueue.tches!ftnue tmlwhite {;				 ( !faotrNe =r  eaem.nodeType < = 1 ) {
			i	whid" ( made ===faotrNe =r[++ ) ] { )n{	io		em.notume tAttrute vslle,  );			f
	}

		)	)l);		 AdHookthr ( booan n aotrute vs
booaHook =e{		set:inction( slem ), lues ,ede ==) 
	r	 ( !fvueue =noulse ) ) 
	so/	 AdReme ttbooan n aotrute vs wh stsetgpoulse )	if	uery g.tume tAttr(lem ),lme = );			
 se {
				pem.nosetAotrute vslle, opme = );			
	ift =n trme =;	

	}
		uery g.eaes!fuery g.crpr.tches.booaesource.tches!f/\w+/gl), nction( se_ix de ==) 			r i gett( f0,attrHalins[ame ==]  []uery g.fiow.attr;
	eattrHalins[ame ==] = nction( slem )x le, opisXML ) 
			r situr, halins		leln aerm seNe )i=eme =.toL aerse();
;				 ( !f!isXML ) 
			
	 AdAid t afxinfini v loopgbpop"tyorarily tume n"  e gs nction(  lm top elgett( 	if	halins =oattrHalins[an aerm seNe )i
		pu	attrHalins[an aerm seNe )i
 = tut;		}	t = =lgett( slem )x le, opisXML ) ! oll ? ?
pupun aerm seNe )i:
pupull ?;	pu	attrHalins[an aerm seNe )i
 = halins
			
	ift =n trtur		p};	el);				ur i rfumebaed" nu/^(?: tput|reltor|pt )area|te ton)$/i,	erclickaed" nu/^(?:a|area)$/i
		uery g.fn.prtend{
			pm r:inction( slle, oplues l) 
			t =n traccess(luhilseuery g.pc r,ele, oplues ,egument )sength,
 >,1 );		},	
	tume tPm r:inction( slle,  { 				turn eluhileeaes!fnction( s{
		if	cel te Bhil[euery g.pc rFix[ame ==]  []me ==];			
n{;		)	)l);		uery g.crtend{
			pm r:inction( slem )x le, oplues  ) 
			r situr, hooks,				npe < =aem.nodeType <;	
	//EaDot beget/se& pm rties (=onept ), mpigts  a seaotrute v deNas	if ( !fnpe < = 1 3n donpe < = 1 8n donpe < = 1 2 {
		if	tu=n t;		f
		// ( !fnpe < ! 1 )  df!uery g.isXMLDocExem )n{ {
				
	 AdFix]me ==a seaothedrhooks
/		ne )i=euery g.pc rFix[ame ==]  []me =;	if	hookt =ouery g.pc pHooks[ame ==];			
	
	/ ( !flue;
 = oudefined" 
) 
			} ( !fhookth e "s a&&doehookth
						!ftut nehookt.set(lem ), lues ,ede ==) ) = oudefined" 
) 
			}	t =n trtur		pu e		///t =n trelem.n[fme ==] =nlues l)
			}				 ( !fhookth e "g a&&doehookth
	 !ftut nehookt.getelem )x de ==) ) = oull ? {
		if	tu=n trtur		pu}				turn elem.n[ame ==];		},		/rr pHooks:
				kabIex o: 			}	get:inction( slem )n) 			io		 Copport: IE 11<=9n1 ]1nly
				////vem.nokabIex o1n'est bealwaysoturn eluhe			////vcorctlyglues lwh sti ihast bebee  crplicio poset			////vhttps://web.archive.org/web/20141116233347/http://fluidrr jtor.org/blog/2008/01/09/ge& g t-se& g t-a s-tume n" -kab+ex o-vues s-wh t-javascript/			////ve inpm rtieaotrute v turrievue(#12072)		pu	r i tab+ex o =iuery g.fiow.attr(lem ),l"tab+ex o" );		///	 ( cakab+ex o {
		if	m/turn trpseseIs ( kab+ex o, 10 );				/			io		 ( c	if	m/tfumebaed"est( maem.nodeTyNe )i)& d						rclickaed"est( maem.nodeTyNe )i)&
							em.nohref					{
		if	m/turn tr0;				/			io		turn tr-1;			f
	}

		),		/rr pFix:i		io"r (": "htmlF (",			"class": "classNe ="	/)	)l);		 Adpport: IE 11<=11nly
		/EaAccessg
	ap elseltoredIex oepm rtiey	/Eal rc she l bw ad( g rererciat se& g thseltored	/Ea sekheooptns 	 AdT e gett( fenses soa dault
	eoptns iifrseltored	/Eawh stitrabeoptgtndp	/Eaesledt rud"l"no-unus(d-crpressn fs"lillfabaed"d furep isocod"
 Susin e i interid( thsuch accessgs sgnoop
 ( !f!pport f.optSeltoredn) 
		uery g.pc pHooks.seltoredndo		ioget:inction( slem )n) 			io	 * esledt no-unus(d-crpressn fs:e" ef" */
				r i pset & =aem.norset &Nes ;			} ( !fpset & 
	 pset &orset &Nes  ) 						pset &orset &Nes .seltoredIex o;			f
	}
	turn elnl, 		pu},		pset:inction( slem )n) 			io	 * esledt no-unus(d-crpressn fs:e" ef" */
				r i pset & =aem.norset &Nes ;			} ( !fpset & ) 						pset &oseltoredIex o;		///	 ( capset &orset &Nes  ) 							pset &orset &Nes .seltoredIex o;			f/					
		/
		}
	}		uery g.ch e{
[
	"kabIex o",		"readOnly",		"maxLgth,
",		"cellSpe(g a"o		"cellPadNg" ",		"rowSpen"o		"colSpen"o		"us(Map"o		"fre =Bhrder&o		"coextnaEditaed""
],inction( s{
		iuery g.pc rFix[auhiletoL aerse();
 
&=ruhil
	el);				u//CoStrip=a seclowaps;ewhitespe(eeacchrdg
	aeolHTML rcia
///vhttps://infra.rcia.whatwg.org/#ringp-a s-clowaps;-ascii-whitespe(esonction slstrgpAndClowaps;(plues  ) 
			r sitokenr oulues .tches!ftnue tmlwhite {& [];
		puturn eluokenr.join( " "l);	}}	r	nction seg tClassslem )n) 			turn elem.nogetAotrute v  eaem.nogetAotrute vsl"class" {& []"";	}		nction seclassesToray|Eselues  ) 		i ( !fray|E.isray|Eselues  ) ) 				t =n trlues ;		}
	 ( cake < elvueue =noutring" &&) 				t =n trlues .tches!ftnue tmlwhite {& [];
		p}		turn el;
		}		uery g.fn.prtend{
			addClass:pnction( ellues  ) 
			r i classes,eem.n,fcur,fcurVues ,eclazzseu, fanalVues ,	/// f0,
;				 ( !fisFction( sllues  ) ) 				eturn eluhileeaes!fnction( s j {
		if	muery gExuhill).addClasssllues .ll( Exuhil,tu, g tClassslrhill)
) {		pu eu)
			}				classes =peaassesToray|Eselues  );				 ( !feaassesength > 
 					whid" ( macl,  e Bhil[e+ ) ] { )n{	io		curVues  =lgetClassslem )n);	io		cur =aem.nodeType < = 1 )  e ! " "l+lstrgpAndClowaps;(pcurVues  ) + " " );		///	 ( cacur ) 							j =,
;so				whid" ( maclazz =peaasses[eu ) ] { )n{	io		/	 ( cacur.+ex oOf! " "l+lclazz + " " ) < 0={n{	io		/		cur +=lclazz + " ";so				 }				/	}			
	}  SuOnly assggn ifodiffeet & treaid t unteedtdereex ng" .	io		/fanalVues  =ertrgpAndClowaps;(pcurl)
				
/ ( !fcurVues  ! 1 lanalVues  {
		if	io	em.nosetAotrute vsl"class", lanalVues  {
				
 }				/					
		/
				turn eluhil;		},	
	tume tClass:pnction( ellues  ) 
			r i classes,eem.n,fcur,fcurVues ,eclazzseu, fanalVues ,	/// f0,
;				 ( !fisFction( sllues  ) ) 				eturn eluhileeaes!fnction( s j {
		if	muery gExuhill).tume tClasssllues .ll( Exuhil,tu, g tClassslrhill)
) {		pu eu)
			}				 ( !f!gument )sength,
 ) 				eturn eluhileattr(l"class", ""u)
			}				classes =peaassesToray|Eselues  );				 ( !feaassesength > 
 					whid" ( macl,  e Bhil[e+ ) ] { )n{	io		curVues  =lgetClassslem )n);				////vT isoerpressn flill er
ir ( bett( fcompressneility (se  addClass)	io		cur =aem.nodeType < = 1 )  e ! " "l+lstrgpAndClowaps;(pcurVues  ) + " " );		///	 ( cacur ) 							j =,
;so				whid" ( maclazz =peaasses[eu ) ] { )n{		if	io	 AdReme tt*l( *titsta css							whid" ( cur.+ex oOf! " "l+lclazz + " " ) >r-1={n{	io		/		cur = cur.replac);x" "l+lclazz + " ", " "l);	}				 }				/	}			
	}  SuOnly assggn ifodiffeet & treaid t unteedtdereex ng" .	io		/fanalVues  =ertrgpAndClowaps;(pcurl)
				
/ ( !fcurVues  ! 1 lanalVues  {
		if	io	em.nosetAotrute vsl"class", lanalVues  {
				
 }				/					
		/
				turn eluhil;		},	
	koggleClass:pnction( ellues , stat{Vue {
		ifr siteof
= keof elvueue,	/// sVueidVues  =ete < = 1 tring" && []ray|E.isray|Eselues  );		// ( cake < elstat{Vue = ou"booan n"  e isVueidVues  ) 				eturn elstat{Vue ?luhileaddClasssllues  )
:luhiletume tClasssllues u)
			}				 ( !fisFction( sllues  ) ) 				eturn eluhileeaes!fnction( s i {
		if	muery gExuhill).koggleClassc	if	m/lues .ll( Exuhil,ti, g tClassslrhill), stat{Vue {,		
	} stat{Vue					{		pu eu)
			}				turn truhil.eaes!fnction( s{
		if	r i classNe =,ti, self, classNe =s
		if	 ( caisVueidVues  ) 					////vToggle +exividuue class me =r	///	  =,
;so			self =iuery gExuhill)
				/classNe =s =peaassesToray|Eselues  );						whid" ( maclassNe = =peaassNe =r[++ ) ] { )n{			
	}  SuCnk a ehedrclassNe = give 	ospe(eeseparerednlist			}		 ( caself.hasClassslclassNe = ) {
		if	io	self.tume tClassslclassNe = )
				
 }use {
				pu		self.addClassslclassNe = )
				
 }				/			io	//vToggle whoan class me =
	
 }use {
 ( !fvueue =noudefined" 
 []teof = ou"booan n" )n{	io		classNe = =pg tClassslrhill);	///	 ( caclassNe = ) {			
	}  SuS(oreeclassNe =  ( set			//	ra oPrioeseteluhilse"__classNe =__",lclassNe = )
				
			io		 CoIf e loel.gts  has ceclass me =ptrliflrr're pssd to`lse )`,	io		 Coth streme tte lowhoan classme =p(if e lre was e; , e le be ttsav toit).	io		 CoOe lrwis;ebrg anback whatuvy  was previous posav to(if anye g" ),	io		 Cofel(g anback eolp elety ilstrg"  i( t ysg anwas e(ored.		r	/ ( cakhilesetAotrute v )n{	io			thilesetAotrute vsl"class",			pu		classNe =  []vue;
 ==tolse ) ?
pupppp"&&:
puppppda oPrioegeteluhilse"__classNe =__" {& []""
puppp)
				/					}	if}n{;		),	
	hasClass: nction( slreltoroo ) 
			r i classNe =,tum )		le  f0,
;				classNe = =p" "l+lseltoroo + " ";so	whid" ( macl,  e Bhil[e+ ) ] { )n{	io	 ( !ftm.nodeType < = 1 )  e				/! " "l+lstrgpAndClowaps;(pg tClassslem )n) ) + " " ).+ex oOf! classNe = ) >r-1={n{	io		/turn trurue					
		/
				turn ellse );	o}	el);				ur i rturn el= /\r/g
		uery g.fn.prtend{
			vue:pnction( ellues  ) 
			r i hooks,utur, lues IsFction( 		le cl,  e Bhil[e0 ];		// ( ca!gument )sength,
 ) 				e ( !ftm.n={n{	io		hookt =ouery g.lueHooks[aem.noke < 
& d						uery g.lueHooks[aem.nodeTyNe )etoL aerse();
 
;		///	 ( cahookth
							"g a&&doehookth
							!ftut nehookt.getelem )x "lues "=) ) = oudefined" 					{n{	io		/turn trtur		pu /			io		tur =aem.nolues ;		io		 CoHalins most mpig slstrg anm sef	of	i ( !fke < eltur n=1 tring" &&) 			}		/turn trtur.replac);xrturn e, ""u)
				
			io		 CoHalins m sefjwh s  vueue ifrnl, /definptrlnumber
}		/turn trtur n=ull ? ?u"&&:utur		pu e		///t =n t
			}				lues IsFction(  =e sFction( sllues  );				turn truhil.eaes!fnction( s i {
		if	r i val
		if	 ( ca:hil.noType < ! 1 ) ) 
			}	t =n t		pu e		/// ( !fvueueIsFction(  ) 
			}	val =alues .ll( Exuhil,ti, uery gExuhill).vue() {		pu euse {
				puval =alues 		pu e		/////vTateBrnl, /defined" 
as]"";aconve: lnumbersl poring" 	/// ( !fvue&=doll ? {
		if	mval =a"";	
	
 }use {
 ( !fkeof elvue&= ou"number"&{
		if	mval +=a"";	
	
 }use {
 ( !fray|E.isray|Eselue ) {
		if	ival =auery g.mapslval,pnction( ellues  ) 
						t =n trlues  n=ull ? ?u"&&:ulues l+o""
				
	l);		if
		m//hookt =ouery g.lueHooks[auhilete < 
& douery g.lueHooks[auhiledeTyNe )etoL aerse();
 
;		/// CoIf se& t =n tsudefined" ,ofel(nback eolt pmtl se& g t	/// ( !f!hookt  df!( "s a&&doehookth{& []hookt.set(l:hil,lval,p"lues "=) = oudefined" 
) 
			}	uhilelues  =elue
				}	if}n{;		)	)l);		uery g.crtend{
			lueHooks:i		iooptns : 			}	get:inction( slem )n) 			io		r i val =auery g.fiow.attr(lem ),l"lues "=);
				t =n trlue ! oll ? ?
pupuival :			
	}  SuSport: IE 11<=10n1 ]1nly
				//  SuupBn( .textethw ad exceptns sg(#14686, #14858)		
	}  SuS(rip=a seclowaps;ewhitespe(e		
	}  Suhttps:// tml.rcia.whatwg.org/#ringp-a s-clowaps;-whitespe(e		
	} strgpAndClowaps;(puery g.Bextslem )n) )
				}	if},		}seltor: 			}	get:inction( slem )n) 		io		r i vals , upBn( ,ti,		
	} optns sg=aem.nooptns s,						iex of0,em.noseltoredIex o,		
	} on< =aem.note < = 1 treltor- d"",	if	m/lues sg=aon< ?oll ? : [],	if			maxg=aon< ?oiex of+,1 :,optns sength >		so	/	 ( caiex of< 0={n{	io		/ f0,max		so	/	}use {
				pu	ig=aon< ?oiex of:r0;				/			io		/CoLoopethw ughe ll kheoseltorednopBn( f	o		/n ( ; i++flemax	++ ) {
		if	} optns ndooptn( f[ ], ;	
	/	}  SuSport: IE 11<=9nly
				//  SuIE8-91n'est beupdeBeeseltorednafn(  n (merere& (#2551)			}		 ( ca(uupBn( .seltoredn []i = 1 +ex o {

		
pupppp//EaDot bet =n troptns sgthaotare dabaed"d trlineaadabaed"d tptgtndp	pupppp/!upBn( .dabaed"d 
									!f!upBn( .rset &Nes .dabaed"d  d						pp/!deTyNe )ExupBn( .rset &Nes , "opBgtndp"=) ) )n{		if	io	 AdGet kheoscialerc lues  lotokheooptns 		if	m/lues  =iuery gExoptns n).vue();		if	io	 AdWjud n beteedrabeaay|E lotoon< seltors							 ( !fon  {
		if	io		t =n trlues ;				//	}			
	} i AdMtlti-Seltorsoturn elabeaay|E		if	m/lues t.pushsllues l)
				
/}				/			io		t =n trlues l
				}				
	set:inction( slem )x lues  ) 
			}	r i optn( Sur, upBn( ,		
	} optns sg=aem.nooptns s,						lues sg=auery g.makeray|Eselues  ),			pu	ig=aoptns sength >		so	/	whid" ( i-- {
		if	} optns ndooptn( f[ ], ;	
	/	}  * esledt-dabaed" de-cond-assggn */
						 ( !foptn( .seltoredn=	if	m/	uery g.inray|Eseuery g.lueHooksooptns .geteloptns n)x lues s ) >r-1
puppp)
		if	io	optn( Sur = urue							}			
	}  * esledt-enaed" de-cond-assggn */
			/			io		/CoF rc  bw ad( sg pobeha opnteri ats  powh stnon-tchesn"  vueue ifrset			//i( !f!optn( Sur )
		if	ioem.noseltoredIex o = -1;			f
	
f	m/turn trlues l
				}
}

		)	)l);		 AdRadios=a secnk abhx s gett( /se&t( 	uery g.ch e{
[ "radio", "mnk abhx" ],inction( s{
		iuery g.lueHooks[auhil 
&=r{

	set:inction( slem )x lues  ) 
			} ( !fray|E.isray|Eselues  ) ) 				e/t =n trelem.n.enk aedi=euery g.inray|Eseuery gslem )n).vue()x lues  ) >r-1={
				}
}

		);	o ( ca!sport f.enk aO 
) 
			uery g.lueHooks[auhil 
.get = nction( slem ) ) 				eturn elem.nogetAotrute vsl"lues "=) = oull ? ?u"( " :aem.nolues ;			};	o}	el);				u AdRe=n teuery g lotoaotrute vs- nly  nclusn f	

sport f.fumebi ndo"( fumebi &&doewiow.l;		ur i rfumebMorph nu/^(?:fumebi fumeb|fumeboutblur)$/,	ertopPm rageBn( Cel(back =nnction( sle ) 				e.rtopPm rageBn( ({;		);		uery g.crtend{
uery g.cv ex,a			mtrigg( :onction( slcv ex,ada o,eem.n,f nlyHalinsrs )n{		ifr i +,fcur,ftmp, bubed"Teof,eonueof,ehalins	ercialal,ola aEm.gts 		le cv exPa,
 =r[ em )n []dument.h =,
			teof
= hasOwn.ll( Exev ex,a"ke <" )
?,ev exote < :xev ex,
			me =rpe(es
= hasOwn.ll( Exev ex,a"me =rpe(e" )
?,ev exome =rpe(e.bpli ( "." )
:l[ ;	
	/cur = la aEm.gts  = uty = cl,  e em )n []dument.h;	
	//EaDot bedo,ev ex(=onept )=a secligts  deNas	if ( !ftm.nodeType < = 1 3n dotm.nodeType < = 1 8 {
		if	tu=n t;		f
		///Eal meb/blur me phsg pofumebi /out;fenses lrr're t yefirn"  e em right t w	if ( !frfumebMorphest( ma:e < + uery g.cv ex.trigg( edn) {
		i	itu=n t;		f
		// ( !f:e <.+ex oOf! "." ) >r-1={n{		/// CoNe =rpe(ed trigg( ; cateBu poregexpe remches evt & te < doehalins()
			me =rpe(es
= :e <.bpli ( "." );
			teof
= me =rpe(es.shifo();
			me =rpe(es.soro();
		}
}
onueof
= :e <.+ex oOf! ":" ) < 0= e "( " +n:eof
		///EaCel(( fcan pssdlineaauery g.Evt & objtor, Objtor, otojt alcel"vt & te < ring" 	//"vt & =l"vt &[fuery g.crpalio 
&?	le cv ex&:
pupnewauery g.Evt &elueof,eke < elevt & = ou"objtor"l eaev ex );	
////vTaigg(  bitmask: &,1 lotonaoive halinsrs; &,2 lotouery g (alwaysourue)	//"vt &.isTaigg(  =f nlyHalinsrs ?,2 : 3;	//"vt &.me =rpe(e
= me =rpe(es.join( "." );
		"vt &.rme =rpe(e
= "vt &.me =rpe(e
?
pupnewaRegExp( "(^|\\.)" +nme =rpe(es.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
pupnl, 			///EaCan n uplp elev ex inem se it ifrbeg ans us(d
		"vt &.rust
	 =ndefined" 
			 ( ca!cv ex.targur )
		if	cv ex.targur e em );		f
		///EaClon  anyf ncomn"  da o a sepripend p elev exx cateBg
	ap elhalinsriargnlist			da o = da o n=ull ? ?	if	[lev ex ] :
pupuery g.makeray|Eseda o,e[lev ex ] );	
////vAll a rcialal,ev ex(= podraw outrid(op elled"s	ifrcialal,= uery g.cv ex.rcialal[a:e < 
& do{}
			 ( ca! nlyHalinsrs  ( scialal.trigg(   ( scialal.trigg( .applyExem.n,fda o )&=noulse ) ) 
	if	tu=n t;		f
		///EaD=n( med"lev ex pm rageBn(  ps,
 ineadva cs,eper W3C,ev ex(=scia (#9951)			 AdBubed" uplpo]dument.h,oth stpo]wiow.l; wches lotoaeglobal,ownerDument.h r i (#9724)			 ( ca! nlyHalinsrs  ( !scialal.noBubed"  e ! sWiow.lExem )n{ {
				
	bubed"Teof =ercialal.celegeBuTeof
 do:eof
			/ ( ca!rfumebMorphest( mabubed"Teof +uue < )n) 				e/cur = cur.rset &Nes ;			}	
f	mn ( ; i+curi+cur = cur.rset &Nes n) 				e/cv exPa,
.pushslcurl)
				
uty = curi
	u e		/////vOnly add]wiow.lliflrragotlpo]dument.h (e.g., t yeplas"lobj otodetheded DOM)			/ ( cauty =nou!ftm.noownerDument.h  []dument.h )n) 				e/cv exPa,
.pushsluty.dault
	View  []uty.rset &Wiow.l  []wiow.ll{
				}
}

	

	 AdFire halinsrsa sekheoev ex pa,

/	  =,
;so	whid" ( macur =aev exPa,
[e+ ) ] {  e !"vt &.isPm rageBn( Stoppnd()n) 				ela aEm.gts  = curi
	u ev exote < = ],>,1 ?
pupububed"Teof :
pupprcialal.b+exTeof
 do:eof
		/////vuery g halinsr	///halins =oc	if	m/da oPrioegetelcur,f"ev ex(" {& []Objtor.cateBu(oll ? {	if	m)[,ev exote < ] 
						da oPrioegetelcur,f"halins" );
			 ( cahalins {n{	io		halins.applyExcur,fda o )i
	u e		/////vNaoive halinsr	///halins =oonueof
 e cur[oonueof
];
			 ( cahalins  e halins.apply  e acceptDa ocacur ) ) 				e/cv ex.rust
	 =nhalins.applyExcur,fda o )i
	u f ( !ftv ex.rust
	 =noulse ) ) 
	if	e/cv ex.prev exDault
	()
				/					}	if}
u ev exote < = :eof
		///EaI( t body prev exed p eldault
	eaion( 	edo,it t w	if ( !f! nlyHalinsrs  ( !"vt &.isDault
	Priv exed({ {
				
	 ( ca(u!scialal._dault
	  d					scialal._dault
	.applyExev exPa,
.pop(),fda o )&=noulse ) ) 
						acceptDa ocaem )n{ {
				
	//EaCel(oaenaoive DOM methoda sekheotargur wh thkheose = me ==asekheoev ex.	io		 CoDot bedo,dault
	eaion( sa sewiow.l,gthao'fjwh s  global,r iiaed"frbe (#6170)
	u f ( !fonueof
 e  sFction( slem.n[ate < ] )  e ! sWiow.lExem )n{ {
				
	p//EaDot bet -trigg(  abeonFOOoev ex wh stwhac ll itshFOO({ method		
	p/uty = cl, [oonueof
];
						 ( !futy {
		if	io	em.n[oonueof
] =lnl, 		pu			}			
	}  / Priv exet -trigg( g thofhkheose = ev exx sin e rraalreadyabubed"toite be t		
	} uery g.cv ex.trigg( edn= :eof
		//u f ( !ftv ex.isPm rageBn( Stoppnd()n) 				e		ela aEm.gts .addEvt &Li ats( slueof,ertopPm rageBn( Cel(back )		pu			}			
	} em.n[ate < ]();		if	io ( !ftv ex.isPm rageBn( Stoppnd()n) 				e		ela aEm.gts .reme tEvt &Li ats( slueof,ertopPm rageBn( Cel(back )		pu			}			
	} uery g.cv ex.trigg( edn= defined" 
							 ( !futy {
		if	io	em.n[oonueof
] =luty
				
/}				/					}
}

	

	turn elev ex.rust
	;		),	
	 / Piggyback ocoa don ( cvt & tresimuleBu podiffeet & on 
///ve id  nly n ( `fumeb(s"l| out)`,ev ex(
	simuleBu:onction( sl:eofopem.n,fev ex ) 
			r i s =ouery g.crtend{
pupnewauery g.Evt &e)		le cv ex		le 
			}	ue <: :eofo
	u f sSimuleBud:ourue				}
}
);		ifuery g.cv ex.trigg( !ft,lnl, toem )n);	i
	
)l);		uery g.fn.prtend{
			mtrigg( :onction( sl:eofopda o )&		i	turn eluhileeaes!fnction( s{
		if	uery g.cv ex.trigg( !f:eofopda o,xuhill)
			}n{;		),	etrigg( Halinsr:onction( sl:eofopda o )&		i	r i sl,  e Bhil[e0 ];		e ( !ftm.n={n{	io	tu=n teuery g.cv ex.trigg( !f:eofopda o,xem.n,fie, l);		i
		)	)l);			 Adpport: IEFirefoxr<=44
 AdFirefoxrn'est beha opfumeb(s"l| out),ev ex(
 AdReleBud
Bickur -uhttps://bugzilla.mozilla.org/show_bug.cgi?id=687787
 A	 Adpport: IEChro = <=48 -u49, Saf ii1<=9.0n1 9.1
/Eal meb(s"l| out),ev ex(efirenafn(  n meb &,blur ev ex(,	/Eawhies i(=scia violeBn( 
- http://www.w3.org/TR/DOM-Lev l-3-Evt &s/#ev ex(-n mebev ex-ev ex-hrder
 AdReleBud
Bickur -uhttps://bugs.chro ium.org/p/chro ium/issues/dethil?id=449857
 ( !f!pport f.fumebi n{
		iuery g.ch e{
	 n meb: "fumebi &,,blur: "fumebout" ),enction( seorig, lax {
				
 CoAerhedra singns m p=n g thhalinsri sekheodument.h whid" so =on  wanysofumebi /fumebout	i	r i halinsri=onction( slcv ex {
		if	uery g.cv ex.simuleBu( lax,,ev exotargur,euery g.cv ex.laxslcv ex {
);			
;		//uery g.cv ex.rcialal[alax 
&=r{

		setur:inction( s{
				
	//EaHalins:utuguler deNas (via `uhileownerDument.h`),ewiow.l		
	//Ea(via `uhiledument.h`) &,dument.h (via `uhil`).	io		r i doc e BhiloownerDument.h  []uhiledument.h  []uhil,			pu	aothedeth= da oPrioeaccess(ldum, lax {		so	/	 ( ca!aothedeth{
		if	iodum.addEvt &Li ats( slorig, halinsr,tie, l);		if							da oPrioeaccess(ldum, lax, !faothedeth b.0=)f+,1 )
				}			}	ueardown:
nction( s{
		if		r i doc e BhiloownerDument.h  []uhiledument.h  []uhil,			pu	aothedeth= da oPrioeaccess(ldum, lax {n1 ]		so	/	 ( ca!aothedeth{
		if	iodum.reme tEvt &Li ats( slorig, halinsr,tie, l);		if		da oPrioereme t(ldum, lax {		so	/		use {
				pu	ca oPrioeaccess(ldum, lax, aothedeth{
				/					}	if};	f}n{;	}ur i locaon f =owiow.l.locaon f;	ur i non(e
= { guid:oDely.now() };	ur i rqry g =oc /\?/l);				/EaCross-bw ad( gxmlrpsesg" 	uery g.pseseXML =onction( slda o )&		ir i xml;	o ( ca!da o  []teof elda o ! 1 tring" &&) 			}turn elnl, 		p}	re CoSport: IE 119n1 ]1nly
			 SuIEethw ad otrpseseFro Strg anwh thinvueide tput.	etry 			}xmlr=oc newawiow.l.DOMPsese s)g).pseseFro Strg aseda o,e"pt )/xml"l);	}} m hes sle ) 				xmlr=odefined" 
		
		o ( ca!xmlr []xmlegetEm.gts sByTagNe )Ex"psesererror"&{.nenh,
 ) 
			uery g.errorEx"InvueideXML: "l+lda o )i
	}		turn elxml;	};		ur i		tbrackur = /\[\]$/,	erCRLFl= /\r?\n/g,	ersubmi&t( Teofs nu/^(?:submi&|te ton|image|rere&|fid")$/i,	ersubmi&taed" nu/^(?: tput|reltor|pt )area|keygen)/i
		nction sebuildPseams!fprilax, obj,tieadion sal,oadd])&		ir i me =;		i ( !fray|E.isray|Eseobj ) {
				
 CoS( gtlizeuaay|E item.			uery g.eh e{
obj,tnction( s i, v ) 
			} ( !fieadion salr []tbrackurest( maprilaxn{ {
				
	//EaTateBrehedraay|E item as cesc lar.	io		add!fprilax, v {		so	/	use {
				
	//EaItem ifrnon-sc lar (aay|E otoobjtor),eencod" itshnentric +ex o.
pupubuildPseams!			pu	prilaxn+ "["l+l!fkeof elv = ou"objtor"l eav ! oll ? ? i : ""u)n+ "]",	if	m/l,	if	m/ieadion sal,			pu	ad 					{
				}	if}n{;	
 }use {
 ( !f!ieadion salr
	]toTeofseobj ) = ou"objtor"l{
				
 CoS( gtlizeuobjtor item.			n ( ; me ==s"lobj ) 
			}buildPseams!fprilaxn+ "["l+lme ==+ "]",lobj[ame ==],tieadion sal,oadd]);		f
		/	use {
				
 CoS( gtlizeusc lar item.			add!fprilax, obj );	o}	e		 Adp( gtlizeuabeaay|E  eln (meem.gts frotoaere& of	 Adkey/lues s intrea qry g ring" 	uery g.pseam =onction( sla,tieadion sal])&		ir i prilax,			trnu[],			add =onction( slkeyx lues OrFction(  ) 
		/////vIf vueue ifraonction( ,hinvoke it a seus" itshturn trlues 
			r i vals  =e sFction( sllues OrFction(  ) ?	if		r es OrFction( () :
pup	r es OrFction( 		so	/l[esength,
 
&=rencod"URICompon  &elkeyu)n+ "="l+			e/cncod"URICompon  &ellues  n=ull ? ?u"&&:ulues l);			
;		/ ( !fa&=doll ? {
		ifturn tr""
		}	re CoIfuabeaay|E was pssd toi 	o ssumegthaotit ifrabeaay|E  eln (meem.gts f.	i ( !fray|E.isray|Esea {& []sea.jqry g  e !uery g.isPlas"Objtor(ra=) ) )n{		if Adp( gtlizeukheon (meem.gts f			uery g.eh e{
a,inction( s{
		i		add!fuhilede, opihilelues  )
			}n{;		/	use {
				
 CoIf eeadion sal,oencod" kheo"old" way (e loway 1.3.2 otooldsr	// Coditoit),uue lrwis;oencod" pseamshtucuesgv ly.			n ( ; prilaxnineaa) 
			}buildPseams!fprilax	o [ prilaxn],tieadion sal,oadd]);		f
		}	re CoRurn eluhertust
	g thse gtlizeBn( 		turn els.join( "&"n{;	}
		uery g.fn.prtend{
			se gtlize:
nction( s{
		iftu=n teuery g.pseamcakhilese gtlizeray|Es)n{;		),	ese gtlizeray|E:
nction( s{
		iftu=n tekhilemapslnction( s{
				
	/EaCenoadd]pc pHook n ( "em.gts f"g pofeln(  otoaddon (meem.gts f				r i sl, ts fr=ouery g.pc peluhilse"em.gts f"g);		}	t =n trsl, ts fr?auery g.makeray|Esesl, ts fr)
:luhil
			}n{
	p.feln( slnction( s{
		if	r i te < = :hilete <
		/////ve in.is! ":dabaed"d"l{
sogthaotfieldre&[dabaed"d] works
/		tu=n tekhileme == e !uery gExuhill).is! ":dabaed"d"l{

						rsubmi&taed"est( ma:hiledeTyNe ) )  e !rsubmi&t( Teofsest( ma:e < )  e				/! khilecnk aedi df!rcnk aaed"Teofest( ma:e < ) )
			}n{
	p.mapslnction( se_ix tm.n={n{	io	r i val =auery gExuhill).vue()
		if	 ( cavue&=doll ? {
		if	mturn elnl, 		pu e		/// ( !fray|E.isray|Eselue ) {
		if	itu=n teuery g.mapslval,pnction( ellue ) 
						t =n tr{ame =:aem.nole, oplues :ulue.replac);xrCRLFse"\r\n" )n}
				/	 )i
	u e		///t =n tr{ame =:aem.nole, oplues :ulue.replac);xrCRLFse"\r\n" )n}
				 )egete{;		)	)l);		ur i		t20 nu/%20/g,	erhass =o/#.*$/,	erantiChede =o/([?&])_=[^&]*/,	erhead( th= /^(.*?):[ \t]*([^\r\n]*)$/mg,	
	 / #7653, #8125, #8152: local]pc tocol d=n(cBn( 		tlocalPc tocol nu/^(?:about|app|app-e(orage|.+-prtensn f|fid"|rer|widget):$/,	ernoCoextna nu/^(?:GET|HEAD)$/,	erpc tocol nu/^\/\//,	
	 * Prineln( s
/ * 1)dT eytare us"fulg pointrodu(eenultom da oTeofs (se  ajax/jsonp.js furean exampl )
/ * 2)dT esetare c lled:
/ *    - BEFOREo skg anf ( atieansrt: 
/ *    - AFTER pseamhse gtlizeBn(  (s.da o ifraostrg"  i( s.pc cessDa o ifrurue)	/ * 3)lkeyuisekheoda oTeof	/ * 4)ekheom hes ll symbol "*"fcan be us"d	/ * 5) exucuBn(  wh ? start wh thkeansrt: oda oTeof a seTHENentexinueoduwstpo]"*"fi( teedtd	/ */	/rrineln( th=e{},	
	 * Teansrt: s b+exg" s
/ * 1)dkeyuisekheoda oTeof	/ * 2)ekheom hes ll symbol "*"fcan be us"d	/ * 3)lreltorn(  wh ? start wh thkeansrt: oda oTeof a seTHENegotpo]"*"fi( teedtd	/ */	/teansrt: s =e{},	
	 AdAid t cligts -pr logenhtrlreqryn(e
(#10098); mt alcppe se ledt a seevad(fcompressn( 		 llTeofs nu"*/".ntem h(]"*"f),	
	 AdAnchotokaanf ( psesg" ekheodument.h origi 		origi Anchoto= dument.h.cateBuEm.gts ( "a"g);		origi Anchotohref = locaon fohref;		 AdBad  "coestruoroo" lotouery g.ajaxPrineln(  a seuery g.ajaxTeansrt: 	nction seaddToPrineln( sOrTeansrt: s( struores l{
				 Coda oTeofErpressn flilloptn( al]a sedault
	stpo]"*"		turn elnction( slda oTeofErpressn f,pncti )n{		if ( !fkeof elda oTeofErpressn fl! 1 tring" &&) 			}	ncti =lda oTeofErpressn fi
	u da oTeofErpressn flnu"*";		f
		//r i da oTeofo	/// f0,
			u da oTeofs =lda oTeofErpressn fetoL aerse();
.tches!ftnue tmlwhite {& [];
			if ( !f sFction( slncti )n{
				
	/EaF ( chedrda oTeof  the leda oTeofErpressn f		
	whid" ( mada oTeof =lda oTeofr[++ ) ] { )n{			
	} / Pripend ieltuqryst" 					 ( !fda oTeof[e0 ] = ou"+&&) 			}		/da oTeof =lda oTeof.slic);x1 {& []"*";		f		/! struores [ada oTeof ] =ertruores [ada oTeof ]  [];
 )eunshifo(lncti );		io		 CoOe lrwis;eappeddso	/		use {
				pu	! struores [ada oTeof ] =ertruores [ada oTeof ]  [];
 )epushslncti );				/					}	if}		}
	}		 AdBad  inrciatn flnction(  loi prilaln( tha seteansrt: s	nction seinrciatPrineln( sOrTeansrt: s( struores , upBn( soptrigi alOpBn( sopjqXHR )n{			r i +erciatedndo	},		}seekg aTeansrt: r=oc struores l=d0,teansrt: s );		inction seinrciatmada oTeof )&		i	r i reltored;			ierciated[ada oTeof ] =eurue				uery g.eh e{
rtruores [ada oTeof ]  [];
, nction( se_, prilaln( OrFaorooy={n{	io	r i da oTeofOrTeansrt:  =eprilaln( OrFaorooy( upBn( soptrigi alOpBn( sopjqXHR );
			 ( cakeof elda oTeofOrTeansrt:  = 1 tring" && e				/!seekg aTeansrt: r e ! erciated[ada oTeofOrTeansrt:  ] )n{			
	}optns seda oTeofreunshifo(lda oTeofOrTeansrt:  )i
	u f nrciatmada oTeofOrTeansrt:  )i
	u fturn ellse );	o
 }use {
 ( !fseekg aTeansrt: r{
		if	itu=n te!( seltoredndoda oTeofOrTeansrt:  )i
	u }	if}n{;			turn elseltored;		
		/turn el nrciatmaoptns seda oTeofr[e0 ] {& []! erciated[a"*"f]  e  nrciatma"*"f)
	}		 AdA rcialal,ertendnf ( ajaxnopBn( f	 Cothaottakes "flat"roptns sg(notlpo]beldaep,ertended)
 AdFix s #9887	nction seajaxErtend{
targur,esrc])&		ir i keyx daep,		}flatOptns sg=auery g.ajaxSe& g ts.flatOptns sg do{}
		/n ( ; keyuinesrc])&		i	 ( casrc[ keyu] = oudefined" 
) 
			}( flatOptns s[ keyu] ?otargur : !fdaep, []sedaep,do	}=) ) )[ keyu] =asrc[ keyu];		f
		}		 ( !fceey {
		ifuery g.crtend{
urue,
targur,eceey {;		
		/turn eltargur
	}		 *aHalinsserercs sestpo]aseajaxltuqryst:
 * - landsekheoright da oTeof (mediat"frbetwee  coextna-teof a seexciatednda oTeof)
 * - t =n tsukheomorctrcs dg ans rcs se
 */	nction seajaxHalinsRercs sescasopjqXHR,erercs sest)n{			r i or, :eofoplanalDa oTeofo firstDa oTeofo	//coextnasg=as.coextnaso	//da oTeofs =lseda oTeofr;	re CoRume ttaupo]da oTeof a segur coextna-teof  the lepc cess
	whid" ( da oTeofr[e0 ] = 1 t*&&) 			}da oTeofreshifo();
		 ( cact = oudefined" 
) 
			}or = s.mimuTeof
 dojqXHRegetRercs seHead( ma"Coextna-Te <" );		f
		}	re CoCnk a iflrr're dealg anwh tha knuwstcoextna-teof
	 ( cact ) 
			n ( ; teof  thcoextnasg) 
			} ( !fcoextnas[ate < ]  e coextnas[ate < ]est( mach )n) 				e/da oTeofreunshifo(l:e < )i
	u fbatek;				}	if}		}	re CoCnk a treseeliflrraha opaerercs se lotokheoexciatednda oTeof
	 ( !fda oTeofr[e0 ] inerercs sest)n{		/fanalDa oTeof =lda oTeofr[+0 ];			use {
				
 CoToy=conve: ied" da oTeofr			n ( ; teof  thrercs sest)n{		/o ( ca!da oTeofr[e0 ]  dos.coeve: ( t[+:e < + " "l+lda oTeofr[e0 ] ]n) 				e/fanalDa oTeof =l:eof
			/fbatek;				}	ifo ( ca!firstDa oTeofn) 				e/farstDa oTeofn=l:eof
			/}
}

	

	 AdOtojt alus" farst on 
//fanalDa oTeof =lfanalDa oTeof  dofarstDa oTeof
		}	re CoIfuwe lou seanda oTeof
	 AdWjuaddoe leda oTeof eolp ellistfi( teedtd	/ Ada seturn eluheomorctrcs dg ans rcs se
o ( cafanalDa oTeof )&		i	 ( cafanalDa oTeof = ouda oTeofr[e0 ] {&{
	e/da oTeofreunshifo(lfanalDa oTeof );		f
		/turn trturcs ses[lfanalDa oTeof ];	o}	e		 *oCna thcoevy sn fs give luhertuqrystha setheoorigi alns rcs se
 * Alsresetsluhertuscs seXXXtfieldri sekheojqXHR itsta cs
 */	nction seajaxCoeve: casoptuscs seopjqXHR,eisSuccesse)&		ir i coev2,fcurr exx coev,ftmp, prevo	//coeve: ( t =e{},	
		 AdWorknwh tha copE  elda oTeofs inem se rrateedr remodifE ithr ( coevy sn f	//da oTeofs =lseda oTeofr.slic););	re CoCateBu coeve: ( t mapnwh thn aerm sed keys
	 ( !fda oTeofr[e1 ] {&{
	en ( ; coevuines.coeve: ( t
) 
			}ooeve: ( t[+ooevetoL aerse();
 
&=rs.coeve: ( t[+coevu];		f
		}	recurr ex =lda oTeofreshifo();
re CoConve: l rechedrreqryntlal,da oTeof
	whid" ( curet & ) 			i	 ( cas.tuscs seFieldr[ curet & ] {&{
	e/jqXHR[as.tuscs seFieldr[ curet & ] 
 = tuscs se;
}

	

	 AdApply e leda oFeln(   ( pc vid" 	if ( !f!prev
 e  sSuccesse ( s.da oFeln(  {n{	io	turcs se = s.da oFeln( (ptuscs seopseda oTeofu)
			}				prev
= curet &
			curr ex =lda oTeofreshifo();
re/ ( !fcuret & ) 			i	///vT ere's  nly worklpo]du  ( curet & da oTeof  frnon-aupo			} ( !fcurr ex = 1 t*&&) 					e/curr ex =lprev
		/////vConve: lturcs se  ( pcev
da oTeof  frnon-aupo]a sediffees lm tocurr ex	o
 }use {
 ( !fpcev
! 1 t*&&
	 pcev
! 1 curet & ) 			i	/f Adp(ek podictlygcoeve: ( 			e/coevu= coeve: ( t[+pcev
+ " "l+lcuret & ]  docoeve: ( t[+"* "l+lcuret & ];		io		 CoI( t ne lou s,fseek popair					 ( !f!coevu) 			}		/n ( ; coev2  thcoevy tsrs )n{		ifio		 CoI( coev2 outputslcurr ex	o
 		
uty = coev2.bpli ( " "l);	}				  ( !futy[e1 ] = 1 curet & ) 			i	/fo		 CoI( pcev
can be coevy tsdr reacceptede tput	i	/fo		coevu= coeve: ( t[+pcev
+ " "l+luty[e0 ] ]n d						pp/coeve: ( t[+"* "l+luty[e0 ] ];	}				 } ( !fcoev ) 			i	/fo		///vConde se eqrivalyn(e
coeve: ( t	i	/fo		/ ( !fcoev =d0,tes  {
		if	io	o		coevu= coeve: ( t[+coev2 ];
						o		 CoOe lrwis;,hinse: l hf  tn( mediat",da oTeof
								}use {
 ( !fcoeve: ( t[+coev2 ]
! 1 tes  {
		if	io	o		curr ex =luty[e0 ];	if	io	o		da oTeofreunshifo(l:ty[e1 ] );	if	io	o	}	if	io	o	batek;				o	o	}	if	io	}				/	}			/	}		io		 CoApply coeve: ( o(if notlan eqrivalyn(e)
	u f ( !fcoevu! 1 tes  {
		
		o		 CoUnlesseerrorthare all asdr rebubed", m hes a seturn eluhem
fo		/ ( !fcoev  ( s.thw ad {
		if	io	turcs se = coev(ptuscs se )
				
 }use {
				pu		try 			}f	io	turcs se = coev(ptuscs se )
				
 }} m hes sle ) 				f	io	tu=n tr{	if	io	o	stat{:x"psesererror",	if	io	o	error:fcoev ? < :x"No coevy sn f lm to"l+lpcev
+ " po]"l+lcuret &				o	o	};	if	io	}				/	}			/	}				}	if}		}	ret =n tr{astat{:x"success"opda o:ptuscs se }
	}		uery g.crtend{
			m//vCounn(  n ( holdg" ekheonumber  elaion opqry ifr		aion o:,
				/CoLast-Modifisdrhead(  m cheon (atextrtuqryst
ela aModifisd:o	},		etag:e{},	
	ajaxSe& g ts: 			}url: locaon fohref,	ifue <: "GET",	ifisLocal:ptlocalPc tocolest( malocaon fopc tocol )		leglobal:ourue,			pr cessDa o:ourue,			async:ourue,			coextnaTe <: "applicaon f/x-www-n (m-urlencod"d;enhtrset=UTF-8",	
		 *	ifuimuout:,
			uda o:pnl, t	//da oTeof:pnl, t	//us"rme =:anl, t	//pssdword:anl, t	//m che:anl, t	//thw ad:llse )t	//teadion sal:llse )t	//head( t:o	},			*/
			accepts: 			}	t*&:  llTeofs			}	uext:,"pt )/plas"",	if	 tml:,"pt )/ tml",	if	xml:,"applicaon f/xml, pt )/xml",	if	json:,"applicaon f/json, pt )/javascript"
pu},	
		coextnas: 			}	xml:,/\bxml\b/,	if	 tml:,/\b tml/,	if	json:,/\bjson\b/
pu},	
		tuscs seFieldr: 			}	xml:,"tuscs seXML"			}	uext:,"tuscs seText",	if	json:,"tuscs seJSON"
pu},	
		/EaDa o coeve: ( t	i	/EaKeyseseparere source ( ( c hes ll t*&)]a sedas g eBn(  teofs wh tha singns spe(e		
coeve: ( t:
				
	/EaConve: lanye g"  eolpext		}	t*lpext&: Strg a				
	 AdTexteto  tml (tes  = no,teansn (meBn( )
	u "pt )  tml":ourue,			
	 AdEluesere pt )=afraojsonoerpressn f
	u "pt ) json":oJSON.psese,			
	 AdPsese pt )=afrxml
	u "pt ) xml":ouery g.pseseXML
pu},	
		/EaF ( optns sgthaotshouldt bebeldaep,ertended:
		/Eayou
can addoyour uwstcultom optns sgh s  if
		/Eaa sewh styou
cateBu  ne thaotshouldt bebe
		/Eadaep,ertended (se  ajaxErtend)
	uflatOptns s: 			}	url: urue,				coextxt:,urue			}		),	
	 / CateBufraoncll fledged se& g tsuobjtor intretargur
	 / wh thbo thajaxSe& g tsaa sese& g tsufieldr.re CoIfutargur illomi&t(s,fwrites intreajaxSe& g ts.
	ajaxSe&ur:inction( s
targur,ese& g tsu{
		iftu=n tese& g tsu?			
	 AdBuildg"  a se& g tsuobjtor		
	ajaxErtend{
ajaxErtend{
targur,euery g.ajaxSe& g tsl), se& g tsu{
:			
	 AdErtendg"  ajaxSe& g ts		
	ajaxErtend{
uery g.ajaxSe& g ts,
targurn{;		),	
	ajaxPrineln( :eaddToPrineln( sOrTeansrt: s( prilaln( th)		lajaxTeansrt: :eaddToPrineln( sOrTeansrt: s( teansrt: s ),	
	 / Ma thmethod		ajax:inction( s
url, upBn( s )n{		if AdIfuurl ifrabeobjtor, simuleBu pri-1.5 sggnares 
		 ( cakeof elurl = ou"objtor"l{
			} optns sg=aurl;		}	url =ndefined" 
			}	
		/EaF (ce optns sgto]belabeobjtor
} optns sg=aoptns sg do{}
		/	r i teansrt: ,			
	 AdURL wh tout anti-m cheopseam				c cheURL,			
	 AdRercs serhead( s	io	turcs seHead( sStrg a		io	turcs seHead( s,			
	 Aduimuout halins		}	uimuoutTimur,			
	 AdUre cleanup r i		}	urlAnchot,			
	 AdReqrysthstat{ (beco =s lse ) up slsendna seteu) up slcompleBn( )
	u compleB(s,			
	 AdTo knuw
 ( global,ev ex(eare po]beldispeteded		
	fireGlobals,			
	 AdLooper iiaed"		
	i,			
	 Adctiheded part ofhkheourl		}	utiheded,			
	 AdCateBu kheoni alnoptns sgobjtor		
	sg=auery g.ajaxSe&up(o	}, upBn( s ),			
	 AdCel(backs coextxt				c l(backCoextxtg=as.coextxh  []s,			
	 AdCoextxtgn (aglobal,ev ex(eisoc l(backCoextxtg ( it ifra DOM deTy otouery g clow(cBn( 		leglobalEvt &Coextxtg=as.coextxh  e				/! c l(backCoextxtodeType <  doc l(backCoextxtojqry g ) ?	if		muery gExc l(backCoextxtg) :
pup	/uery g.cv ex,			
	 AdDeferreds	io	deferredg=auery g.Deferrede)		le compleB(Deferredg=auery g.Cel(backs( "( ce memory" ),			
	 AdStatus-dipend ex c l(backs	io	statusCeTy =as.statusCeTy  do{},			
	 AdHead( s (e lytare s ex el(oat on(e)
	u tuqrystHead( th= 	},			 tuqrystHead( tNe =s =p{},			
	 AdDault
	eabt:   =ssage	io	strAbt:  =e"ca csd"d",			
	 AdFake xhi		}	jqXHR =
		if	ituadyStat{:x0,		io		 CoBuildsrhead( s hashtaed" i( teedtd	/	}	getRercs seHead( :onction( slkey ) 				f	ir i tches;
fo		/ ( !fcompleB(s ) 				f	io ( ca!rurcs seHead( s ) 				f	io	turcs seHead( s =o{}
								whid" ( mamches = rhead( t.exuc(ptuscs seHead( sStrg a=) ) )n{				f	io	turcs seHead( s[amches[e1 ]etoL aerse();
 + " "l]n=	if	m/				!fturcs seHead( s[amches[e1 ]etoL aerse();
 + " "l]n [];
 )	if	m/					.ntem h(]mches[e2 ] );	if	io	o}	if	io	}				/		mches = rurcs seHead( s[akeyetoL aerse();
 + " "l]
				
 }
f	io	tu=n temches ==ull ? ?ull ? : mches.join( ", "l);	}			},		io		 CoRaworing" 	///	getAllRercs seHead( s:
nction( s{
		if			tu=n tecompleB(s ?ptuscs seHead( sStrg a=:lnl, 		pu		},		io		 CoChedethp elhead( 	io		setReqrystHead( :onction( slle, oplues  )n{				f	 ( !fcompleB(s =doll ? {
		if	m		me = = ruqrystHead( tNe =s[ame =etoL aerse();
 
&=			f	io	tuqrystHead( tNe =s[ame =etoL aerse();
 
& []me =;		f	io	tuqrystHead( t[ame ==] =rlues ;				//}
f	io	tu=n teuhil
					},		io		 CoOve:ridsserercs se coextna-teof head( 	io		ove:ridsMimuTeof:onction( sl:eof )n{				f	 ( !fcompleB(s =doll ? {
		if	m		s.mimuTeof
=l:eof
			/f/}
f	io	tu=n teuhil
					},		io		 CoStatus-dipend ex c l(backs	io		statusCeTy:onction( slmapn) 				f	ir i ces ;			}f	 ( !fmapn) 				f	i/ ( !fcompleB(s ) 					f	io	 AdErucuBu kheoappc priat",c l(backs	io			}	jqXHR.always!fmap[ojqXHRestatus ] );	if	io		use {
				
	/io	 AdLazy-addoe lenewac l(backsnineaaway thaotpreservsseold  nss							/n ( ; codf  thmapn) 				f	i/		statusCeTy[ codf ] =r[ statusCeTy[ codf ],fmap[ocodf ] ];	if	io	o}	if	io	}				/	}
f	io	tu=n teuhil
					},		io		 CoCa csdluhertuqryst	io		abt: : nction( slrtatusTtxtg) 				f	ir i ni alTtxtg=astatusTtxtg []strAbt: ;			}f	 ( !fteansrt: r{
		if	i	/teansrt: .abt: ( ni alTtxtg)
				
/}				/	d ns(x0, ni alTtxtg)
				
/tu=n teuhil
					}				};	
////vAerhedrdeferreds	iodeferredopc mis;(puqXHR );

////vAdd]pc tocol if notlpc vid"  (prilaln( thmight exciatoit)
		 CoHalins lse yuurl in kheose& g tsuobjtor (#10093:pnteri atscy wh thold sggnares )
		 CoWjualsreus" kheourlopseamen(   ( availaed"		
s.url =n( maurl  dos.url  dolocaon fohrefu)n+ "" )	if	.replac);xrpc tocol,alocaon fopc tocol + "//" );

////vAlias methoda ptns ntreteof aseper Bickur #12004		
s.te < = optns semethoda dooptns sete <  dosemethoda dolete <
		// AdErtractlda oTeofs list			seda oTeofrr=oc seda oTeofu []"*"l).koL aerse();
.tches!ftnue tmlwhite {& []; "" ];

////vA cross-doma threqrysthisninehrderewh sttheoorigi rn'est bemches uheomurr ex origi .
i	 ( cas.crossDoma th=doll ? {
		if	urlAnchoto= dument.h.cateBuEm.gts ( "a"g);			
	 AdSport: IE 11<=8n1 ]1, Edge 12n1 ]5		
	 AdIEethw ad exceptns  ocoaccessg
	ap elhrefupc perty  ( url ifrmaln (med,		
	 Ade.g. http://exampl .ntm:80x/
			try 			}f	urlAnchotohref = s.url;		io		 CoSport: IE 11<=8n1 ]1nly
				// AdAnchot's host pc perty  st bemorctc  pore& wh sts.url iserelaoive		}f	urlAnchotohref = urlAnchotohref
					s.crossDoma th= origi Anchotopc tocol + "//" + origi Anchotohost !==			f	iurlAnchotopc tocol + "//" + urlAnchotohost;	o
 }um hes sle ) 					// AdIf e lre ifrabeerror psesg" ekheoURL,o ssumegit ifrcrossDoma t,	io		 Coit
can be rejiatednby e leteansrt: r ( it ifrinvueid					s.crossDoma th= urue					
		/
				/EaConve: lda o if notlalreadyaaoring" 	// ( cas.da o  ( s.pc cessDa o 
	]teof els.da o ! 1 tring" &&) 			}	s.da o =euery g.pseamcas.da oopseieadion sal]);
}

	

	 AdApply prineln( s
/	inrciatPrineln( sOrTeansrt: s( prineln( s,asopopBn( sopjqXHR );

// AdIf reqrysthwas abt: ede trid(oa prineln( ,ertop e lre
	/ ( !fcompleB(s ) 				ftu=n teuqXHR;
}

	

	 AdWe
can firenglobal,ev ex(eas ofhnuw
 ( asksdr r
p//EaDot befirenev ex(eifeuery g.cv ex ifrdefined" 
ielabeAMD-usage scenario (#15118)		
fireGlobals,= uery g.cv ex  ( s.global;

// AdWches lotoaeneware& of reqrysts	if ( !ffireGlobals, ( uery g.aion o++ = ou0={n{	io	uery g.cv ex.trigg( !f"ajaxStart"]);
}

	

	 AdUpperm se e leteof
		s.te < = s.te <.koUpperse();
;	
	//EaD=n( med"lieltuqryst has coextna
		s.hasCoextna nu!rnoCoextnaest( mas.te < 
;	
	//EaSa tte loURL inem se rr're poyg anwh the loIf-Modifisd-Sin e
		/Eaa s/otoIf-N ns-Mches head(  leBuri s
	e CoRume tthass tresimplifE url manipuleBn( 			c cheURL = s.url.replac);xrhass, ""u)
	
	e CoMoreeoptns sghaling anf ( reqrystsnwh thno coextna
		 ( !f!p.hasCoextna ) 			i	///vRumember p elhass srewe
can puotit back	if	utiheded = s.url.slic);xc cheURL.nenh,
 );		/// CoIf da o ifravailaed"aa seshould be pc cess(s,fappedd da o treurl		}	 ( cas.da o  ( ( s.pc cessDa o  []teof els.da o = 1 tring" &&) ) 				e/c cheURL +=oc rqry gest( mac cheURL )
?,"&"n: "?"u)n+ s.da o;		io		 Co#9682:treme ttda o sogthaotio'fjnotlus" 
ielabecv exualns try	io		celere s.da o;		u e		/////vAdd] ( updeBeeanti-m cheopseam i( teedtd	/	} ( cas.chede =noulse ) ) 
	if	ec cheURL = c cheURL.replac);xrantiChede, "$1"l);	}			utiheded = c rqry gest( mac cheURL )
?,"&"n: "?"u)n+ "_="l+l!fnon(e.guid ) {
+			f	iutiheded;		u e		/////vPut hass a seanti-m cheo sekheoURL thaotwh ? bertuqryst"  (gh-1732)		}	s.url =nc cheURL + utiheded;				/EaChalge '%20' tre'+' i( uhillillencod"don (mebody coextna (gh-2658)		
}use {
 ( !fs.da o  ( s.pc cessDa o 
			}	(as.coextnaTeofu []"" ).+ex oOf! "applicaon f/x-www-n (m-urlencod"d"=) = ou0&) 			}	s.da o =es.da o.replac);xr20, "+&&);
}

	

	 AdSet kheoIf-Modifisd-Sin eaa s/otoIf-N ns-Mches head( ,r ( inr (Modifisdrmes .	// ( cas. (Modifisdr)n{		/o ( cauery g.la aModifisd[nc cheURL ]n) 				e/jqXHResetReqrystHead( Ex"If-Modifisd-Sin e",auery g.la aModifisd[nc cheURL ]n);				}	ifo ( cauery g.ctag[nc cheURL ]n) 				e/jqXHResetReqrystHead( Ex"If-N ns-Mches",auery g.ctag[nc cheURL ]n)					
		/
				/EaSet kheomorctc  head( ,r ( da o ifrbeg anstna
		 ( !fs.da o  ( s.hasCoextna  ( s.coextnaTeofu!noulse )  dooptns secoextnaTeofu{&{
	e/jqXHResetReqrystHead( Ex"Coextna-Te <", s.coextnaTeofu);
}

	

	 AdSet kheoAccepts head(  lotokheoservsr,fdipendg thothe leda oTeof
e/jqXHResetReqrystHead( E
	e/"Accept",	if	seda oTeofr[e0 ]  ( s.accepts[ seda oTeofr[e0 ] 
&?	le 	s.accepts[ seda oTeofr[e0 ] 
&+			f	i( seda oTeofr[e0 ] ! 1 t*&&? ", "l+  llTeofsn+ "; q=0.01" : ""u)n:	le 	s.accepts[ "*"f]
}
);		if CoCnk a n ( head( s optns 		in ( ; iuines.head( s ) 				fjqXHResetReqrystHead( Exi,es.head( s[ ], ]);
}

	

	 AdAll a cultom head( s/mimuteofs a seearly abt: 
/	 ( !fs.ben (eSedd 
			}	(as.ben (eSedd.ll( Exc l(backCoextxtopjqXHR,es )&=noulse )  docompleB(s ) ) 			i	///vAbt:  if notldon  alreadyaa seturn e			ftu=n teuqXHR.abt: ();
}

	

	 AdAbt: g"  ifjno long(  a ca csdleBn( 			strAbt:  =e"abt: ";

// AdItsta ? c l(backsnothdeferreds	iocompleB(Deferred.add!fs.compleB(]);
}
uqXHR.d ns(xs.successe);
}
uqXHR.fail(xs.error );		if CoGet keansrt: 
//teansrt:  =e nrciatPrineln( sOrTeansrt: s( teansrt: s,asopopBn( sopjqXHR );

// AdIf no,teansrt: , rraauto-abt: 
/	 ( !f!teansrt: r{
		if	d ns(x-1,x"No Teansrt: &&);
}

use {
				puqXHR.tuadyStat{ =e1;			
	 AdSedd global,ev ex	ifo ( cafireGlobals,) 				e/globalEvt &Coextxt.trigg( !f"ajaxSedd",e[ljqXHR,es ]n)					
		/// CoIf reqrysthwas abt: ede trid(oajaxSedd,ertop e lre
	// ( !fcompleB(s ) 				f	tu=n teuqXHR;
}
 e		/////vTimuout	/	} ( cas.async  ( s.timuout > 0={n{	io		uimuoutTimur =owiow.l.setTimuoutslnction( s{
		if	}	jqXHR.abt: ( "uimuout"l);	}			}, s.timuout )					
		///try 			}f	compleB(s =llse );	o
 /teansrt: .send{
tuqrystHead( t,ldon  {		pu eum hes sle ) 					// AdRethw a post-compleBn(  exceptns s
		// ( !fcompleB(s ) 				f	/thw a e
					}				// AdPm rageBeuue lr(eas tust
	s
		//d ns(x-1,xen)					
		/
				/EaCel(back n ( wh stev rye g"  ifjdon 
//fction sed ns(xstatus,enaoiveStatusTtxt,erercs ses, head( s ) 				fr i +sSuccess, success, erroroptuscs seopmodifisd,	io		statusTtxtg=enaoiveStatusTtxt;		/// CoIgnoreeripeaotinvocaon fs
	// ( !fcompleB(s ) 				f	tu=n t					
		///compleB(s =lurue			/// CoCan rduimuout  ( it exists	if	 ( !ftimuoutTimur ) 				f	wiow.l.clearTimuoutsltimuoutTimur );
}
 e		/////vDlrefeet cleteansrt: rf ( chrly garbage clow(cBn( 		le//v(nremchBurih a longekheojqXHR objtor wh ? berus" )
	//teansrt:  =edefined" 
					 CoChedeerercs se head( s	io	turcs seHead( sStrg a =ehead( s  []"";			
	 AdSetrtuadyStat{			puqXHR.tuadyStat{ =estatus > 0=? 4f:r0;		/////vDln( med"lielsuccessful		}	 sSuccesse=estatus >= 200= e status < 300= []status = 1 304;		/////vGe lturcs se da o	if	 ( !frercs sest)n{		/o	turcs se = ajaxHalinsRercs sescasopjqXHR,erercs sest);
}
 e		/////ve ina noop coeve: ( of ( missg
	ascript	if	 ( !f! sSuccesse ( uery g.inray|Ese"script"opseda oTeofs ) >r-1t)n{		/o	s.coeve: ( t[+"pt ) script" ] =rnction( s{
	};
}
 e		/////vConve: lnremchBuriwhat (e aotwayrtuscs seXXXtfieldriare alwaysoset)
/o	turcs se = ajaxCoeve: casoptuscs seopjqXHR,eisSuccesse);		/// CoIf successful, halinseteof cna tg" 	/// ( !f sSuccesse)&					// AdSet kheoIf-Modifisd-Sin eaa s/otoIf-N ns-Mches head( ,r ( inr (Modifisdrmes .	//// ( cas. (Modifisdr)n{		/o		modifisd,= uqXHRegetRercs seHead( ma"Last-Modifisd"l);	}				 ( !fmodifisdr)n{		/o			uery g.la aModifisd[nc cheURL ]n=fmodifisd
				
/}				/	modifisd,= uqXHRegetRercs seHead( ma"ctag"l);	}				 ( !fmodifisdr)n{		/o			uery g.ctag[nc cheURL ]n=fmodifisd
				
/}				/}				// Adif no coextna
		// ( castatus = 1 204a dolete < = 1 tHEAD&&) 			}		/statusTtxtg=e"nocoextna";				// Adif notfmodifisd				/}use {
 ( !fstatus = 1 304&) 			}		/statusTtxtg=e"notmodifisd";				// AdIflrraha opda oopleB's coeve:  it				/}use {
			}		/statusTtxtg=etuscs seestat ;			}f	successe=etuscs seeda o;		u o	errore=etuscs seeerror;	}				 sSuccesse=e!error;	}			}				}use {
				
	//EaErtractlerrorelm tostatusTtxtga sen (melizeun (aton-abt: s	u o	errore=estatusTtxt;			// ( castatus  []!rtatusTtxtg) 				f	istatusTtxtg=e"error";	}				 ( !fstatus < 0r)n{		/o			status =,
;so		
/}				/}	}
 e		/////vSet da o lotokheofake xhigobjtor		
	jqXHRestatus =estatus;		
	jqXHRestatusTtxtg=e(enaoiveStatusTtxt= []statusTtxtg) +]"";			
	 AdSuccess/Error	/// ( !f sSuccesse)&					/deferredotusolveWithExc l(backCoextxtop[ success, statusTtxt,ejqXHR ]n)					
use {
			}		deferredotujtorWithExc l(backCoextxtop[ jqXHR,estatusTtxt,eerrore]n)					
		/// CoStatus-dipend ex c l(backs	io	jqXHRestatusCeTy( statusCeTyn)					statusCeTy =adefined" 
					 ( cafireGlobals,) 				e/globalEvt &Coextxt.trigg( !f sSuccesse?f"ajaxSuccess" : "ajaxError",	if	io[ jqXHR,es,f sSuccesse?fsuccesse:eerrore]n)					
		/// CoCompleB(	///compleB(Deferred.fireWithExc l(backCoextxtop[ jqXHR,estatusTtxt ] );	
//o ( cafireGlobals,) 				e/globalEvt &Coextxt.trigg( !f"ajaxCompleB(",e[ljqXHR,es ]n)				
	//EaHalins kheoglobal,AJAX counn( 			// ( ca!(x--uery g.aion o ) )n{				f	uery g.cv ex.trigg( !f"ajaxStop"l);	}			}				
		/
				tu=n teuqXHR;
}},		igetJSON:inction( s
url, da oopcel(back )
		iftu=n teuery g.getelurl, da oopcel(back,x"json"n{;		),	
	getScript:inction( s
url, cel(back )
		iftu=n teuery g.getelurl, defined" opcel(back,x"script" {;		)	)l);		uery g.ch e{
[ "get", "post" ],inction( se_ix methoda)
		iuery g[ methoda] =rnction( slurl, da oopcel(back,x:eof )n{				/EaShifoiargum ex(eifeda o argum exhwas omi&t(s
// ( !f sFction( slda o ) )n{				teof
=l:eof  doc l(back;	}		cel(back =lda o;	}		da o =edefined" 
			}	
		/EaTheourlocan be abeoptns sgobjtor (whies th stmt alha op.url)	iftu=n teuery g.ajax( uery g.crtend{
			}	url: url,				teof: method			u da oTeof: :eofo
	u da o:pda oo
}f	success:oc l(back
		}, uery g.isPlas"Objtor(rurlo)  e urlo) {;		);	)l);		uery g.ajaxPrineln( slnction( sese)&		ir i i;
in ( ; iuines.head( s ) 				 ( !f etoL aerse();
 = 1 tcoextna-teof&&) 			}	s.coextnaTeofu=es.head( s[ ], ] []"";		i
		)	)l);			uery g._evalUrl =nnction( s
url, upBn( s, doc ) 			tu=n teuery g.ajax( 			}url: url,	
		/EaMake uhillexplicixx sin e us"rocan ove:rids uhillthw ugthajaxSe&up (#11264)			ue <: "GET",	ifda oTeof: "script"o
//m che:aurue,			async:olse )t	//global:olse )t	
		/EaOnly eluesere pdeerercs se  ( it ifrsuccessful (gh-4126)
		 Coda oFeln(   fjnotlinvokednf ( failureerercs ses, sreusg"  it itstead
		 Coofhkheodault
	ecoeve: ( o fjkludgyabuotit works.	//coeve: ( t:
			u "pt ) script":
nction( s{
	
		/
,	ifda oFeln( :enction( s
tuscs se )n{	io	uery g.globalEval(ptuscs seopupBn( s, doc );		i
		)n{;	}
			uery g.fn.prtend{
			wrapAll:enction( s
 tml )&		i	r i wrap;
re/ ( !fBhil[e0 ]r)n{		/o ( ca sFction( sl tml )&)n{				f tml =l tml.ll( ExBhil[e0 ]r);
}
 e		/////vTheoel, ts frpo]wrapekheotargur arou s	///wrape=auery gEx tml,xBhil[e0 ]oownerDument.h ).eq( 0r).cl ns(xie, l);		if	 ( !fthil[e0 ]orset &Nes n) 				e/wrap.inse: Ben (eExBhil[e0 ]r);
}
 e		///wrap.mapslnction( s{
				e/r i sl,  e Bhil				
	/whid" ( em.nofarstEm.gts Chiddr)n{		/o		sl,  e em.nofarstEm.gts Chidd
					}				//t =n trsl, 					
u).appeddExuhill)
			}	
		tu=n teuhil
		),	
	wrapInn( :enction( s
 tml )&		i	 ( ca sFction( sl tml )&)n{				turn eluhileeaes!fnction( s ],) 				e/jery gExuhill).wrapInn( (l tml.ll( ExBhil, ],) )					
u)
			}	
		tu=n teuhileeaes!fnction( s{
		if	r i relf =auery gExuhill),	if	icoextnasg=aself.coextnas()
		if	 ( cacoextnas.nenh,
 ) 
				icoextnas.wrapAllsl tml )		so	/	use {
		o			self.appeddEx tml )					
		/
n{;		),	
	wrap:enction( s
 tml )&		i	r i  tmlIsFction(  =a sFction( sl tml );	
		tu=n teuhileeaes!fnction( s ],) 				ejery gExuhill).wrapAllsl tmlIsFction(  ?l tml.ll( ExBhil, ],) :x tml )				
n{;		),	
	unwrap:enction( s
seltoror ) 				uhilerset &s
seltoror ).not!f"body" ).eaes!fnction( s{
		if	uery gExuhill).replac)WithExkhilecniddNeNas )				
n{;			tu=n teuhil
		)	)l);			uery g.erpr.pseudos.hidd e =nnction( s
tm.n={n{	itu=n te!uery g.erpr.pseudos.visied"s
tm.n={;	}
	uery g.erpr.pseudos.visied" =nnction( s
tm.n={n{	itu=n te!!!ftm.nooffserWid,
  []tm.nooffserHeight  []tm.nogurClit &Rtors().nenh,
 );	}
					uery g.ajaxSe& g ts.xhig=fnction( s{
		itry 			}turn elnewawiow.l.XMLHttpReqryst();	}} m hes sle ) 	}
};	ur i xhiSuccessStatus =e{				/EaFid" pc tocol alwaysoyieldristatus codf 0,o ssumeg200			0:g200t	
		/EaSport: IE 11<=9nly
				 Co#1450:gso =timusE 11t =n tsu1223 wh stiteshould be 204		
1223: 204		
,	ixhiSuort: edg=auery g.ajaxSe& g ts.xhi()
		pport f.co s =o!!xhiSuort: edg ( ( "wh tCredyntlals" inexhiSuort: edg)
	pport f.ajaxl= xhiSuort: edg=a!!xhiSuort: ed;		uery g.ajaxTeansrt: !fnction( s upBn( s )n{	ir i cel(back,xerrorC l(back;	
	 / Caosfjdoma th nly all asdrielsuort: edgthw ugthXMLHttpReqryst
	 ( !fsport f.co s  []xhiSuort: edg ( !optns secrossDoma th)
		iftu=n te			}	sedd:enction( s
 ead( t,lcompleB(])
				e/r i i,	if	ioxhig=foptns sexhi()
		f	ioxhi.oped!			pu	optns sete <,			pu	optns seurl,				u	optns seasync,			pu	optns seus"rme =,			pu	optns sepssdword			pu)				
	//EaApply cultom fieldri ( pc vid" 	if f ( !foptns sexhiFieldru) 			}		/n ( ; iuineoptns sexhiFieldru) 			}		/oxhi[ ], ]=eoptns sexhiFieldr[ ], 
				
/}				/}				// AdOve:rids mimu teof  ( teedtd	/	}	 ( !foptns semimuTeof
 ( xhi.ove:ridsMimuTeofu) 			}		/xhi.ove:ridsMimuTeof!foptns semimuTeof
);	}			}				// AdX-Ruqryst" -With head( 	io		/EaF ( cross-doma threqrysts,fseeg"  as coedion ss furea prinlight are
	//	/Eaaki ntrea jigsaw puzzd", weesimply teve:are& itlpo]belsure.	io		 Co(it
can alwaysobeare& oneaaper-reqrysthbasifrotocv eeusg"  ajaxSe&up)	io		/EaF ( se =-doma threqrysts,fwot bechalge head(   ( alreadyapc vid" .	//// ( ca!optns secrossDoma th ( !head( s[ "X-Ruqryst" -With" ]n) 				e/	head( s[ "X-Ruqryst" -With" ]n1 tXMLHttpReqryst";	}			}				// AdSet head( s	io	/n ( ; iuinehead( s ) 				f	/xhi.setReqrystHead( Exi,ehead( s[ ], ]);
}
		}				// AdC l(back
				cel(back =lnction( sl:eof )n{				f	turn elnction( s) 				f	i/ ( !fcel(back )
		if					cel(back =lerrorC l(backl= xhi. nloadn=	if	m/			xhi. nerrore=exhi. nabt:  =exhi. nuimuout =	if	m/				xhi. nreadystat chalge =lnl, 			if	m/		 ( cakeof = 1 tabt: "n) 				f	i/		xhi.abt: ();
}
			
/}use {
 ( !fkeof = 1 terror"&{
				
	/io		/EaSport: IE 11<=9nly
					/io		/EaOneaamanualnnaoive abt: ,E 19ethw ad				/io		/Eaerrorthoneany pc perty accessgthaotifjnotltuadyStat{			p	m/		 ( cakeofofhxhi.status ! 1 tnumber"n) 				f	i/		/compleB((x0, terror"&{;
}
			
/ }use {
				pu				/compleB((			
	/io				/EaFid": pc tocol alwaysoyieldristatus 0;eseel#8605, #14207		
	/io				xhi.status,		
	/io				xhi.statusTtxt										);	if	io	o	}	if	io	o}use {
				pu				compleB((	
	/io				xhiSuccessStatus[hxhi.status ]  []xhi.status,		
	/io			xhi.statusTtxt,			
	/io			/EaSport: IE 11<=9nly
					/io			 AdIE9 has no XHR2abuotthw ad otrbinary (erac-11426)				/io			 AdF ( XHR2aton-xtxtoplet kheom llei halins itl(gh-2498)				/io			(]xhi.tuscs seTeofu []"pext&n) ! 1 tpext&nn d						pp/	keofofhxhi.tuscs seText ! 1 tring" &&?		
	/io				{rbinary:hxhi.tuscs se } :
pup	/o				{rxtxt:,xhi.tuscs seText },		
	/io			xhi.getAllRercs seHead( s()				/io		);	if	io	o}	if	io	}				/	}
				/					
	//EaLi atsl recvts f					xhi. nloadn=fcel(back();
}
		errorC l(backl= xhi. nerrore=exhi. nuimuout =fcel(back( terror"&{;
			// AdSport: IE 119nly
				// Ade in nreadystat chalge  rereplac)  nabt: 			// Adto  alins utihught abt: s	u o	 ( caxhi. nabt:  = oudefined" 
) 
			}		xhi. nabt:  =eerrorC l(back;	io	o}use {
				pu	xhi. nreadystat chalge =lnction( s{
				
	/if CoCnk a tuadyStat{ ben (eduimuout as ibechalged				/io ( caxhi.tuadyStat{ = ou4 ) 					f	io	 AdAll a  nerrorepo]belc lledofarst,			f	io	 Adbuotthaotwh ? notl alins annaoive abt: 			f	io	 AdAlso,fsa operrorC l(backltrea r iiaed"		
		io	 Adafrxhi. nerrorecannotlbe access(s		
		io	wiow.l.setTimuoutslnction( s{
		if	}		i/ ( !fcel(back )
		if							errorC l(back();	if	io	o	}	if	io	o}u);	if	io						/	}
				/					// AdCateBu kheoabt:  c l(back
				cel(back =lcel(back( tabt: "n);
			//try 		
		io	 AdDolsendnuhertuqrysth(uhillmayrtais;ea  exceptns )			f	/xhi.seddExoptns sehasCoextna  ( optns seda o& []ml ? {;	io	o}um hes sle ) 					//	 Co#14683: Only rethw a i( uhillhast bebetslnotifisdrafrabeerror ye 			f	i ( !fcel(back )
		if				thw a e
					/}				/}	}
 e,			
	abt: : nction( s)
		if		 ( !fcel(back )
		if			cel(back();
}
							}	if};	f}	)l);					 AdPrcv ex auto-exucuBn(   elscripts wh stno explicix
da oTeof was pc vid"  (Seelgh-2432)	uery g.ajaxPrineln( slnction( sese)&		i ( cas.crossDoma th)
		ifs.coextnas.script =llse );	o}	)l);		 AdItsta ? script da oTeof
uery g.ajaxSe&up(o	
	accepts: 			}script:i"pt )/javascript,fapplicaon f/javascript,f"l+			e"applicaon f/ecmascript,fapplicaon f/x-ecmascript"		
,	icoextnas: 			}script:i/\b(?:java|ecma)script\b/
p
,	icoeve: ( t:
			u"pt ) script":
nction( s ttxtg) 				fuery g.globalEval(pttxtg)
				tu=n teutxt;			}	o}	)l);		 AdHalins m che's rcialal,m se a secrossDoma t	uery g.ajaxPrineln( sl"script"opnction( sese)&		i ( cas.chede =noudefined" 
) 
			s.chede =llse );	o}	i ( cas.crossDoma th)
		ifs.teof
=l"GET";	o}	)l);		 AdBi sescript kaanhacklteansrt: 
uery g.ajaxTeansrt: !f"script"opnction( sese)&		
///vThifruransrt:   nly dealsnwh thcaosfjdoma th  of (c" -by-attrs reqrysts	i ( cas.crossDoma th dolescriptAttrs )&		i	r i script,fc l(back;	}	tu=n te			}	sedd:enction( s
_,lcompleB(])
				e/script =luery gEx"<script>" )	if	m/.attr(olescriptAttrs  do{} )	if	m/.pc pel{enhtrset:olescriptChtrset,esrc:ts.url } )	if	m/.( s
"loadnerror", cel(back =lnction( slev r{
		if	i	/script.reme t();	if	io	cel(back =lnl, 		pu				 ( !fev r{
		if	i	//compleB((xev .keof = 1 terror"&? 404f:r200txev .keof );	if	io						/	}&{;
			// Ade innaoive DOM manipuleBn( ltreaid t our domManip,AJAX ingckery	io		cument.h.head.appeddChidd( script[e0 ]r);
}
 e,		
	abt: : nction( s)
		if		 ( !fcel(back )
		if			cel(back();
}
							}	if};	f}	)l);					r i oldCel(backs nu[],		rjsonp =o/(=)\?(?=&|$)|\?\?/;		 AdDault
	ejsonp se& g ts
uery g.ajaxSe&up(o	
	jsonp:e"cal(back"o
/jsonpCel(back: nction( s)
		ifr i cel(back]=eoldCel(backs.p pe{& []seuery g.erpa son+ "_"l+l!fnon(e.guid ) {
);
}
Bhil[ecel(back]] =eurue				tu=n tec l(back;	}}	)l);		 AdD=n(cB,en (melizeuupBn( s a seitsta ? c l(backsnlotousonp reqrysts	uery g.ajaxPrineln( sl"jsonousonp"opnction( sesoptrigi alSe& g ts,
jqXHR )n{			r i c l(backNe, opove:writxtnoptuscs seCoexa tur,	f	jsonPm ru=es.usonp !noulse )  ( ( rjsonpest( mas.urlo) ?		
	"url" :
pupteof els.da o = 1 tring" && e				/! s.coextnaTeofu []"" )	if	m/.+ex oOf! "applicaon f/x-www-n (m-urlencod"d"=) = ou0&
						rjsonpest( mas.da o )  ( "da o"
pu);
re CoHalins iffokheoexciatednda o teof  sl"jsonp"h  orraha opaepseamen(  treset
	 ( !fjsonPm ru doleda oTeofr[e0 ] = 1 tjsonp"h)n{				/EaGe lcel(back]le, oprumemberg"  preexistg"  lues  associat"dnwh thit			c l(backNe, u=es.usonpC l(backl=  sFction( sls.usonpC l(backl) ?		
	s.usonpC l(back()n:	le s.usonpC l(back;

// AdItse:  c l(back intreurlo  of (m da o	if ( !fjsonPm ru) 			}	s[fjsonPm ru
&=rs[fjsonPm ru
.replac);xrusonp, "$1"l+ c l(backNe, &);
}

use {
 ( cas.usonp !noulse ) ) 			}	s.urlo+=oc rqry gest( mas.urlo) ?,"&"n: "?"u)n+ s.usonp + "="l+ c l(backNe, 
			}	
		/EaUse da oecoeve: ( o rereingcv ojsonoaf ( oscript exucuBn( 
o	s.coeve: ( t[+"script json"n] =rnction( s{
	
f		 ( !f!tuscs seCoexa tur,) 				e/jery geerror( c l(backNe, &+ " wafjnotlc lled" )					
		//turn trturcs seCoexa tur[e0 ];	if};	
////vF (ce jsonoda oTeof
e/leda oTeofr[e0 ] =x"json";

// AdItsta ? c l(back
		ove:writxtn =owiow.l[ c l(backNe, &];	ifwiow.l[ c l(backNe, &] =rnction( s{
	
f		tuscs seCoexa tur,=iargum ex(;	if};	
////vCan n-uplnction(  (firesoaf ( ocoeve: ( t)	ifjqXHR.always!fnction( s{
				
	/CoI( pcevious lues  didt beexist - t me ttit	if	 ( !fove:writxtn = oudefined" 
) 
			}	uery gExwiow.ll).reme tPc pelc l(backNe, &);
		
	/CoOe lrwis;erest (edpreexistg"  lues 				
use {
				puwiow.l[ c l(backNe, &] =rove:writxtn;
}
 e		/////vSa ttback as lmee
	// ( !fs[ c l(backNe, &] )&					// AdMake suretthaotre-usg" ekheoupBn( s n'est bescrew e g" s arou s	/// s.usonpC l(backh= origi alSe& g ts.usonpC l(back;

//	//EaSa tte locel(back]le, nf ( fures lus"		
		oldCel(backs.pushslc l(backNe, &);
}
	
		/// CoCa ?  ( it was alnction(  a sewraha opaerercs se
	// ( !ftuscs seCoexa tur, e  sFction( slove:writxtn )&)n{				fove:writxtn!ftuscs seCoexa tur[e0 ]r);
}
 e		///tuscs seCoexa tur,=iove:writxtn =odefined" 
			} );

// AdDelegeBeutrescript	ifturn tr"script";	f}	)l);					 AdSport: IESafari 8nly
		 AdItESafari 8ncument.hs
cateBud via dument.h.impl.gts aon focateBuHTMLDument.h	 Adclowapseesibng anf (mt:
kheosecoed  ne beco =s oechiddrofhkheofarst on .	 AdBecaus" ofhkhat,xBhilosecurity measurethas po]beldisaed" 
ielSafari 8.	 Adhttps://buts.webkit.org/show_but.cgi?id=137337	pport f.cateBuHTMLDument.hg=e(enction( s{
	
fr i body = dument.h.impl.gts aon focateBuHTMLDument.h(]"" ).body;	fbody.+eturHTML =x"<f (m></f (m><f (m></f (m>";	fturn trbody.cniddNeNas.nenh,
 = 1 2;	)l)()
			 AdArgum exh"da o"eshould be ring"  ofh tml	 Adclextxtg(optn( al):oIf scialfisd,hkheofragm exhwh ? bercateBud iteuhildclextxt,	 Addault
	stpo]dument.h	 AdkeepScripts (optn( al):oIf urue,
wh ? includelscripts pssdud iteuhex tml ring" 	uery g.pseseHTML =xnction( slda o,dclextxt,dkeepScripts )&		i ( cateof elda o ! 1 tring" &&) 			}turn tr[];	o}	i ( cateof elclextxtg= 1 tbooan n&&) 			}keepScripts =lclextxt
			clextxtg=llse );	o}	
fr i baseoppsesed,ercripts;

/ ( !f!coettxtg) 		
// CoSt ruscripts oi +eled"lcv ex  alinses lm tobeg anexucuBud immediat"
				 Cobyeusg"  dument.h.impl.gts aon f	if ( !fpport f.cateBuHTMLDument.hg)n{				clextxtg=ldument.h.impl.gts aon focateBuHTMLDument.h(]"" );			
	 AdSetruhexbaselhrefulotokheocateBud dument.h		
	 Adsoeany psesedoel, ts frwh thURLs		
	 Adare b sed othe ledument.h'soURL (gh-2965)	if	basel=lclextxt.cateBuEm.gts ( "base" )					baseohref = dument.h.locaon fohref;				clextxt.head.appeddChidd( basel);
}

use {
				pclextxtg=ldument.h;			}	o}	
	psesedo= rsingnsTag.exuc(pda o );		scripts =l!keepScripts  e [];
re CoSingns tag
/ ( !fpsesedo) 			}turn tr[lclextxt.cateBuEm.gts ( psesed[e1 ] {&];	o}	
	psesedo= buildFragm ex{
[ da o ],dclextxt,dscripts );

/ ( !fscripts  e scripts.nenh,
 ) 
			uery gExscripts ).reme t();	i}	ret =n truery g.merg);x;
, psesedecniddNeNas )		}
			/**
 * Loadnauurl intrea page	 */	uery g.fn.loadn=fnction( s
url, pseams, cel(back )
		ir i reltoror, :eofoptuscs seo
		self e Bhilo
		off = url.+ex oOf! " " );

/ ( !foff >r-1t)n{		/seltoror = ringpAddClowapses
url.slic);xoff {
);
}
url =ndrl.slic);x0,xoff {;		}	re CoIfuio'fjalnction( 
	 ( ca sFction( slpseams ) ) 			i	/CoWjuassumegthaotio'fje locel(back
o	cel(back =lpseams;
}
pseams =adefined" 
			/CoOe lrwis;,hbuildpaepseamoring" 	/}use {
 ( !fpseams 
	]teof elpseams = ou"objtor"l{
			}teof
=l"POST";	o}	re CoIfuwe ha opel, ts frpo]modifE,fmakenuhertuqryst
/ ( !fself.nenh,
 > 0={n{	iouery g.ajax( 			}}url: url,	
		e CoIfu"teof&&r iiaed" ifrdefined" , th st"GET" methodawh ? berus" .
	// AdMake lues  o( uhillfield explicix
sin e
		/ Adus"rocan ove:rids itlthw ugthajaxSe&up method				ue <: :eof  do"GET",	iffda oTeof: " tml",	if	da o:ppseams			} ).d ns(xnction( s
tuscs seTtxtg) 		
////EaSa ttrercs se lotous" itecompleB( c l(back
			turcs se = argum ex(;			}	self. tmls
seltoror ?				// AdIfla
seltoror was scialfisd,hlocaoeekheoright el, ts frineaadummyldiv			// AdExcludelscripts treaid t IE 'P( messn fdDenisd'aerrort			}	uery gEx"<div>" ).appeddExuery g.pseseHTMLs
tuscs seTtxtg) ).nedds
seltoror ) :				// AdOe lrwis;eus" kheoncll tust
						ruscs seTtxtg);

// AdIf uhertuqrysthsucceeds,xBhilonction(  getsl"da o",x"status",x"jqXHR"
o	 Adbuotthlytare ignored becaus" turcs se was set abtve.	io CoIfuio fails,xBhilonction(  getsl"jqXHR",x"status",x"error"			} ).always!fcel(back 
	]nction( s
jqXHR,estatus ) 			}	self.eaes!fnction( s{
		if		cel(back.applyExBhil, turcs se  []; uqXHR.tuscs seTtxt,xstatus,ejqXHR ]n)					
u)				
n{;		)	ret =n truhil
	}
					uery g.erpr.pseudos.animaB(s =llction( s
tm.n={n{	itu=n teuery g.grepExuery g.uimu t,llction( s
fth)
		iftu=n tesl,  enouln.sl, 			} ).nenh,

	}
					uery g.offser =e{		setOffser:llction( s
tm.nopupBn( s, ],) 				r i curPosion s,fcurLeft,fcurCSSTop,fcurTop,fcurOffser,fcurCSSLeft,fcalculeBuPosion s,				posion sg=auery g.csss
tm.nop"posion s"l),	if	curEl,  e uery gExtm.n={,				props =o{}
	

	 AdSetrposion sgfarst,rin-m se eop/lefoiareare& cv ee sls aoncxtm.n	if ( !fposion sg= 1 triaonc"n) 				ftm.nostyle.posion sg=a"relaoive"
			}	
		curOffser 1 curEm.nooffser();
}
curCSSTopg=auery g.csss
tm.nop"top"l);	}	curCSSLeftg=auery g.csss
tm.nop"lefo"l);	}	calculeBuPosion sg=e(eposion sg= 1 tabsoluBu"  []posion sg= 1 tfix"d"=) 
			}	(acurCSSTopg+fcurCSSLeft ).+ex oOf! "auto" ) >r-1
	

	 AdNeedr rebe aed"  recalculeBu]posion sg ( eie lr
// Adtop oi lefoiifraupo]a seposion sg s eie lr absoluBuo  ofix"d
		 ( !fcelculeBuPosion sg)n{				curPosion s 1 curEm.noposion s();
}
	curTop 1 curPosion s.top;
}
	curLeftg=acurPosion s.lefo
	

	
use {
				pcurTop 1 pseseFloat(acurCSSTopg{& []0;
}
	curLeftg=apseseFloat(acurCSSLeft )& []0;
}
}
re/ ( !f sFction( slopBn( s )n) 		
////EaUse uery g.crtendgh s  po]all a modificaon f  elclordg eB=s orgum exh(gh-1848)				optns sg=aoptns s.ll( Extm.nopi, uery g.crtend{
	},fcurOffser {
);
}
}
re/ ( !foptns setop !noll ? {
		if	propsetop = !foptns setop -fcurOffseretop )g+fcurTop;
}
}re/ ( !foptns selefoi!noll ? {
		if	propseleftg=a!foptns selefoi-fcurOffsereleft )&+fcurLeft;
}
}
re/ ( !f"usg" "uineoptns s {
		if	optns seusg" .ll( Extm.nopprops )
	

	
use {
				p ( cateof elpropsetop = 1 tnumber"n) 				f	propsetop +1 tpx"					
		// ( cateof elpropseleftg= 1 tnumber"n) 				f	propseleftg+1 tpx"					
		//curEm.nocsss
props )
			}	o}	);		uery g.fn.prtend{
		
	 Cooffser()erelaoefrabeel, ts 'fjbhrdereboxntret ledument.h origi 
	offser:llction( s
upBn( s )n{		if AdPreservs cna tg"  lotose& lr
// ( caargum ex(.nenh,
 ) 
				tu=n teoptns sg= oudefined" 
?		
	/Bhilo:		
	/Bhileeaes!fnction( s ],) 				e/	uery g.offser.setOffserExBhil, upBn( s, ],);	io	o}u);
}
}
re/r i r(cB,ew t,	io	sl,  e Bhil[e0 ];	
// ( ca!tm.n={n{	if	tu=n t				}	
		/EaRu=n tezerosnlotodiscleniatedna sehidd e (display: t ne) el, ts fr(gh-2310)
		 CoSport: IE 11<=]1nly
				/EaRuntg"  getBou sg" Clit &Rtorhonea			/Eadiscleniatednnodf  thIEethw ad abeerror
// ( ca!tm.nogurClit &Rtors().nenh,
 ) 
				tu=n te{dtop:x0, lefo:x0 }				}	
		/EaGe ldument.h-relaoiveeposion sgbyeaddg"  liewrt:  scrlowntreliewrt: -relaoiveegBCR	iftuct e em.nogetBou sg" Clit &Rtor();
}
w th= tm.noownerDument.h.dault
	View;	}	tu=n te			}	top:xtuctetop +ew t.pageYOffser,		}	lefo:xtucteleftg+ew t.pageXOffser
if};	f},	
	 / posion s()erelaoefrabeel, ts 'fjmargineboxntreits offser rset &'s psddg"  box
///vThifrmorctscs dsntret lebeha ior  elCSS absoluBuoposion sg" 	/posion s: nction( s)
		if ( !f!thil[e0 ]r)n{		/otu=n t				}	
		r i offserPset &, offser, doc,	io	sl,  e Bhil[e0 ],				pset &Offser 1 {dtop:x0, lefo:x0 }		
		/Eaposion s:fix"d el, ts frareaoffser lm tot leliewrt: ,ewhies itself alwaysohas zeroaoffser	if ( !fuery g.csss
tm.nop"posion s"l)g= 1 tfix"d"=) 			i	///vAssumegposion s:fix"d impliefravailaeility  elgetBou sg" Clit &Rtor	if	offser 1 em.nogetBou sg" Clit &Rtor();


	
use {
				poffser 1 Bhileoffser();
	i	///vAccounnulotokheo*real* offser rset &,ewhies can be t ledument.h oreits root el, ts 	i	///vwh stals aoncl( ygposion s"d el, ts  ifridyntlfisd				doc = tm.noownerDument.h;			poffserPset & = tm.nooffserPset &  []doc.dument.hEm.gts ;			pwhid" ( offserPset &  e				/! offserPset & ===ldum.body  dooffserPset & ===ldum.dument.hEm.gts =) 
			}		uery g.csss
offserPset &, "posion s"l)g= 1 triaonc"n) 				}		offserPset & = offserPset &orset &Nes 					
		// ( caoffserPset &  eaoffserPset & ! 1 sl,   eaoffserPset &odeType < = 1 1 )&					// AdInmorrt:at{ bhrders intreits offserx sin e thlytare outsids its coextna origi 
				pset &Offser 1 uery gExoffserPset & )ooffser();
}
		pset &Offseretop +1 uery g.csss
offserPset &, "bhrderTopWid,
",xie, l);	}
		pset &Offsereleftg+1 uery g.csss
offserPset &, "bhrderLeftWid,
",xie, l);	}
	
		/
				/EaSubtractlpset &
offsers a seem.gts =margins	}	tu=n te			}	top:xoffseretop - pset &Offseretop -fuery g.csss
tm.nop"marginTop",xie, l),		}	lefo:xoffsereleftg- pset &Offsereleftg- uery g.csss
tm.nop"marginLeft",xie, l)
if};	f},	
	 / Thifrmethodawh ? tu=n tedument.hEm.gts =iteuhexfoll ag"  m ses:
	 / 1)dF ( theoel, ts e trid(otheoifeame wh tout offserPset &, thifrmethodawh ? tu=n t
	 /    dument.hEm.gts =ofhkheopset &
wiow.l
	 / 2)dF ( theohidd e otodetheded el, ts 	i / 3)dF ( body oi  tml el, ts , ].e. inem se ofhkheo tml nodf - it wh ? tu=n teitself	i /
	 Adbuotthose exceptns s w s  teve:apresentsdrafra tual lif;eus"-m ses
	 Ada semight bepnteridersdrafrm (edpreferaed" tust
	s.	i /
	 AdThifrlogic,ih aevsr,fifjnotlguaranteedna secan chalge ateany pois =iteuhexfures 
	offserPset &: nction( s)
		iftu=n teuhilemapslnction( s{
				er i offserPset & 1 BhileoffserPset &;
	i	/whid" ( offserPset &  e uery g.csss
offserPset &, "posion s"l)g= 1 triaonc"n) 			}		offserPset & = offserPset &ooffserPset &;
}
 e		///tu=n teoffserPset &  []docent.hEm.gts ;			
n{;		)	)l);		 AdCateBu scrlowLeft a sescrlow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 