﻿using Pao.Reports;
using System.Data;
using System.Data.OleDb;


namespace Sample
{
    static class Makeデザイン変更
    {
        public static void SetupData(IReport paoRep, int defIndex)
        {
            //Excel データベースへの接続
            OleDbConnection connection = Util.ConnectExcelDB("zip.xls");

            //データセットへテーブルをセットする。ヘッダと明細の2テーブル
            string SQL = "select * from [郵便番号テーブル$]";

            OleDbDataAdapter dataAdapter = new OleDbDataAdapter(SQL, connection);
            DataSet ds = new DataSet();
            dataAdapter.Fill(ds, "PostTable");

            DataTable table = new DataTable();
            table = ds.Tables["PostTable"];

            int page = 0;
            int line = 999;


            paoRep.LoadDefFile(Util.GetDefFile(defIndex));

            string hDate = System.DateTime.Now.ToString();

            foreach (DataRow row in table.Rows)
            {
                line++;
                if (line > 32)
                { // Head Print
                    if (page != 0) paoRep.PageEnd();

                    page++;

                    paoRep.PageStart();

                    paoRep.Write("日時", hDate);
                    paoRep.Write("ページ", "Page-" + page.ToString());

                    line = 1;

                }

                //Body Print
                paoRep.Write("郵便番号", row["郵便番号"].ToString(), line);
                paoRep.Write("市区町村", row["市区町村"].ToString(), line);
                paoRep.Write("住所", row["住所"].ToString(), line);
                paoRep.Write("横罫線", line);

            }
            paoRep.PageEnd();

            return;
        }
    }
}
